/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RenamePropertyRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RenameTestClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private RenameRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private RenameRefactoring[] renameDelegates;
    private boolean inited = false;

    public RenameTestClassRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        this.treePathHandle = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    @Override
    public Problem checkParameters() {
        if (!this.isRenameTestClass()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.checkParameters())) == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.checkParameters());
    }

    @Override
    public Problem fastCheckParameters() {
        if (!this.isRenameTestClass()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            FileObject delegateFile = (FileObject)delegate.getRefactoringSource().lookup(FileObject.class);
            delegate.setNewName(RenameTestClassRefactoringPlugin.newName(this.treePathHandle.getFileObject(), delegateFile, this.refactoring.getNewName()));
            p = JavaPluginUtils.chainProblems(p, delegate.fastCheckParameters());
            if (p == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.fastCheckParameters());
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        if (!this.isRenameTestClass()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.preCheck())) == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.preCheck(javac));
    }

    public Problem prepare(RefactoringElementsBag reb) {
        if (!this.isRenameTestClass()) {
            return null;
        }
        this.initDelegates();
        this.fireProgressListenerStart(1, this.renameDelegates.length);
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.prepare(reb.getSession()))) != null && p.isFatal()) {
                return p;
            }
            this.fireProgressListenerStep();
        }
        this.fireProgressListenerStop();
        return p;
    }

    private boolean isRenameTestClass() {
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        return renameProps != null && renameProps.isIsRenameTestClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDelegates() {
        if (this.inited) {
            return;
        }
        final LinkedList<RenameRefactoring> renameRefactoringsList = new LinkedList<RenameRefactoring>();
        if (RetoucheUtils.getElementKind(this.treePathHandle) == ElementKind.CLASS) {
            FileObject fileObject = this.treePathHandle.getFileObject();
            Collection testLocators = Lookup.getDefault().lookupAll(TestLocator.class);
            for (final TestLocator testLocator : testLocators) {
                if (!testLocator.appliesTo(fileObject)) continue;
                if (testLocator.asynchronous()) {
                    final ReentrantLock lock = new ReentrantLock();
                    final Condition condition = lock.newCondition();
                    lock.lock();
                    try {
                        testLocator.findOpposite(fileObject, -1, new TestLocator.LocationListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                                lock.lock();
                                try {
                                    RenameTestClassRefactoringPlugin.this.addIfMatch(location, testLocator, fo, renameRefactoringsList);
                                    condition.signalAll();
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        });
                        try {
                            condition.awaitNanos(10000000000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(RenamePropertyRefactoringPlugin.class.getName()).fine("Finding test class took too long, or it was interupted");
                        }
                        continue;
                    }
                    finally {
                        lock.unlock();
                        continue;
                    }
                }
                TestLocator.LocationResult location = testLocator.findOpposite(fileObject, -1);
                this.addIfMatch(location, testLocator, fileObject, renameRefactoringsList);
            }
        }
        this.renameDelegates = renameRefactoringsList.toArray(new RenameRefactoring[0]);
        this.inited = true;
    }

    private static String newName(FileObject testedFile, FileObject testFile, String newName) {
        String testedName = testedFile.getName();
        String testName = testFile.getName();
        return testName.replace(testedName, newName);
    }

    private void addIfMatch(TestLocator.LocationResult location, TestLocator testLocator, FileObject fileObject, LinkedList<RenameRefactoring> renameRefactoringsList) {
        if (location.getFileObject() != null && testLocator.getFileType(location.getFileObject()).equals((Object)TestLocator.FileType.TEST)) {
            RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)location.getFileObject()));
            renameRefactoring.setNewName(RenameTestClassRefactoringPlugin.newName(fileObject, location.getFileObject(), this.refactoring.getNewName()));
            renameRefactoring.setSearchInComments(true);
            renameRefactoringsList.add(renameRefactoring);
        }
    }
}

