/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

public class PullUpTransformer
extends RefactoringVisitor {
    private MemberInfo<ElementHandle<? extends Element>>[] members;
    private Element targetType;
    private PullUpRefactoring refactoring;

    public PullUpTransformer(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
        this.members = refactoring.getMembers();
    }

    @Override
    public void setWorkingCopy(WorkingCopy copy) throws ToPhaseException {
        super.setWorkingCopy(copy);
        this.targetType = this.refactoring.getTargetType().resolve((CompilationInfo)copy);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        boolean classIsAbstract = el.getKind().isInterface();
        ClassTree njuClass = tree;
        if (((Object)el).equals(this.targetType)) {
            ArrayList<String> imports = new ArrayList<String>();
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                    Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
                    imports.add(((Object)element.asType()).toString());
                    njuClass = this.make.addClassImplementsClause(njuClass, (Tree)this.make.Identifier(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy)));
                    this.rewrite(tree, njuClass);
                    continue;
                }
                if (this.members[i].isMakeAbstract()) {
                    if (!classIsAbstract) {
                        classIsAbstract = true;
                        HashSet<Modifier> hashSet = new HashSet<Modifier>(njuClass.getModifiers().getFlags());
                        hashSet.add(Modifier.ABSTRACT);
                        hashSet.remove((Object)Modifier.FINAL);
                        ModifiersTree modifiers = this.make.Modifiers(hashSet);
                        this.rewrite(njuClass.getModifiers(), modifiers);
                    }
                    Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
                    MethodTree method = (MethodTree)this.workingCopy.getTrees().getTree(element);
                    HashSet<Modifier> mod = new HashSet<Modifier>(method.getModifiers().getFlags());
                    mod.add(Modifier.ABSTRACT);
                    mod.remove((Object)Modifier.FINAL);
                    mod.remove((Object)Modifier.SYNCHRONIZED);
                    if (el.getKind().isInterface()) {
                        mod.remove((Object)Modifier.PUBLIC);
                        mod.remove((Object)Modifier.PROTECTED);
                        mod.remove((Object)Modifier.PRIVATE);
                        mod.remove((Object)Modifier.ABSTRACT);
                    }
                    if (mod.contains((Object)Modifier.PRIVATE)) {
                        mod.remove((Object)Modifier.PRIVATE);
                        mod.add(Modifier.PROTECTED);
                    }
                    MethodTree nju = this.make.Method(this.make.Modifiers(mod), (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameters(), method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
                    nju = (MethodTree)genUtils.importFQNs((Tree)nju);
                    RetoucheUtils.copyJavadoc(element, nju, this.workingCopy);
                    njuClass = genUtils.insertClassMember(njuClass, (Tree)nju);
                    this.rewrite(tree, njuClass);
                    continue;
                }
                Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
                TreePath mpath = this.workingCopy.getTrees().getPath(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy));
                Tree newMethodTree = genUtils.importComments(mpath.getLeaf(), mpath.getCompilationUnit());
                newMethodTree = genUtils.importFQNs(newMethodTree);
                if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    Tree m;
                    Tree oldOne;
                    if (this.members[i].getGroup() == MemberInfo.Group.METHOD) {
                        oldOne = (MethodTree)newMethodTree;
                        m = this.make.Method(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), oldOne.getBody(), (ExpressionTree)oldOne.getDefaultValue());
                        RetoucheUtils.copyJavadoc(element, m, this.workingCopy);
                        njuClass = genUtils.insertClassMember(njuClass, m);
                    } else if (this.members[i].getGroup() == MemberInfo.Group.FIELD) {
                        oldOne = (VariableTree)newMethodTree;
                        m = this.make.Variable(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getType(), oldOne.getInitializer());
                        RetoucheUtils.copyJavadoc(element, m, this.workingCopy);
                        njuClass = genUtils.insertClassMember(njuClass, m);
                    } else if (this.members[i].getGroup() == MemberInfo.Group.TYPE) {
                        oldOne = (ClassTree)newMethodTree;
                        m = null;
                        switch (element.getKind()) {
                            case CLASS: {
                                m = this.make.Class(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getExtendsClause(), oldOne.getImplementsClause(), oldOne.getMembers());
                                break;
                            }
                            case INTERFACE: {
                                m = this.make.Interface(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getImplementsClause(), oldOne.getMembers());
                                break;
                            }
                            case ANNOTATION_TYPE: {
                                m = this.make.AnnotationType(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getMembers());
                                break;
                            }
                            case ENUM: {
                                m = this.make.Enum(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getImplementsClause(), oldOne.getMembers());
                            }
                        }
                        RetoucheUtils.copyJavadoc(element, m, this.workingCopy);
                        njuClass = genUtils.insertClassMember(njuClass, m);
                    }
                } else {
                    njuClass = genUtils.insertClassMember(njuClass, newMethodTree);
                }
                this.rewrite(tree, njuClass);
                if (!element.getModifiers().contains((Object)Modifier.ABSTRACT) || classIsAbstract) continue;
                classIsAbstract = true;
                HashSet<Modifier> mod = new HashSet<Modifier>(tree.getModifiers().getFlags());
                mod.add(Modifier.ABSTRACT);
                mod.remove((Object)Modifier.FINAL);
                ModifiersTree modifiers = this.make.Modifiers(mod);
                this.rewrite(tree.getModifiers(), modifiers);
            }
            try {
                if (imports.size() > 0) {
                    CompilationUnitTree newCut = RetoucheUtils.addImports(this.workingCopy.getCompilationUnit(), imports, this.make);
                    this.rewrite(this.workingCopy.getCompilationUnit(), newCut);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                    for (Tree tree2 : njuClass.getImplementsClause()) {
                        Element currentInterface = this.workingCopy.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree2));
                        if (!((Object)currentInterface).equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                        njuClass = this.make.removeClassImplementsClause(njuClass, tree2);
                        this.rewrite(tree, njuClass);
                    }
                    continue;
                }
                Element current = this.workingCopy.getTrees().getElement(this.getCurrentPath());
                Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
                if (!((Object)element.getEnclosingElement()).equals(current)) continue;
                if (classIsAbstract || !this.members[i].isMakeAbstract() || element.getModifiers().contains((Object)Modifier.ABSTRACT) && this.targetType.getKind().isInterface()) {
                    njuClass = this.make.removeClassMember(njuClass, this.workingCopy.getTrees().getTree(element));
                    this.rewrite(tree, njuClass);
                    continue;
                }
                if (!this.members[i].isMakeAbstract() || !element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                MethodTree method = (MethodTree)this.workingCopy.getTrees().getTree(element);
                ModifiersTree mods = this.make.removeModifiersModifier(method.getModifiers(), Modifier.PRIVATE);
                mods = this.make.addModifiersModifier(mods, this.targetType.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PROTECTED);
                this.rewrite(method.getModifiers(), mods);
            }
        }
        return (Tree)super.visitClass(tree, p);
    }
}

