/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin {
    private WhereUsedQuery refactoring;
    private ClasspathInfo cp;
    private TreePathHandle basem;

    public JavaWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject());
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        TreePathHandle handle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (!handle.getFileObject().isValid() || RetoucheUtils.getElementKind(handle) == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        if (handle.getKind() == Tree.Kind.ARRAY_TYPE) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_FindUsagesArrayType"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(final TreePathHandle tph) {
        Scope customScope = (Scope)this.refactoring.getContext().lookup(Scope.class);
        if (customScope != null) {
            HashSet<FileObject> fileSet = new HashSet<FileObject>();
            fileSet.addAll(customScope.getFiles());
            if (!customScope.getSourceRoots().isEmpty()) {
                ClassPath cpath = ClassPathSupport.createClassPath((FileObject[])customScope.getSourceRoots().toArray(new FileObject[0]));
                fileSet.addAll(JavaWhereUsedQueryPlugin.getRelevantFiles(tph, ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)cpath), this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), null));
            }
            HashMap<FileObject, HashSet<NonRecursiveFolder>> folders = new HashMap<FileObject, HashSet<NonRecursiveFolder>>();
            for (NonRecursiveFolder nonRecursiveFolder : customScope.getFolders()) {
                FileObject folder = nonRecursiveFolder.getFolder();
                ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
                FileObject sourceRoot = cp.findOwnerRoot(folder);
                HashSet<NonRecursiveFolder> packages = (HashSet<NonRecursiveFolder>)folders.get(sourceRoot);
                if (packages == null) {
                    packages = new HashSet<NonRecursiveFolder>();
                    folders.put(sourceRoot, packages);
                }
                packages.add(nonRecursiveFolder);
            }
            for (FileObject sourceRoot : folders.keySet()) {
                Set packages = (Set)folders.get(sourceRoot);
                if (packages == null || packages.isEmpty()) continue;
                ClassPath cpath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{sourceRoot});
                fileSet.addAll(JavaWhereUsedQueryPlugin.getRelevantFiles(tph, ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)cpath), this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), packages));
            }
            return fileSet;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
        try {
            source.runWhenScanFinished((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    Element element = tph.resolveElement((CompilationInfo)info);
                    ElementKind kind = element.getKind();
                    if (kind == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isSearchFromBaseClass()) {
                        Collection<ExecutableElement> overridens = RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)info);
                        if (!overridens.isEmpty()) {
                            ExecutableElement el = overridens.iterator().next();
                            assert (el != null);
                            JavaWhereUsedQueryPlugin.this.basem = TreePathHandle.create((Element)el, (CompilationInfo)info);
                            JavaWhereUsedQueryPlugin.this.refactoring.setRefactoringSource(Lookups.fixed((Object[])new Object[]{JavaWhereUsedQueryPlugin.this.basem}));
                        }
                        if (JavaWhereUsedQueryPlugin.this.basem != null && (JavaWhereUsedQueryPlugin.this.basem.getFileObject() == null || JavaWhereUsedQueryPlugin.this.basem.getFileObject().getNameExt().endsWith("class"))) {
                            JavaWhereUsedQueryPlugin.this.cp = RetoucheUtils.getClasspathInfoFor(tph, JavaWhereUsedQueryPlugin.this.basem);
                        } else {
                            JavaWhereUsedQueryPlugin.this.cp = RetoucheUtils.getClasspathInfoFor(JavaWhereUsedQueryPlugin.this.basem);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.cp == null) {
            this.cp = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        }
        Set<FileObject> fileSet = JavaWhereUsedQueryPlugin.getRelevantFiles(this.basem != null ? this.basem : tph, this.cp, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), null);
        return fileSet;
    }

    public static Set<FileObject> getRelevantFiles(final TreePathHandle tph, final ClasspathInfo cpInfo, final boolean isFindSubclasses, final boolean isFindDirectSubclassesOnly, final boolean isFindOverridingMethods, final boolean isFindUsages, Set<NonRecursiveFolder> folders) {
        JavaSource source;
        final ClassIndex idx = cpInfo.getClassIndex();
        final HashSet<FileObject> set = new HashSet<FileObject>();
        final Set<NonRecursiveFolder> packages = folders == null ? Collections.EMPTY_SET : folders;
        FileObject file = tph.getFileObject();
        if (file != null) {
            ClassPath mergedPlatformPath = JavaWhereUsedQueryPlugin.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), ClassPath.getClassPath((FileObject)file, (String)"classpath/boot"));
            ClassPath mergedCompilePath = JavaWhereUsedQueryPlugin.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), ClassPath.getClassPath((FileObject)file, (String)"classpath/compile"));
            ClassPath mergedSourcePath = JavaWhereUsedQueryPlugin.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), ClassPath.getClassPath((FileObject)file, (String)"classpath/source"));
            ClasspathInfo mergedInfo = ClasspathInfo.create((ClassPath)mergedPlatformPath, (ClassPath)mergedCompilePath, (ClassPath)mergedSourcePath);
            source = JavaSource.create((ClasspathInfo)mergedInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
        } else {
            source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        }
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element el = tph.resolveElement((CompilationInfo)info);
                if (el == null) {
                    throw new NullPointerException(String.format("#145291: Cannot resolve handle: %s\n%s", tph, info.getClasspathInfo()));
                }
                HashSet<Object> searchScopeType = new HashSet<Object>(1);
                if (packages.isEmpty()) {
                    searchScopeType.add(ClassIndex.SearchScope.SOURCE);
                } else {
                    final HashSet<String> packageSet = new HashSet<String>(packages.size());
                    for (NonRecursiveFolder nonRecursiveFolder : packages) {
                        String resourceName = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(nonRecursiveFolder.getFolder());
                        packageSet.add(resourceName);
                    }
                    searchScopeType.add(new ClassIndex.SearchScopeType(){

                        public Set<? extends String> getPackages() {
                            return packageSet;
                        }

                        public boolean isSources() {
                            return true;
                        }

                        public boolean isDependencies() {
                            return false;
                        }
                    });
                }
                if (el.getKind().isField()) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), searchScopeType));
                } else if (el.getKind().isClass() || el.getKind().isInterface()) {
                    if (isFindSubclasses || isFindDirectSubclassesOnly) {
                        if (isFindDirectSubclassesOnly) {
                            EnumSet<ClassIndex.SearchKind> searchKind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), searchKind, searchScopeType));
                        } else {
                            set.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(idx, cpInfo, (TypeElement)el));
                        }
                    } else {
                        set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType));
                    }
                } else if (el.getKind() == ElementKind.METHOD && isFindOverridingMethods) {
                    TypeElement type = (TypeElement)el.getEnclosingElement();
                    set.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(idx, cpInfo, type));
                }
                if (el.getKind() == ElementKind.METHOD && isFindUsages) {
                    Set<ElementHandle<TypeElement>> s = RetoucheUtils.getImplementorsAsHandles(idx, cpInfo, (TypeElement)el.getEnclosingElement());
                    for (ElementHandle elementHandle : s) {
                        TypeElement te = (TypeElement)elementHandle.resolve((CompilationInfo)info);
                        if (te == null) continue;
                        for (Element element : te.getEnclosedElements()) {
                            if (!(element instanceof ExecutableElement) || !info.getElements().overrides((ExecutableElement)element, (ExecutableElement)el, te)) continue;
                            set.addAll(idx.getResources(ElementHandle.create((Element)te), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType));
                        }
                    }
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType));
                } else if (el.getKind() == ElementKind.CONSTRUCTOR) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType));
                }
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    private static Collection<FileObject> getImplementorsRecursive(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el) {
        Set<ElementHandle<? extends Element>> implementorsAsHandles = RetoucheUtils.getImplementorsAsHandles(idx, cpInfo, el);
        Collection<FileObject> set = SourceUtilsEx.getFiles(implementorsAsHandles, cpInfo);
        ClassPath source = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> set2 = new ArrayList<FileObject>(set.size());
        for (FileObject fo : set) {
            if (!source.contains(fo)) continue;
            set2.add(fo);
        }
        return set2;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        this.fireProgressListenerStart(1, -1);
        Set<FileObject> a = this.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class));
        this.fireProgressListenerStep(a.size());
        Problem problem = null;
        try {
            this.processFiles(a, new FindTask(elements));
        }
        catch (IOException e) {
            problem = this.createProblemAndLog(null, e);
        }
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public Problem fastCheckParameters() {
        if (((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    private static ClassPath merge(ClassPath ... cps) {
        LinkedHashSet<URL> roots = new LinkedHashSet<URL>();
        for (ClassPath cp : cps) {
            if (cp == null) continue;
            for (ClassPath.Entry entry : cp.entries()) {
                URL root = entry.getURL();
                if (roots.contains(root)) continue;
                roots.add(root);
            }
        }
        return ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
    }

    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private volatile boolean cancelled;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(WorkingCopy compiler) throws IOException {
            if (this.cancelled) {
                return;
            }
            if (compiler.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            TreePathHandle handle = (TreePathHandle)JavaWhereUsedQueryPlugin.this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            Element element = handle.resolveElement((CompilationInfo)compiler);
            if (element == null) {
                ErrorManager.getDefault().log(65536, "element is null for handle " + handle);
                return;
            }
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                FindUsagesVisitor findVisitor = new FindUsagesVisitor(compiler, JavaWhereUsedQueryPlugin.this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS"));
                findVisitor.scan(compiler.getCompilationUnit(), element);
                result.addAll(findVisitor.getUsages());
                for (FindUsagesVisitor.UsageInComment usageInComment : findVisitor.getUsagesInComments()) {
                    this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(usageInComment.from, usageInComment.to, (CompilationInfo)compiler));
                }
            }
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                FindOverridingVisitor override = new FindOverridingVisitor(compiler);
                override.scan(compiler.getCompilationUnit(), element);
                result.addAll(override.getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                FindSubtypesVisitor subtypes = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), compiler);
                subtypes.scan(compiler.getCompilationUnit(), element);
                result.addAll(subtypes.getUsages());
            }
            for (TreePath tree : result) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)compiler, tree));
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }
    }
}

