/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.InlineRefactoring;
import org.netbeans.modules.refactoring.java.plugins.InlineMethodTransformer;
import org.netbeans.modules.refactoring.java.plugins.InlineVariableTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InlineRefactoringPlugin
extends JavaRefactoringPlugin {
    private final InlineRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public InlineRefactoringPlugin(InlineRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        if (this.treePathHandle == null) {
            return null;
        }
        switch (p) {
            case PRECHECK: 
            case FASTCHECKPARAMETERS: {
                return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
            }
            case CHECKPARAMETERS: {
                ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
                JavaSource source = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
                return source;
            }
        }
        throw new IllegalStateException();
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        RefactoringVisitor visitor;
        if (this.treePathHandle == null) {
            return null;
        }
        switch (this.refactoring.getType()) {
            case METHOD: {
                visitor = new InlineMethodTransformer();
                break;
            }
            default: {
                visitor = new InlineVariableTransformer();
            }
        }
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(1, a.size());
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, visitor, this.treePathHandle);
        Problem problem = this.createAndAddElements(a, transform, refactoringElements, this.refactoring);
        this.fireProgressListenerStop();
        if (visitor instanceof InlineMethodTransformer) {
            RefactoringVisitor imt = visitor;
            problem = problem != null ? problem : ((InlineMethodTransformer)imt).getProblem();
        }
        return problem;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = InlineRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementHandle enclosingType = el instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)el)) : ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement(el));
                    set.add(SourceUtils.getFile((ElementHandle)enclosingType, (ClasspathInfo)info.getClasspathInfo()));
                    if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        if (el.getKind() == ElementKind.METHOD) {
                            InlineRefactoringPlugin.this.allMethods = new HashSet();
                            InlineRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                        }
                    } else if (el.getKind().isField()) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el instanceof TypeElement) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el.getKind() == ElementKind.METHOD) {
                        InlineRefactoringPlugin.this.allMethods = new HashSet();
                        InlineRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                        for (ExecutableElement e : RetoucheUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            InlineRefactoringPlugin.this.addMethods(e, set, (CompilationInfo)info, idx);
                        }
                        for (ExecutableElement ov : RetoucheUtils.getOverridenMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            InlineRefactoringPlugin.this.addMethods(ov, set, (CompilationInfo)info, idx);
                            for (ExecutableElement e : RetoucheUtils.getOverridingMethods(ov, (CompilationInfo)info)) {
                                InlineRefactoringPlugin.this.addMethods(e, set, (CompilationInfo)info, idx);
                            }
                        }
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    private void addMethods(ExecutableElement e, Set set, CompilationInfo info, ClassIndex idx) {
        ElementHandle encl = ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement((Element)e));
        set.add(SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)e), (ClasspathInfo)info.getClasspathInfo()));
        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        this.allMethods.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)e));
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        Problem preCheckProblem = null;
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)javac);
        preCheckProblem = InlineRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(element, (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        switch (element.getKind()) {
            case FIELD: 
            case LOCAL_VARIABLE: {
                NewArrayTree newArrayTree;
                UnsafeTreeScanner scanner;
                Boolean isChanged;
                VariableTree variableTree;
                Tree tree = javac.getTrees().getTree(element);
                if (!tree.getKind().equals((Object)Tree.Kind.VARIABLE)) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineWrongType", (Object)element.getKind().toString()));
                }
                if ((variableTree = (VariableTree)tree).getInitializer() == null) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineNoVarInitializer"));
                    return preCheckProblem;
                }
                if (variableTree.getInitializer().getKind() == Tree.Kind.NULL_LITERAL) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineNullVarInitializer"));
                    return preCheckProblem;
                }
                InlineUsageVisitor visitor = new InlineUsageVisitor(javac);
                TreePath elementPath = javac.getTrees().getPath(element);
                TreePath blockPath = elementPath.getParentPath();
                visitor.scan(blockPath.getLeaf(), element);
                if (visitor.assignmentCount > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineAssignedOnce"));
                    return preCheckProblem;
                }
                if (visitor.usageCount <= 1) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"WRN_InlineNotUsed"));
                }
                ExpressionTree initializer = variableTree.getInitializer();
                int skipFirstMethodInvocation = 0;
                if (initializer.getKind().equals((Object)Tree.Kind.METHOD_INVOCATION)) {
                    ++skipFirstMethodInvocation;
                }
                if ((isChanged = (Boolean)(scanner = new UnsafeTreeScanner(skipFirstMethodInvocation)).scan(initializer, Boolean.valueOf(false))) != null && isChanged.booleanValue()) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"WRN_InlineChange"));
                }
                TreePath treePath = this.treePathHandle.resolve((CompilationInfo)javac);
                Tree loop = (treePath = treePath.getParentPath()).getLeaf();
                if (loop.getKind() == Tree.Kind.ENHANCED_FOR_LOOP || loop.getKind() == Tree.Kind.FOR_LOOP) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineNotInIterator"));
                    return preCheckProblem;
                }
                if (variableTree.getInitializer().getKind() != Tree.Kind.NEW_ARRAY || (newArrayTree = (NewArrayTree)variableTree.getInitializer()).getType() != null && newArrayTree.getDimensions() != null) break;
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineNotCompoundArrayInit"));
                return preCheckProblem;
            }
            case METHOD: {
                InlineUsageVisitor visitorMethod = new InlineUsageVisitor(javac);
                visitorMethod.scan(javac.getCompilationUnit(), element);
                if (visitorMethod.usageCount <= 1) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, false, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"WRN_InlineNotUsed"));
                }
                Collection<ExecutableElement> overridenMethods = RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)javac);
                Collection<ExecutableElement> overridingMethods = RetoucheUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)javac);
                if (overridenMethods.size() > 0 || overridingMethods.size() > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodPolymorphic"));
                    return preCheckProblem;
                }
                TreePath methodPath = javac.getTrees().getPath(element);
                MethodTree methodTree = (MethodTree)methodPath.getLeaf();
                Tree returnType = methodTree.getReturnType();
                boolean hasReturn = true;
                if (returnType.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && ((PrimitiveTypeTree)returnType).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
                    hasReturn = false;
                }
                InlineMethodVisitor methodVisitor = new InlineMethodVisitor(javac, element.getModifiers());
                methodVisitor.scan(methodPath.getLeaf(), element);
                if (hasReturn) {
                    if (methodVisitor.nrOfReturnStatements > 1) {
                        preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodMultipleReturn"));
                        return preCheckProblem;
                    }
                    StatementTree lastStatement = methodTree.getBody().getStatements().get(methodTree.getBody().getStatements().size() - 1);
                    if (!lastStatement.getKind().equals((Object)Tree.Kind.RETURN)) {
                        preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodNoLastReturn"));
                        return preCheckProblem;
                    }
                } else if (methodVisitor.nrOfReturnStatements > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodVoidReturn"));
                    return preCheckProblem;
                }
                if (methodVisitor.isRecursive) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodRecursion"));
                    return preCheckProblem;
                }
                if (methodVisitor.qualIdentProblem) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodLocalAccessors"));
                    return preCheckProblem;
                }
                if (!methodVisitor.accessorRightProblem) break;
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodNoAccessors"));
                return preCheckProblem;
            }
            default: {
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineWrongType", (Object)element.getKind().toString()));
            }
        }
        return preCheckProblem;
    }

    private static class UnsafeTreeScanner
    extends TreeScanner<Boolean, Boolean> {
        private int skipFirstMethodInvocation;

        public UnsafeTreeScanner(int skipFirstMethodInvocation) {
            this.skipFirstMethodInvocation = skipFirstMethodInvocation;
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree node, Boolean p) {
            if (this.skipFirstMethodInvocation > 0) {
                --this.skipFirstMethodInvocation;
                return (Boolean)super.visitMethodInvocation(node, p);
            }
            return true;
        }

        @Override
        public Boolean visitNewClass(NewClassTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean visitNewArray(NewArrayTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean visitAssignment(AssignmentTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean visitUnary(UnaryTree node, Boolean p) {
            return true;
        }

        @Override
        public Boolean reduce(Boolean left, Boolean right) {
            return left != null && left != false || right != null && right != false;
        }
    }

    private class InlineUsageVisitor
    extends CancellableTreeScanner<Tree, Element> {
        public int assignmentCount = 0;
        public int usageCount = 0;
        private final CompilationController workingCopy;

        public InlineUsageVisitor(CompilationController workingCopy) {
            this.workingCopy = workingCopy;
        }

        public Tree visitVariable(VariableTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                ++this.usageCount;
            }
            return (Tree)super.visitVariable(node, (Object)p);
        }

        public Tree visitMemberSelect(MemberSelectTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMemberSelect(node, (Object)p);
        }

        public Tree visitIdentifier(IdentifierTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                ++this.usageCount;
            }
            return (Tree)super.visitIdentifier(node, (Object)p);
        }

        public Tree visitMethod(MethodTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMethod(node, (Object)p);
        }

        public Tree visitMethodInvocation(MethodInvocationTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMethodInvocation(node, (Object)p);
        }

        public Tree visitAssignment(AssignmentTree node, Element p) {
            if (((Object)p).equals(this.asElement(node.getVariable()))) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitAssignment(node, (Object)p);
        }

        public Tree visitCompoundAssignment(CompoundAssignmentTree node, Element p) {
            if (((Object)p).equals(this.asElement(node.getVariable()))) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitCompoundAssignment(node, (Object)p);
        }

        public Tree visitUnary(UnaryTree node, Element p) {
            if (((Object)p).equals(this.asElement(node.getExpression()))) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitUnary(node, (Object)p);
        }

        private Element asElement(Tree tree) {
            Trees treeUtil = this.workingCopy.getTrees();
            TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
            Element element = treeUtil.getElement(treePath);
            return element;
        }
    }

    private class InlineMethodVisitor
    extends CancellableTreeScanner<Tree, Element> {
        public int nrOfReturnStatements = 0;
        public boolean isRecursive = false;
        private boolean accessorRightProblem = false;
        private boolean qualIdentProblem = false;
        private final CompilationController workingCopy;
        private final Modifier access;

        public InlineMethodVisitor(CompilationController workingCopy, Set<Modifier> modifiers) {
            this.workingCopy = workingCopy;
            this.access = this.getAccessSpecifier(modifiers);
        }

        public Tree visitReturn(ReturnTree node, Element p) {
            ++this.nrOfReturnStatements;
            return (Tree)super.visitReturn(node, (Object)p);
        }

        public Tree visitMethodInvocation(MethodInvocationTree node, Element p) {
            if (((Object)p).equals(this.asElement(node))) {
                this.isRecursive = true;
            } else {
                Element asElement = this.asElement(node);
                if (asElement.getKind().equals((Object)ElementKind.FIELD) || asElement.getKind().equals((Object)ElementKind.METHOD) || asElement.getKind().equals((Object)ElementKind.CLASS)) {
                    Modifier mod = this.getAccessSpecifier(this.asElement(node).getModifiers());
                    this.accessorRightProblem = this.hasAccessorRightProblem(mod);
                    this.qualIdentProblem = this.hasQualIdentProblem(p, node);
                }
            }
            return (Tree)super.visitMethodInvocation(node, (Object)p);
        }

        private boolean hasQualIdentProblem(Element p, Tree node) throws IllegalArgumentException {
            TypeElement invocationEnclosingTypeElement;
            boolean result = this.qualIdentProblem;
            Element asElement = this.asElement(node);
            ElementUtilities elementUtilities = this.workingCopy.getElementUtilities();
            TypeElement bodyEnclosingTypeElement = elementUtilities.enclosingTypeElement(p);
            if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(asElement)) && (this.access == null || !this.access.equals((Object)Modifier.PRIVATE))) {
                result = true;
            }
            return result;
        }

        private boolean hasAccessorRightProblem(Modifier mod) {
            boolean hasProblem;
            block8: {
                block7: {
                    hasProblem = this.accessorRightProblem;
                    if (this.access == null) break block7;
                    switch (this.access) {
                        case PUBLIC: {
                            if (mod == null || Modifier.PROTECTED.equals((Object)mod) || Modifier.PRIVATE.equals((Object)mod)) {
                                hasProblem = true;
                                break;
                            }
                            break block8;
                        }
                        case PROTECTED: {
                            if (mod == null || Modifier.PRIVATE.equals((Object)mod)) {
                                hasProblem = true;
                                break;
                            }
                            break block8;
                        }
                    }
                    break block8;
                }
                if (Modifier.PRIVATE.equals((Object)mod)) {
                    hasProblem = true;
                }
            }
            return hasProblem;
        }

        private Modifier getAccessSpecifier(Set<Modifier> modifiers) {
            Modifier mod = null;
            for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: 
                    case PROTECTED: 
                    case PRIVATE: {
                        mod = modifier;
                    }
                }
            }
            return mod;
        }

        public Tree visitIdentifier(IdentifierTree node, Element p) {
            Element asElement = this.asElement(node);
            if (asElement.getKind().equals((Object)ElementKind.FIELD) || asElement.getKind().equals((Object)ElementKind.METHOD) || asElement.getKind().equals((Object)ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(this.asElement(node).getModifiers());
                this.accessorRightProblem = this.hasAccessorRightProblem(mod);
                this.qualIdentProblem = this.hasQualIdentProblem(p, node);
            }
            return (Tree)super.visitIdentifier(node, (Object)p);
        }

        public Tree visitNewClass(NewClassTree node, Element p) {
            Element asElement = this.asElement(node);
            if (asElement.getKind().equals((Object)ElementKind.FIELD) || asElement.getKind().equals((Object)ElementKind.METHOD) || asElement.getKind().equals((Object)ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(this.asElement(node).getModifiers());
                this.accessorRightProblem = this.hasAccessorRightProblem(mod);
                this.qualIdentProblem = this.hasQualIdentProblem(p, node);
            }
            return (Tree)super.visitNewClass(node, (Object)p);
        }

        public Tree visitMemberSelect(MemberSelectTree node, Element p) {
            Element asElement = this.asElement(node);
            if (asElement.getKind().equals((Object)ElementKind.FIELD) || asElement.getKind().equals((Object)ElementKind.METHOD) || asElement.getKind().equals((Object)ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(this.asElement(node).getModifiers());
                this.accessorRightProblem = this.hasAccessorRightProblem(mod);
                this.qualIdentProblem = this.hasQualIdentProblem(p, node);
            }
            return (Tree)super.visitMemberSelect(node, (Object)p);
        }

        private Element asElement(Tree tree) {
            Trees treeUtil = this.workingCopy.getTrees();
            TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
            Element element = treeUtil.getElement(treePath);
            return element;
        }
    }
}

