/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.InlineAbstractTransformer;
import org.netbeans.modules.refactoring.java.plugins.OperatorPrecedence;

class InlineParametersTransformerVisitor
extends TreeScanner<Tree, Element> {
    private final TreeMaker make;
    private InlineAbstractTransformer iptv;
    private BlockTree body;
    private final Map<Element, ExpressionTree> values;
    private final Trees trees;
    private final CompilationUnitTree cut;
    private boolean initialized;
    private WorkingCopy workingcopy;

    public InlineParametersTransformerVisitor(TreeMaker make, BlockTree body, Map<Element, ExpressionTree> values, Trees trees, WorkingCopy workingcopy) {
        this.make = make;
        this.body = body;
        this.values = values;
        this.trees = trees;
        this.cut = workingcopy.getCompilationUnit();
        this.workingcopy = workingcopy;
    }

    @Override
    public Tree scan(Tree tree, Element p) {
        if (!this.initialized) {
            this.initialized = true;
            this.iptv = new InlineAbstractTransformer(this.make){

                @Override
                protected ExpressionTree replaceExpression(ExpressionTree expressionTree) {
                    TreePath path = InlineParametersTransformerVisitor.this.trees.getPath(InlineParametersTransformerVisitor.this.cut, expressionTree);
                    Element element = InlineParametersTransformerVisitor.this.trees.getElement(path);
                    ExpressionTree expressionBody = (ExpressionTree)InlineParametersTransformerVisitor.this.values.get(element);
                    boolean parenthesize = OperatorPrecedence.needsParentheses(path, expressionTree, expressionBody, InlineParametersTransformerVisitor.this.workingcopy);
                    if (parenthesize) {
                        expressionBody = this.make.Parenthesized(expressionBody);
                    }
                    return expressionBody;
                }

                @Override
                protected List<StatementTree> replaceStatement(StatementTree statementTree, ExpressionTree node, boolean needBlock) {
                    LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
                    switch (statementTree.getKind()) {
                        case ASSERT: {
                            ExpressionTree assertDetail;
                            AssertTree assertTree = (AssertTree)statementTree;
                            ExpressionTree assertCondition = assertTree.getCondition();
                            if (assertCondition != null) {
                                assertCondition = assertCondition.equals(node) ? this.replaceExpression(assertCondition) : this.replacesExpression(assertCondition, node);
                            }
                            if ((assertDetail = assertTree.getDetail()) != null) {
                                assertDetail = assertDetail.equals(node) ? this.replaceExpression(assertDetail) : this.replacesExpression(assertDetail, node);
                            }
                            newStatementList.add(this.make.Assert(assertCondition, assertDetail));
                            break;
                        }
                        case DO_WHILE_LOOP: {
                            DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)statementTree;
                            ExpressionTree doWhileCondition = doWhileLoopTree.getCondition();
                            if (doWhileCondition != null) {
                                doWhileCondition = doWhileCondition.equals(node) ? this.replaceExpression(doWhileCondition) : this.replacesExpression(doWhileCondition, node);
                            }
                            newStatementList.add(this.make.DoWhileLoop(doWhileCondition, doWhileLoopTree.getStatement()));
                            break;
                        }
                        case ENHANCED_FOR_LOOP: {
                            EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)statementTree;
                            ExpressionTree enhancedForLoopExpression = enhancedForLoopTree.getExpression();
                            if (enhancedForLoopExpression != null) {
                                enhancedForLoopExpression = enhancedForLoopExpression.equals(node) ? this.replaceExpression(enhancedForLoopExpression) : this.replacesExpression(enhancedForLoopExpression, node);
                            }
                            newStatementList.add(this.make.EnhancedForLoop(enhancedForLoopTree.getVariable(), enhancedForLoopExpression, enhancedForLoopTree.getStatement()));
                            break;
                        }
                        case EXPRESSION_STATEMENT: {
                            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
                            ExpressionTree expression = expressionStatementTree.getExpression();
                            if (expression != null) {
                                expression = expression.equals(node) ? this.replaceExpression(expression) : this.replacesExpression(expression, node);
                            }
                            newStatementList.add(this.make.ExpressionStatement(expression));
                            break;
                        }
                        case FOR_LOOP: {
                            ForLoopTree forLoopTree = (ForLoopTree)statementTree;
                            ExpressionTree forLoopCondition = forLoopTree.getCondition();
                            if (forLoopCondition != null) {
                                forLoopCondition = forLoopCondition.equals(node) ? this.replaceExpression(forLoopCondition) : this.replacesExpression(forLoopCondition, node);
                            }
                            newStatementList.add(this.make.ForLoop(forLoopTree.getInitializer(), forLoopCondition, forLoopTree.getUpdate(), forLoopTree.getStatement()));
                            break;
                        }
                        case IF: {
                            IfTree ifTree = (IfTree)statementTree;
                            ExpressionTree ifTreeCondition = ifTree.getCondition();
                            if (ifTreeCondition != null) {
                                ifTreeCondition = ifTreeCondition.equals(node) ? this.replaceExpression(ifTreeCondition) : this.replacesExpression(ifTreeCondition, node);
                            }
                            newStatementList.add(this.make.If(ifTreeCondition, ifTree.getThenStatement(), ifTree.getElseStatement()));
                            break;
                        }
                        case RETURN: {
                            ReturnTree returnTree = (ReturnTree)statementTree;
                            ExpressionTree returnExpression = returnTree.getExpression();
                            if (returnExpression != null) {
                                returnExpression = returnExpression.equals(node) ? this.replaceExpression(returnExpression) : this.replacesExpression(returnExpression, node);
                            }
                            newStatementList.add(this.make.Return(returnExpression));
                            break;
                        }
                        case SWITCH: {
                            SwitchTree switchTree = (SwitchTree)statementTree;
                            ExpressionTree switchTreeExpression = switchTree.getExpression();
                            if (switchTreeExpression != null) {
                                switchTreeExpression = switchTreeExpression.equals(node) ? this.replaceExpression(switchTreeExpression) : this.replacesExpression(switchTreeExpression, node);
                            }
                            newStatementList.add(this.make.Switch(switchTreeExpression, switchTree.getCases()));
                            break;
                        }
                        case SYNCHRONIZED: {
                            SynchronizedTree synchronizedTree = (SynchronizedTree)statementTree;
                            ExpressionTree synchronizedTreeExpression = synchronizedTree.getExpression();
                            if (synchronizedTreeExpression != null) {
                                synchronizedTreeExpression = synchronizedTreeExpression.equals(node) ? this.replaceExpression(synchronizedTreeExpression) : this.replacesExpression(synchronizedTreeExpression, node);
                            }
                            newStatementList.add(this.make.Synchronized(synchronizedTreeExpression, synchronizedTree.getBlock()));
                            break;
                        }
                        case THROW: {
                            ThrowTree throwTree = (ThrowTree)statementTree;
                            ExpressionTree throwExpression = throwTree.getExpression();
                            if (throwExpression != null) {
                                throwExpression = throwExpression.equals(node) ? this.replaceExpression(throwExpression) : this.replacesExpression(throwExpression, node);
                            }
                            newStatementList.add(this.make.Throw(throwExpression));
                            break;
                        }
                        case VARIABLE: {
                            VariableTree variableTree = (VariableTree)statementTree;
                            ExpressionTree variableInitializer = variableTree.getInitializer();
                            if (variableInitializer != null) {
                                variableInitializer = variableInitializer.equals(node) ? this.replaceExpression(variableInitializer) : this.replacesExpression(variableInitializer, node);
                            }
                            newStatementList.add(this.make.Variable(variableTree.getModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), variableInitializer));
                            break;
                        }
                        case WHILE_LOOP: {
                            WhileLoopTree whileLoopTree = (WhileLoopTree)statementTree;
                            ExpressionTree whileLoopCondition = whileLoopTree.getCondition();
                            if (whileLoopCondition != null) {
                                whileLoopCondition = whileLoopCondition.equals(node) ? this.replaceExpression(whileLoopCondition) : this.replacesExpression(whileLoopCondition, node);
                            }
                            newStatementList.add(this.make.WhileLoop(whileLoopCondition, whileLoopTree.getStatement()));
                        }
                    }
                    if (needBlock) {
                        BlockTree block = this.make.Block(newStatementList, false);
                        ArrayList<StatementTree> list = new ArrayList<StatementTree>(1);
                        list.add(block);
                        return list;
                    }
                    return newStatementList;
                }
            };
        }
        return (Tree)super.scan(tree, p);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        TreePath currentPath = this.trees.getPath(this.cut, node);
        Element el = this.trees.getElement(currentPath);
        if (((Object)p).equals(el)) {
            TreePath statementPath = currentPath;
            boolean foundStatement = false;
            while (!foundStatement) {
                statementPath = statementPath.getParentPath();
                switch (statementPath.getLeaf().getKind()) {
                    case ASSERT: 
                    case DO_WHILE_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case EXPRESSION_STATEMENT: 
                    case FOR_LOOP: 
                    case IF: 
                    case RETURN: 
                    case SWITCH: 
                    case SYNCHRONIZED: 
                    case THROW: 
                    case VARIABLE: 
                    case WHILE_LOOP: 
                    case BLOCK: 
                    case BREAK: 
                    case CLASS: 
                    case CONTINUE: 
                    case EMPTY_STATEMENT: 
                    case LABELED_STATEMENT: 
                    case TRY: {
                        foundStatement = true;
                    }
                }
            }
            this.body = this.iptv.replaceStatement(this.body, statementPath, (ExpressionTree)node);
        }
        return (Tree)super.visitIdentifier(node, p);
    }

    BlockTree getBody() {
        return this.body;
    }
}

