/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class ExtractInterfaceRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractInterfaceRefactoring refactoring;
    private String pkgName;
    private ElementHandle<TypeElement> classHandle;

    ExtractInterfaceRefactoringPlugin(ExtractInterfaceRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getInterfaceName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag bag) {
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        try {
            bag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CreateInterfaceElement(this.refactoring, primFile.getParent(), this.classHandle));
            UpdateClassTask.create(bag, primFile, this.refactoring, this.classHandle);
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 1);
        javac.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle sourceType = this.refactoring.getSourceType();
            Problem result = ExtractInterfaceRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Element sourceElm = sourceType.resolveElement((CompilationInfo)javac);
            result = JavaPluginUtils.isSourceElement(sourceElm, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (sourceElm == null || sourceElm.getKind() != ElementKind.CLASS && sourceElm.getKind() != ElementKind.INTERFACE && sourceElm.getKind() != ElementKind.ENUM) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)sourceElm));
            PackageElement pkgElm = (PackageElement)javac.getElementUtilities().outermostTypeElement(sourceElm).getEnclosingElement();
            this.pkgName = pkgElm.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        Set<Modifier> mods;
        Element elm;
        if (this.refactoring.getMethods().isEmpty() && this.refactoring.getFields().isEmpty() && this.refactoring.getImplements().isEmpty()) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_MembersNotAvailable"));
        }
        javac.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        assert (sourceType != null);
        HashSet<? extends Element> members = new HashSet<Element>(sourceType.getEnclosedElements());
        for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
            elm = (ExecutableElement)elementHandle.resolve((CompilationInfo)javac);
            if (elm == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (javac.getElementUtilities().isSynthetic(elm) || elm.getKind() != ElementKind.METHOD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            if (!members.contains(elm)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            mods = elm.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC) && !mods.contains((Object)Modifier.STATIC)) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)elm.getSimpleName().toString()));
        }
        for (ElementHandle elementHandle : this.refactoring.getFields()) {
            VariableTree tree;
            elm = (VariableElement)elementHandle.resolve((CompilationInfo)javac);
            if (elm == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (javac.getElementUtilities().isSynthetic(elm) || elm.getKind() != ElementKind.FIELD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            if (!members.contains(elm)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)elm.toString()));
            }
            mods = elm.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC) && mods.contains((Object)Modifier.STATIC) && mods.contains((Object)Modifier.FINAL) && (tree = (VariableTree)javac.getTrees().getTree(elm)).getInitializer() != null) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)elm.getSimpleName().toString()));
        }
        return null;
    }

    private static List<TypeMirror> findUsedGenericTypes(ExtractInterfaceRefactoring refactoring, CompilationInfo javac, TypeElement javaClass) {
        ElementHandle<ExecutableElement> handle;
        List<TypeMirror> typeArgs = RetoucheUtils.resolveTypeParamsAsTypes(javaClass.getTypeParameters());
        if (typeArgs.isEmpty()) {
            return typeArgs;
        }
        Types typeUtils = javac.getTypes();
        Set<TypeMirror> used = Collections.newSetFromMap(new IdentityHashMap());
        Iterator<ElementHandle<ExecutableElement>> methodIter = refactoring.getMethods().iterator();
        while (methodIter.hasNext() && !typeArgs.isEmpty()) {
            handle = methodIter.next();
            ExecutableElement elm = (ExecutableElement)handle.resolve(javac);
            RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, elm.getReturnType());
            Iterator<? extends VariableElement> paramIter = elm.getParameters().iterator();
            while (paramIter.hasNext() && !typeArgs.isEmpty()) {
                VariableElement param = paramIter.next();
                RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, param.asType());
            }
        }
        Iterator<TypeMirrorHandle<TypeMirror>> it = refactoring.getImplements().iterator();
        while (it.hasNext() && !typeArgs.isEmpty()) {
            handle = it.next();
            TypeMirror implemetz = handle.resolve(javac);
            RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, implemetz);
        }
        return RetoucheUtils.filterTypes(typeArgs, used);
    }

    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractInterfaceRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractInterfaceRefactoring refactoring, ElementHandle<TypeElement> sourceType) {
            this.sourceType = sourceType;
            this.refactoring = refactoring;
        }

        public static void create(RefactoringElementsBag bag, FileObject fo, ExtractInterfaceRefactoring refactoring, ElementHandle<TypeElement> sourceType) throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            ModificationResult modification = js.runModificationTask((Task)new UpdateClassTask(refactoring, sourceType));
            List diffs = modification.getDifferences(fo);
            for (ModificationResult.Difference diff : diffs) {
                bag.add((AbstractRefactoring)refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modification));
            }
            bag.registerTransaction(JavaRefactoringPlugin.createTransaction(Collections.singletonList(modification)));
        }

        public void cancel() {
        }

        /*
         * WARNING - void declaration
         */
        public void run(WorkingCopy wc) throws Exception {
            void var11_17;
            Tree interfaceTree;
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement clazz = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            assert (clazz != null);
            ClassTree classTree = wc.getTrees().getTree(clazz);
            TreeMaker maker = wc.getTreeMaker();
            List typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)wc, clazz);
            if (typeParams.isEmpty()) {
                interfaceTree = maker.Identifier((CharSequence)this.refactoring.getInterfaceName());
            } else {
                ArrayList<ExpressionTree> typeParamTrees = new ArrayList<ExpressionTree>(typeParams.size());
                for (TypeMirror typeParam : typeParams) {
                    Tree t = maker.Type(typeParam);
                    typeParamTrees.add((ExpressionTree)t);
                }
                interfaceTree = maker.ParameterizedType((Tree)maker.Identifier((CharSequence)this.refactoring.getInterfaceName()), typeParamTrees);
            }
            HashSet<Tree> members2Remove = new HashSet<Tree>();
            HashSet<Tree> interfaces2Remove = new HashSet<Tree>();
            members2Remove.addAll(this.getFields2Remove((CompilationInfo)wc, this.refactoring.getFields()));
            members2Remove.addAll(this.getMethods2Remove((CompilationInfo)wc, this.refactoring.getMethods(), clazz));
            interfaces2Remove.addAll(this.getImplements2Remove((CompilationInfo)wc, this.refactoring.getImplements(), clazz));
            for (ElementHandle<ExecutableElement> el : this.refactoring.getMethods()) {
                MethodTree tree;
                ExecutableElement executableElement = (ExecutableElement)el.resolve((CompilationInfo)wc);
                MethodTree mt = tree = wc.getTrees().getTree(executableElement);
                if (executableElement.getAnnotation(Override.class) != null) continue;
                TreeMaker make = wc.getTreeMaker();
                AnnotationTree ann = make.Annotation((Tree)make.Identifier((CharSequence)"Override"), Collections.emptyList());
                ModifiersTree modifiers = wc.getTreeMaker().addModifiersAnnotation(mt.getModifiers(), ann);
                wc.rewrite((Tree)mt.getModifiers(), (Tree)modifiers);
            }
            ArrayList<Tree> members2Add = new ArrayList<Tree>();
            for (Tree tree : classTree.getMembers()) {
                if (members2Remove.contains(tree)) continue;
                members2Add.add(tree);
            }
            List<Tree> impls2Add = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), interfaces2Remove, interfaceTree);
            if (clazz.getKind() == ElementKind.CLASS) {
                ClassTree classTree2 = maker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), impls2Add, members2Add);
            } else if (clazz.getKind() == ElementKind.INTERFACE) {
                ClassTree classTree3 = maker.Interface(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), impls2Add, members2Add);
            } else if (clazz.getKind() == ElementKind.ENUM) {
                ClassTree classTree4 = maker.Enum(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), impls2Add, members2Add);
            } else {
                throw new IllegalStateException(classTree.toString());
            }
            wc.rewrite((Tree)classTree, (Tree)var11_17);
        }

        private List<Tree> getFields2Remove(CompilationInfo javac, List<ElementHandle<VariableElement>> members) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(members.size());
            for (ElementHandle<VariableElement> handle : members) {
                VariableElement elm = (VariableElement)handle.resolve(javac);
                assert (elm != null);
                Tree t = javac.getTrees().getTree(elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getMethods2Remove(CompilationInfo javac, List<ElementHandle<ExecutableElement>> members, TypeElement clazz) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            boolean isInterface = clazz.getKind() == ElementKind.INTERFACE;
            ArrayList<Tree> result = new ArrayList<Tree>(members.size());
            for (ElementHandle<ExecutableElement> handle : members) {
                ExecutableElement elm = (ExecutableElement)handle.resolve(javac);
                assert (elm != null);
                if (!isInterface && !elm.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                MethodTree t = javac.getTrees().getTree(elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getImplements2Remove(CompilationInfo javac, List<TypeMirrorHandle<TypeMirror>> members, TypeElement clazz) {
            if (members.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> memberTypes = new ArrayList<TypeMirror>(members.size());
            for (TypeMirrorHandle<TypeMirror> handle : members) {
                TypeMirror tm = handle.resolve(javac);
                memberTypes.add(tm);
            }
            ClassTree classTree = javac.getTrees().getTree(clazz);
            ArrayList<Tree> result = new ArrayList<Tree>();
            Types types = javac.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror existingTM = javac.getTrees().getTypeMirror(path);
                for (TypeMirror tm : memberTypes) {
                    if (!types.isSameType(tm, existingTM)) continue;
                    result.add(tree);
                    continue block1;
                }
            }
            return result;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> allImpls, Set<Tree> impls2Remove, Tree impl2Add) {
            ArrayList<Tree> ret;
            if (allImpls == null) {
                ret = new ArrayList<Tree>(1);
            } else {
                ret = new ArrayList(allImpls.size() + 1);
                ret.addAll(allImpls);
            }
            if (impls2Remove != null && !impls2Remove.isEmpty()) {
                ret.removeAll(impls2Remove);
            }
            ret.add(impl2Add);
            return ret;
        }
    }

    private static final class CreateInterfaceElement
    extends SimpleRefactoringElementImplementation
    implements CancellableTask<WorkingCopy> {
        private final URL folderURL;
        private URL ifcURL;
        private final String ifcName;
        private final ExtractInterfaceRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private CreateInterfaceElement(ExtractInterfaceRefactoring refactoring, FileObject folder, ElementHandle<TypeElement> sourceType) {
            this.refactoring = refactoring;
            this.folderURL = URLMapper.findURL((FileObject)folder, (int)0);
            this.ifcName = refactoring.getInterfaceName();
            this.sourceType = sourceType;
        }

        public void performChange() {
            try {
                FileObject folderFO = URLMapper.findFileObject((URL)this.folderURL);
                if (folderFO == null) {
                    return;
                }
                FileObject tempFO = FileUtil.getConfigFile((String)"Templates/Classes/Interface.java");
                DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                DataObject template = DataObject.find((FileObject)tempFO);
                DataObject newIfcDO = template.createFromTemplate(folder, this.ifcName);
                this.ifcURL = URLMapper.findURL((FileObject)newIfcDO.getPrimaryFile(), (int)0);
                this.refactoring.getContext().add((Object)newIfcDO.getPrimaryFile());
                JavaSource js = JavaSource.forFileObject((FileObject)newIfcDO.getPrimaryFile());
                js.runModificationTask((Task)this).commit();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            FileObject ifcFO = null;
            if (this.ifcURL != null) {
                ifcFO = URLMapper.findFileObject((URL)this.ifcURL);
            }
            if (ifcFO != null) {
                try {
                    ifcFO.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public String getText() {
            return NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"TXT_ExtractInterface_CreateIfc", (Object)this.ifcName);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.folderURL);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            FileObject fo = this.ifcURL == null ? null : URLMapper.findFileObject((URL)this.ifcURL);
            return fo != null ? Lookups.singleton((Object)fo) : Lookup.EMPTY;
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            Element memberElm;
            wc.toPhase(JavaSource.Phase.RESOLVED);
            ClassTree interfaceTree = this.findInterface((CompilationInfo)wc, this.ifcName);
            TreeMaker make = wc.getTreeMaker();
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)wc);
            List typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)wc, (TypeElement)this.sourceType.resolve((CompilationInfo)wc));
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParams.size());
            TypeElement sourceTypeElm = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            for (TypeParameterElement typeParameterElement : sourceTypeElm.getTypeParameters()) {
                TypeMirror typeMirror = typeParameterElement.asType();
                for (TypeMirror newParam : typeParams) {
                    Tree t;
                    if (!wc.getTypes().isSameType(typeMirror, newParam) || (t = wc.getTrees().getTree(typeParameterElement)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    TypeParameterTree typeParamTree = (TypeParameterTree)t;
                    if (!typeParamTree.getBounds().isEmpty()) {
                        typeParamTree = (TypeParameterTree)genUtils.importFQNs(t);
                    }
                    newTypeParams.add(typeParamTree);
                }
            }
            ArrayList<Tree> members = new ArrayList<Tree>();
            for (ElementHandle<VariableElement> elementHandle : this.refactoring.getFields()) {
                memberElm = (VariableElement)elementHandle.resolve((CompilationInfo)wc);
                VariableTree tree = (VariableTree)wc.getTrees().getTree(memberElm);
                VariableTree newVarTree = make.Variable(make.Modifiers(Collections.emptySet(), tree.getModifiers().getAnnotations()), (CharSequence)tree.getName(), tree.getType(), tree.getInitializer());
                newVarTree = (VariableTree)genUtils.importFQNs((Tree)newVarTree);
                RetoucheUtils.copyJavadoc(memberElm, newVarTree, wc);
                members.add(newVarTree);
            }
            for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
                memberElm = (ExecutableElement)elementHandle.resolve((CompilationInfo)wc);
                TreePath mpath = wc.getTrees().getPath(memberElm);
                MethodTree tree = wc.getTrees().getTree((ExecutableElement)memberElm);
                List<? extends AnnotationTree> annotations = CreateInterfaceElement.filterOutOverrideAnnotation(tree.getModifiers().getAnnotations(), (CompilationInfo)wc, mpath);
                MethodTree newMethodTree = make.Method(make.Modifiers(Collections.emptySet(), annotations), (CharSequence)tree.getName(), tree.getReturnType(), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), (BlockTree)null, null);
                newMethodTree = (MethodTree)genUtils.importFQNs((Tree)newMethodTree);
                RetoucheUtils.copyJavadoc(memberElm, newMethodTree, wc);
                members.add(newMethodTree);
            }
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>();
            arrayList.addAll(interfaceTree.getImplementsClause());
            for (TypeMirrorHandle<TypeMirror> handle : this.refactoring.getImplements()) {
                TypeMirror implMirror = handle.resolve((CompilationInfo)wc);
                arrayList.add(make.Type(implMirror));
            }
            ClassTree classTree2 = make.Interface(interfaceTree.getModifiers(), (CharSequence)interfaceTree.getSimpleName(), newTypeParams, arrayList, Collections.emptyList());
            classTree2 = genUtils.insertClassMembers(classTree2, members);
            wc.rewrite((Tree)interfaceTree, (Tree)classTree2);
        }

        private ClassTree findInterface(CompilationInfo javac, String name) {
            for (Tree tree : javac.getCompilationUnit().getTypeDecls()) {
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !javac.getTreeUtilities().isInterface((ClassTree)tree) || !name.contentEquals(((ClassTree)tree).getSimpleName())) continue;
                return (ClassTree)tree;
            }
            throw new IllegalStateException("wrong template, cannot find the interface in " + javac.getFileObject());
        }

        private static List<? extends AnnotationTree> filterOutOverrideAnnotation(List<? extends AnnotationTree> annotations, CompilationInfo javac, TreePath pathToMethod) {
            if (annotations.isEmpty()) {
                return annotations;
            }
            ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>(annotations.size());
            TypeElement overrideAnn = javac.getElements().getTypeElement("java.lang.Override");
            for (AnnotationTree annotationTree : annotations) {
                Element annotation = javac.getTrees().getElement(new TreePath(pathToMethod, annotationTree));
                if (annotation != null && annotation == overrideAnn) continue;
                newAnnotations.add(annotationTree);
            }
            return newAnnotations;
        }
    }
}

