/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.java.plugins.LocalVarScanner;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RetoucheUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";
    public static volatile boolean cancel = false;
    private static final Logger LOG = Logger.getLogger(RetoucheUtils.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(RetoucheUtils.class.getName(), 1, false, false);
    private static Dialog waitDialog = null;
    private static RequestProcessor.Task waitTask = null;

    public static String htmlize(String input) {
        String temp = input.replace("<", "&lt;");
        temp = temp.replace(">", "&gt;");
        return temp;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, CompilationInfo info) {
        return RetoucheUtils.getOverridenMethods(e, info.getElementUtilities().enclosingTypeElement((Element)e), info);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, TypeElement parent, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeMirror sup = parent.getSuperclass();
        if (sup.getKind() == TypeKind.DECLARED) {
            TypeElement next = (TypeElement)((DeclaredType)sup).asElement();
            ExecutableElement executableElement = RetoucheUtils.getMethod(e, next, info);
            result.addAll(RetoucheUtils.getOverridenMethods(e, next, info));
            if (executableElement != null) {
                result.add(executableElement);
            }
        }
        for (TypeMirror typeMirror : parent.getInterfaces()) {
            TypeElement next = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement overriden2 = RetoucheUtils.getMethod(e, next, info);
            result.addAll(RetoucheUtils.getOverridenMethods(e, next, info));
            if (overriden2 == null) continue;
            result.add(overriden2);
        }
        return result;
    }

    private static ExecutableElement getMethod(ExecutableElement method, TypeElement type, CompilationInfo info) {
        for (ExecutableElement met : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!info.getElements().overrides(method, met, type)) continue;
            return met;
        }
        return null;
    }

    public static Set<ElementHandle<TypeElement>> getImplementorsAsHandles(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el) {
        cancel = false;
        LinkedList<ElementHandle<TypeElement>> elements = new LinkedList<ElementHandle<TypeElement>>(RetoucheUtils.implementorsQuery(idx, (ElementHandle<TypeElement>)ElementHandle.create((Element)el)));
        HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
        while (!elements.isEmpty()) {
            if (cancel) {
                cancel = false;
                return Collections.emptySet();
            }
            ElementHandle<TypeElement> next = elements.removeFirst();
            if (!result.add(next)) continue;
            Set<ElementHandle<TypeElement>> foundElements = RetoucheUtils.implementorsQuery(idx, next);
            elements.addAll(foundElements);
        }
        return result;
    }

    private static Set<ElementHandle<TypeElement>> implementorsQuery(ClassIndex idx, ElementHandle<TypeElement> next) {
        return idx.getElements(next, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement e, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeElement parentType = (TypeElement)e.getEnclosingElement();
        Set<ElementHandle<TypeElement>> subTypes = RetoucheUtils.getImplementorsAsHandles(info.getClasspathInfo().getClassIndex(), info.getClasspathInfo(), parentType);
        for (ElementHandle<TypeElement> subTypeHandle : subTypes) {
            TypeElement type = (TypeElement)subTypeHandle.resolve(info);
            if (type == null) {
                FileObject file = SourceUtils.getFile(subTypeHandle, (ClasspathInfo)info.getClasspathInfo());
                if (file == null) continue;
                throw new NullPointerException("#120577: Cannot resolve " + subTypeHandle + "; file: " + file);
            }
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!info.getElements().overrides(method, e, type)) continue;
                result.add(method);
            }
        }
        return result;
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)f, (String[])new String[]{JAVA_MIME_TYPE}));
    }

    public static String getHtml(String text) {
        StringBuffer buf = new StringBuffer();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)JavaTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)JAVA_MIME_TYPE));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = ((JavaTokenId)token.id()).primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            AttributeSet set = settings.getTokenFontColors(category);
            buf.append(RetoucheUtils.color(RetoucheUtils.htmlize(((Object)token.text()).toString()), set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    public static boolean isElementInOpenProject(FileObject f) {
        if (f == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        return RetoucheUtils.isOpenProject(p);
    }

    public static boolean isFromLibrary(Element element, ClasspathInfo info) {
        FileObject file = SourceUtils.getFile((Element)element, (ClasspathInfo)info);
        if (file == null) {
            return true;
        }
        return FileUtil.getArchiveFile((FileObject)file) != null;
    }

    public static boolean isValidPackageName(String name) {
        if (name.endsWith(".")) {
            return false;
        }
        if (name.startsWith(".")) {
            return false;
        }
        if (name.contains("..")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return false;
        }
        return RetoucheUtils.isOpenProject(p);
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project[] opened;
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        for (Project pr : opened = OpenProjects.getDefault().getOpenProjects()) {
            for (String type : new String[]{"java", "resources"}) {
                for (SourceGroup sg : ProjectUtils.getSources((Project)pr).getSourceGroups(type)) {
                    if (fo != sg.getRootFolder() && (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo) || !sg.contains(fo))) continue;
                    return ClassPath.getClassPath((FileObject)fo, (String)"classpath/source") != null;
                }
            }
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fo) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        return cp != null ? fo.equals(cp.findOwnerRoot(fo)) : false;
    }

    public static boolean isRefactorable(FileObject file) {
        return file != null && RetoucheUtils.isJavaFile(file) && RetoucheUtils.isFileInOpenProject(file) && RetoucheUtils.isOnSourceClasspath(file);
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (cp == null) {
            throw new IllegalStateException(String.format("No classpath for %s.", folder.getPath()));
        }
        return cp.getResourceName(folder, '.', false);
    }

    public static String getPackageName(CompilationUnitTree unit) {
        assert (unit != null);
        ExpressionTree name = unit.getPackageName();
        if (name == null) {
            return "";
        }
        return name.toString();
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return RetoucheUtils.getPackageName(fo);
                }
                String prefix = RetoucheUtils.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1) + suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    public static FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = new File(url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    public static FileObject getClassPathRoot(URL url) throws IOException {
        File f;
        FileObject result = URLMapper.findFileObject((URL)url);
        try {
            f = result != null ? null : FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        while (result == null) {
            result = FileUtil.toFileObject((File)f);
            f = f.getParentFile();
        }
        return ClassPath.getClassPath((FileObject)result, (String)"classpath/source").findOwnerRoot(result);
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement type, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        LinkedList<TypeElement> l = new LinkedList<TypeElement>();
        l.add(type);
        while (!l.isEmpty()) {
            TypeElement t = (TypeElement)l.removeFirst();
            TypeElement superClass = RetoucheUtils.typeToElement(t.getSuperclass(), info);
            if (superClass != null) {
                result.add(superClass);
                l.addLast(superClass);
            }
            Collection<TypeElement> interfaces = RetoucheUtils.typesToElements(t.getInterfaces(), info);
            result.addAll(interfaces);
            l.addAll(interfaces);
        }
        return result;
    }

    public static Collection<FileObject> getSuperTypesFiles(TreePathHandle handle) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            SuperTypesTask ff = new SuperTypesTask(handle);
            source.runUserActionTask((Task)ff, true);
            return ff.getFileObjects();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static Collection<TypeElement> getSuperTypes(TypeElement type, CompilationInfo info, boolean sourceOnly) {
        if (!sourceOnly) {
            return RetoucheUtils.getSuperTypes(type, info);
        }
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeElement el : RetoucheUtils.getSuperTypes(type, info)) {
            FileObject file = SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo());
            if (file == null || !RetoucheUtils.isFileInOpenProject(file) || RetoucheUtils.isFromLibrary(el, info.getClasspathInfo())) continue;
            result.add(el);
        }
        return result;
    }

    public static TypeElement typeToElement(TypeMirror type, CompilationInfo info) {
        return (TypeElement)info.getTypes().asElement(type);
    }

    private static boolean isOpenProject(Project p) {
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    private static Collection<TypeElement> typesToElements(Collection<? extends TypeMirror> types, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : types) {
            result.add(RetoucheUtils.typeToElement(typeMirror, info));
        }
        return result;
    }

    public static Collection<FileObject> elementsToFile(Collection<? extends Element> elements, ClasspathInfo cpInfo) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (Element element : elements) {
            result.add(SourceUtils.getFile((Element)element, (ClasspathInfo)cpInfo));
        }
        return result;
    }

    public static boolean elementExistsIn(TypeElement target, Element member, CompilationInfo info) {
        for (Element element : target.getEnclosedElements()) {
            if (info.getElements().hides(member, element) || info.getElements().hides(element, member)) {
                return true;
            }
            if (!(member instanceof ExecutableElement) || !(element instanceof ExecutableElement) || !info.getElements().overrides((ExecutableElement)member, (ExecutableElement)element, target) && !info.getElements().overrides((ExecutableElement)element, (ExecutableElement)member, target)) continue;
            return true;
        }
        return false;
    }

    public static ElementHandle getElementHandle(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + tph.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((Task)ff, true);
            return ff.getElementHandle();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static ElementKind getElementKind(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + tph.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((Task)ff, true);
            return ff.getElementKind();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static String getSimpleName(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + tph.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((Task)ff, true);
            return ff.getSimpleName();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static FileObject getFileObject(TreePathHandle handle) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + handle.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(handle);
            source.runUserActionTask((Task)ff, true);
            return ff.getFileObject();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static String getQualifiedName(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + tph.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((Task)ff, true);
            return ff.getQualifiedName();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static boolean typeExist(TreePathHandle tph, String fqn) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            assert (source != null) : "JavaSource.forFileObject(" + tph.getFileObject().getPath() + ") \n returned null";
            CompilerTask ff = new CompilerTask(tph, fqn);
            source.runUserActionTask((Task)ff, true);
            return ff.typeExist();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        return RetoucheUtils.getClasspathInfoFor(true, files);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean dependencies, FileObject ... files) {
        return RetoucheUtils.getClasspathInfoFor(dependencies, false, files);
    }

    public static ClasspathInfo getClasspathInfoFor(boolean dependencies, boolean backSource, FileObject ... files) {
        ClassPath compile;
        assert (files.length > 0);
        HashSet<URL> dependentRoots = new HashSet<URL>();
        for (FileObject fo : files) {
            ClassPath cp = null;
            FileObject ownerRoot = null;
            if (fo != null && (cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) != null) {
                ownerRoot = cp.findOwnerRoot(fo);
            }
            if (cp != null && ownerRoot != null) {
                URL sourceRoot = URLMapper.findURL(ownerRoot, (int)0);
                if (dependencies) {
                    dependentRoots.addAll(SourceUtils.getDependentRoots((URL)sourceRoot));
                } else {
                    dependentRoots.add(sourceRoot);
                }
                for (FileObject f : cp.getRoots()) {
                    dependentRoots.add(URLMapper.findURL((FileObject)f, (int)0));
                }
                continue;
            }
            for (ClassPath scp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject root : scp.getRoots()) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root, (int)0));
                }
            }
        }
        if (backSource) {
            for (FileObject file : files) {
                if (file == null) continue;
                ClassPath source = ClassPath.getClassPath((FileObject)file, (String)"classpath/compile");
                for (ClassPath.Entry root : source.entries()) {
                    SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)root.getURL());
                    for (FileObject root2 : r.getRoots()) {
                        dependentRoots.add(URLMapper.findURL((FileObject)root2, (int)0));
                    }
                }
            }
        }
        ClassPath rcp = ClassPathSupport.createClassPath((URL[])dependentRoots.toArray(new URL[dependentRoots.size()]));
        ClassPath nullPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath boot = files[0] != null ? ClassPath.getClassPath((FileObject)files[0], (String)"classpath/boot") : nullPath;
        ClassPath classPath = compile = files[0] != null ? ClassPath.getClassPath((FileObject)files[0], (String)"classpath/compile") : nullPath;
        if (compile == null) {
            compile = ClassPath.getClassPath((FileObject)files[0], (String)"classpath/execute");
        }
        if (compile == null) {
            LOG.warning("No classpath for: " + FileUtil.getFileDisplayName((FileObject)files[0]) + " " + FileOwnerQuery.getOwner((FileObject)files[0]));
            compile = nullPath;
        }
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)boot, (ClassPath)compile, (ClassPath)rcp);
        return cpInfo;
    }

    public static ClasspathInfo getClasspathInfoFor(TreePathHandle ... handles) {
        FileObject[] result = new FileObject[handles.length];
        int i = 0;
        for (TreePathHandle handle : handles) {
            FileObject fo = RetoucheUtils.getFileObject(handle);
            if (i == 0 && fo == null) {
                result = new FileObject[handles.length + 1];
                result[i++] = handle.getFileObject();
            }
            result[i++] = fo;
        }
        return RetoucheUtils.getClasspathInfoFor(result);
    }

    public static void findUsedGenericTypes(Types utils, List<TypeMirror> typeArgs, Set<TypeMirror> result, TypeMirror tm) {
        if (typeArgs.isEmpty()) {
            return;
        }
        if (tm.getKind() == TypeKind.TYPEVAR) {
            int index;
            TypeMirror typeMirror;
            TypeVariable type = (TypeVariable)tm;
            TypeMirror low = type.getLowerBound();
            if (low != null && low.getKind() != TypeKind.NULL) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, low);
            }
            if ((typeMirror = type.getUpperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
            if ((index = RetoucheUtils.findTypeIndex(utils, typeArgs, type)) >= 0) {
                result.add(typeArgs.get(index));
            }
        } else if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)tm;
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        } else if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror;
            WildcardType type = (WildcardType)tm;
            TypeMirror ex = type.getExtendsBound();
            if (ex != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, ex);
            }
            if ((typeMirror = type.getSuperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        }
    }

    private static int findTypeIndex(Types utils, List<TypeMirror> typeArgs, TypeMirror type) {
        int i = -1;
        for (TypeMirror typeArg : typeArgs) {
            ++i;
            if (!utils.isSameType(type, typeArg)) continue;
            return i;
        }
        return -1;
    }

    public static List<TypeMirror> filterTypes(List<TypeMirror> source, Set<TypeMirror> used) {
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(source.size());
        for (TypeMirror tm : source) {
            if (!used.contains(tm)) continue;
            result.add(tm);
        }
        return result;
    }

    public static List<TypeMirror> resolveTypeParamsAsTypes(List<? extends Element> typeParams) {
        if (typeParams.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> typeArgs = new ArrayList<TypeMirror>(typeParams.size());
        for (Element element : typeParams) {
            typeArgs.add(element.asType());
        }
        return typeArgs;
    }

    @NullUnknown
    public static TreePath findEnclosingClass(CompilationInfo javac, TreePath path, boolean isClass, boolean isInterface, boolean isEnum, boolean isAnnotation, boolean isAnonymous) {
        Tree selectedTree = path.getLeaf();
        TreeUtilities utils = javac.getTreeUtilities();
        while (true) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)selectedTree.getKind())) {
                ClassTree classTree = (ClassTree)selectedTree;
                if (isEnum && utils.isEnum(classTree) || isInterface && utils.isInterface(classTree) || isAnnotation && utils.isAnnotation(classTree) || isClass && !utils.isInterface(classTree) && !utils.isEnum(classTree) && !utils.isAnnotation(classTree)) {
                    Tree.Kind parentKind = path.getParentPath().getLeaf().getKind();
                    if (isAnonymous || Tree.Kind.NEW_CLASS != parentKind) break;
                }
            }
            if ((path = path.getParentPath()) == null) {
                List<? extends Tree> typeDecls = javac.getCompilationUnit().getTypeDecls();
                if (typeDecls.isEmpty()) {
                    return null;
                }
                selectedTree = typeDecls.get(0);
                if (selectedTree.getKind().asInterface() == ClassTree.class) {
                    return javac.getTrees().getPath(javac.getCompilationUnit(), selectedTree);
                }
                return null;
            }
            selectedTree = path.getLeaf();
        }
        return path;
    }

    public static void copyJavadoc(Element elm, Tree tree, WorkingCopy wc) {
        TreeMaker make = wc.getTreeMaker();
        String jdtxt = wc.getElements().getDocComment(elm);
        if (jdtxt != null) {
            make.addComment(tree, Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-1, (int)-1, (int)-1, (String)jdtxt), true);
        }
    }

    public static boolean invokeAfterScanFinished(Runnable runnable, String actionName) {
        assert (SwingUtilities.isEventDispatchThread());
        if (SourceUtils.isScanInProgress()) {
            final ActionPerformer ap = new ActionPerformer(runnable);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ap.cancel();
                    waitTask.cancel();
                }
            };
            JLabel label = new JLabel(RetoucheUtils.getString("MSG_WaitScan"), UIManager.getIcon("OptionPane.informationIcon"), 2);
            label.setBorder(new EmptyBorder(12, 12, 11, 11));
            DialogDescriptor dd = new DialogDescriptor((Object)label, actionName, true, new Object[]{RetoucheUtils.getString("LBL_CancelAction", new Object[]{actionName})}, null, 0, null, listener);
            waitDialog = DialogDisplayer.getDefault().createDialog(dd);
            waitDialog.pack();
            waitTask = RP.post((Runnable)ap, 100);
            waitDialog.setVisible(true);
            waitTask = null;
            waitDialog = null;
            return ap.hasBeenCancelled();
        }
        runnable.run();
        return false;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RetoucheUtils.class, (String)key);
    }

    private static String getString(String key, Object values) {
        return new MessageFormat(RetoucheUtils.getString(key)).format(values);
    }

    public static CompilationUnitTree addImports(CompilationUnitTree cut, List<String> toImport, TreeMaker make) throws IOException {
        toImport = new ArrayList<String>(toImport);
        Collections.sort(toImport);
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        int currentToImport = toImport.size() - 1;
        int currentExisting = imports.size() - 1;
        while (currentToImport >= 0 && currentExisting >= 0) {
            String currentToImportText = toImport.get(currentToImport);
            while (currentExisting >= 0 && (((ImportTree)imports.get(currentExisting)).isStatic() || ((ImportTree)imports.get(currentExisting)).getQualifiedIdentifier().toString().compareTo(currentToImportText) > 0)) {
                --currentExisting;
            }
            if (currentExisting < 0) continue;
            imports.add(currentExisting + 1, make.Import((Tree)make.Identifier((CharSequence)currentToImportText), false));
            --currentToImport;
        }
        while (currentToImport >= 0) {
            String importText = toImport.get(currentToImport);
            imports.add(0, make.Import((Tree)make.Identifier((CharSequence)importText), false));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public static ModifiersTree makeAbstract(TreeMaker make, ModifiersTree oldMods) {
        if (oldMods.getFlags().contains((Object)Modifier.ABSTRACT)) {
            return oldMods;
        }
        HashSet<Modifier> flags = new HashSet<Modifier>(oldMods.getFlags());
        flags.add(Modifier.ABSTRACT);
        flags.remove((Object)Modifier.FINAL);
        return make.Modifiers(flags, oldMods.getAnnotations());
    }

    public static String variableClashes(String newName, TreePath tp, CompilationInfo info) {
        LocalVarScanner lookup = new LocalVarScanner(info, newName);
        TreePath scopeBlok = tp;
        EnumSet<Tree.Kind> set = EnumSet.of(Tree.Kind.BLOCK, Tree.Kind.FOR_LOOP, Tree.Kind.METHOD);
        while (!set.contains((Object)scopeBlok.getLeaf().getKind())) {
            scopeBlok = scopeBlok.getParentPath();
        }
        Element var = info.getTrees().getElement(tp);
        lookup.scan(scopeBlok, var);
        if (lookup.hasRefernces()) {
            return new MessageFormat(RetoucheUtils.getString("MSG_LocVariableClash")).format(new Object[]{newName});
        }
        for (TreePath temp = tp; temp != null && temp.getLeaf().getKind() != Tree.Kind.METHOD; temp = temp.getParentPath()) {
            Scope scope = info.getTrees().getScope(temp);
            for (Element element : scope.getLocalElements()) {
                if (!element.getSimpleName().toString().equals(newName)) continue;
                return new MessageFormat(RetoucheUtils.getString("MSG_LocVariableClash")).format(new Object[]{newName});
            }
        }
        return null;
    }

    public static boolean isSetter(ExecutableElement el, Element propertyElement) {
        String setterName = RetoucheUtils.getSetterName(propertyElement.getSimpleName().toString());
        return el.getSimpleName().contentEquals(setterName) && el.getReturnType().getKind() == TypeKind.VOID && el.getParameters().size() == 1 && ((Object)el.getParameters().iterator().next().asType()).equals(propertyElement.asType());
    }

    public static boolean isGetter(ExecutableElement el, Element propertyElement) {
        String getterName = RetoucheUtils.getGetterName(propertyElement.getSimpleName().toString());
        return el.getSimpleName().contentEquals(getterName) && ((Object)el.getReturnType()).equals(propertyElement.asType()) && el.getParameters().isEmpty();
    }

    public static String getGetterName(String propertyName) {
        return "get" + RetoucheUtils.capitalizeFirstLetter(propertyName);
    }

    public static String getSetterName(String propertyName) {
        return "set" + RetoucheUtils.capitalizeFirstLetter(propertyName);
    }

    private static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static boolean isWeakerAccess(Set<Modifier> modifiers, Set<Modifier> modifiers0) {
        return RetoucheUtils.accessLevel(modifiers) < RetoucheUtils.accessLevel(modifiers0);
    }

    private static int accessLevel(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        return 1;
    }

    public static String getAccess(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return "private";
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return "protected";
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return "public";
        }
        return "<default>";
    }

    private static class ActionPerformer
    implements Runnable {
        private Runnable action;
        private boolean cancel = false;

        ActionPerformer(Runnable a) {
            this.action = a;
        }

        public boolean hasBeenCancelled() {
            return this.cancel;
        }

        @Override
        public void run() {
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException ie) {
                Exceptions.printStackTrace((Throwable)ie);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ActionPerformer.this.cancel) {
                        if (waitDialog != null) {
                            waitDialog.setVisible(false);
                            waitDialog.dispose();
                        }
                        ActionPerformer.this.action.run();
                    }
                }
            });
        }

        public void cancel() {
            assert (SwingUtilities.isEventDispatchThread());
            if (waitDialog != null) {
                this.cancel = true;
                waitDialog.setVisible(false);
                waitDialog.dispose();
            }
        }
    }

    private static class SuperTypesTask
    implements CancellableTask<CompilationController> {
        private Collection<FileObject> files;
        TreePathHandle handle;

        SuperTypesTask(TreePathHandle handle) {
            this.handle = handle;
        }

        public void cancel() {
        }

        public void run(CompilationController cc) {
            try {
                cc.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
            Element el = this.handle.resolveElement((CompilationInfo)cc);
            this.files = RetoucheUtils.elementsToFile(RetoucheUtils.getSuperTypes((TypeElement)el, (CompilationInfo)cc, true), cc.getClasspathInfo());
        }

        public Collection<FileObject> getFileObjects() {
            return this.files;
        }
    }

    private static class CompilerTask
    implements CancellableTask<CompilationController> {
        private FileObject f;
        private ElementHandle eh;
        private String name;
        private String fqn;
        private String typeToCheck;
        private boolean typeExist;
        private ElementKind kind;
        private IllegalArgumentException iae;
        TreePathHandle handle;

        CompilerTask(TreePathHandle handle) {
            this.handle = handle;
        }

        CompilerTask(TreePathHandle handle, String fqn) {
            this(handle);
            this.typeToCheck = fqn;
        }

        public void cancel() {
        }

        public void run(CompilationController cc) {
            try {
                cc.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
            Element el = this.handle.resolveElement((CompilationInfo)cc);
            if (el == null) {
                return;
            }
            this.f = SourceUtils.getFile((Element)el, (ClasspathInfo)cc.getClasspathInfo());
            try {
                this.eh = ElementHandle.create((Element)el);
            }
            catch (IllegalArgumentException iae) {
                this.iae = iae;
            }
            this.name = el.getSimpleName().toString();
            this.kind = el.getKind();
            if (this.kind.isClass() || this.kind.isInterface()) {
                this.fqn = ((TypeElement)el).getQualifiedName().toString();
            }
            if (this.typeToCheck != null) {
                this.typeExist = cc.getElements().getTypeElement(this.typeToCheck) != null;
            }
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public ElementHandle getElementHandle() {
            return this.eh;
        }

        public String getSimpleName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.fqn;
        }

        public boolean typeExist() {
            return this.typeExist;
        }

        public ElementKind getElementKind() {
            return this.kind;
        }
    }
}

