/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.html.HtmlDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private static final RequestProcessor SINGLE_THREAD_RP = new RequestProcessor(HtmlEditorSupport.class.getName(), 1);
    private static final String DOCUMENT_SAVE_ENCODING = "Document_Save_Encoding";
    private static final String UTF_8_ENCODING = "UTF-8";
    public static boolean showConfirmationDialog = true;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            try {
                HtmlEditorSupport.this.saveDocument();
            }
            catch (UserCancelException userCancelException) {
                // empty catch block
            }
        }
    };

    HtmlEditorSupport(HtmlDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType(obj.getPrimaryFile().getMIMEType());
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/html", (Serializable)this.getDataObject());
    }

    public void saveDocument() throws IOException {
        this.updateEncoding();
        super.saveDocument();
        this.getDataObject().setModified(false);
    }

    void updateEncoding() throws UserCancelException {
        String documentContent = this.getDocumentText();
        String encoding = HtmlDataObject.findEncoding(documentContent);
        String feqEncoding = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        String finalEncoding = null;
        if (encoding != null) {
            if (!this.isSupportedEncoding(encoding) || !this.canEncode(documentContent, encoding)) {
                finalEncoding = this.canEncode(documentContent, feqEncoding) ? feqEncoding : UTF_8_ENCODING;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_unsupportedEncodingSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, finalEncoding, finalEncoding.equals(UTF_8_ENCODING) ? "" : " the original"}), 0, 2);
                nd.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                    throw new UserCancelException();
                }
            } else {
                finalEncoding = encoding;
            }
        } else if (!this.canEncode(documentContent, feqEncoding)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_badCharConversionSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), feqEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                throw new UserCancelException();
            }
            finalEncoding = UTF_8_ENCODING;
        } else {
            finalEncoding = feqEncoding;
        }
        this.getDocument().putProperty(DOCUMENT_SAVE_ENCODING, finalEncoding);
    }

    public void open() {
        String encoding = ((HtmlDataObject)this.getDataObject()).getFileEncoding();
        String feqEncoding = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        if (encoding != null && !this.isSupportedEncoding(encoding)) {
            if (!showConfirmationDialog) {
                return;
            }
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_unsupportedEncodingLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, feqEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        Charset c = Charset.forName((String)doc.getProperty(DOCUMENT_SAVE_ENCODING));
        OutputStreamWriter w = new OutputStreamWriter(stream, c);
        try {
            kit.write(w, (Document)doc, 0, doc.getLength());
        }
        finally {
            ((Writer)w).close();
        }
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    private void removeSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    private String getDocumentText() {
        String text = "";
        try {
            StyledDocument doc = this.getDocument();
            if (doc != null) {
                text = doc.getText(doc.getStartPosition().getOffset(), doc.getLength());
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        }
        return text;
    }

    private boolean canDecodeFile(FileObject fo, String encoding) {
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        try {
            BufferedInputStream bis = new BufferedInputStream(fo.getInputStream());
            byte[] buffer = new byte[(int)fo.getSize()];
            bis.read(buffer);
            bis.close();
            decoder.decode(ByteBuffer.wrap(buffer));
            return true;
        }
        catch (CharacterCodingException ex) {
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.WARNING, "Error during charset verification", ioe);
        }
        return false;
    }

    private boolean canEncode(String docText, String encoding) {
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        return encoder.canEncode(docText);
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(HtmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(HtmlEditorSupport.class);
        }
    }
}

