/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MethodOrder;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.internal.NbModuleLogHandler;

public class NbModuleSuite {
    private static final Logger LOG;

    private NbModuleSuite() {
    }

    public static Test create(Class<? extends TestCase> clazz, String clustersRegExp, String moduleRegExp) {
        return Configuration.create(clazz).clusters(clustersRegExp).enableModules(moduleRegExp).suite();
    }

    public static Test create(Class<? extends TestCase> clazz, String clustersRegExp, String moduleRegExp, String ... tests) {
        Configuration conf = Configuration.create(clazz).clusters(clustersRegExp).enableModules(moduleRegExp);
        if (tests.length > 0) {
            conf = conf.addTest(tests);
        }
        return conf.suite();
    }

    public static Test allModules(Class<? extends TestCase> clazz, String ... tests) {
        return NbModuleSuite.create(clazz, ".*", ".*", tests);
    }

    public static Configuration createConfiguration(Class<? extends TestCase> clazz) {
        return Configuration.create(clazz);
    }

    public static Configuration emptyConfiguration() {
        return Configuration.create(null);
    }

    public static Test create(Configuration config) {
        return config.suite();
    }

    static {
        System.setProperty("org.netbeans.MainImpl.154417", "true");
        LOG = Logger.getLogger(NbModuleSuite.class.getName());
    }

    private static class NbTestSuiteLogCheck
    extends NbTestSuite {
        public NbTestSuiteLogCheck() {
        }

        public NbTestSuiteLogCheck(Class<? extends TestCase> clazz) {
            super(clazz);
        }

        public void runTest(Test test, TestResult result) {
            int e = result.errorCount();
            int f = result.failureCount();
            LOG.log(Level.FINE, "Running test {0}", test);
            super.runTest(test, result);
            LOG.log(Level.FINE, "Finished: {0}", test);
            if (e == result.errorCount() && f == result.failureCount()) {
                NbModuleLogHandler.checkFailures((TestCase)test, result);
            }
        }
    }

    static final class S
    extends NbTestSuite {
        final Configuration config;
        private static int invocations;
        private static File lastUserDir;
        private int testCount = 0;
        private static final Set<String> pseudoModules;
        private static Pattern MANIFEST;
        private static Pattern ENABLED;
        private static Pattern AUTO;
        private static Pattern EAGER;

        public S(Configuration config) {
            this.config = config.getReady();
        }

        public int countTestCases() {
            return this.testCount;
        }

        public void run(final TestResult result) {
            result.runProtected((Test)this, new Protectable(){

                public void protect() throws Throwable {
                    S.this.runInRuntimeContainer(result);
                }
            });
        }

        private static String[] tokenizePath(String path) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(path, ":;", true);
            char dosHack = '\u0000';
            int lastDelim = 0;
            int delimCount = 0;
            while (tok.hasMoreTokens()) {
                char c;
                String s = tok.nextToken();
                if (s.length() == 0) continue;
                if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                    lastDelim = c;
                    ++delimCount;
                    continue;
                }
                if (dosHack != '\u0000') {
                    if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                        s = "" + dosHack + ':' + s;
                    } else {
                        l.add(Character.toString(dosHack));
                    }
                    dosHack = '\u0000';
                }
                delimCount = 0;
                if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    dosHack = c;
                    continue;
                }
                l.add(s);
            }
            if (dosHack != '\u0000') {
                l.add(Character.toString(dosHack));
            }
            return l.toArray(new String[l.size()]);
        }

        static void findClusters(Collection<File> clusters, List<String> regExps) throws IOException {
            TreeSet<Object> path;
            File plat = S.findPlatform().getCanonicalFile();
            String selectiveClusters = System.getProperty("cluster.path.final");
            if (selectiveClusters != null) {
                path = new TreeSet();
                for (String string : S.tokenizePath(selectiveClusters)) {
                    File f = new File(string);
                    path.add(f.getCanonicalFile());
                }
            } else {
                String allClusters = System.getProperty("all.clusters");
                File parent = allClusters != null ? new File(allClusters) : plat.getParentFile();
                path = new TreeSet<File>(Arrays.asList(parent.listFiles()));
            }
            for (String c : regExps) {
                for (File file : path) {
                    File m;
                    if (file.equals(plat) || !file.getName().matches(c) || !(m = new File(new File(file, "config"), "Modules")).exists()) continue;
                    clusters.add(file);
                }
            }
        }

        private void runInRuntimeContainer(TestResult result) throws Exception {
            System.getProperties().remove("netbeans.dirs");
            File platform = S.findPlatform();
            ArrayList<URL> bootCP = new ArrayList<URL>();
            ArrayList<File> dirs = new ArrayList<File>();
            dirs.add(new File(platform, "lib"));
            File jdkHome = new File(System.getProperty("java.home"));
            if (!"Mac OS X".equals(System.getProperty("os.name"))) {
                jdkHome = jdkHome.getParentFile();
            }
            dirs.add(new File(jdkHome, "lib"));
            if (System.getProperty("code.coverage.classpath") != null) {
                dirs.add(new File(System.getProperty("code.coverage.classpath")));
            }
            for (File dir : dirs) {
                File[] jars = dir.listFiles();
                if (jars == null) continue;
                for (File jar : jars) {
                    if (!jar.getName().endsWith(".jar")) continue;
                    bootCP.add(jar.toURI().toURL());
                }
            }
            JUnitLoader junit = new JUnitLoader(this.config.parentClassLoader, NbModuleSuite.class.getClassLoader());
            URLClassLoader loader = new URLClassLoader(bootCP.toArray(new URL[0]), (ClassLoader)junit);
            Class<?> main = loader.loadClass("org.netbeans.Main");
            Assert.assertEquals((String)"Loaded by our classloader", (Object)loader, (Object)main.getClassLoader());
            Method m = main.getDeclaredMethod("main", String[].class);
            System.setProperty("java.util.logging.config", "-");
            System.setProperty("netbeans.logger.console", "true");
            if (System.getProperty("netbeans.logger.noSystem") == null) {
                System.setProperty("netbeans.logger.noSystem", "true");
            }
            System.setProperty("netbeans.home", platform.getPath());
            System.setProperty("netbeans.full.hack", "true");
            File ud = new File(new File(Manager.getWorkDirPath()), "userdir" + invocations++);
            if (this.config.reuseUserDir) {
                ud = lastUserDir != null ? lastUserDir : ud;
            } else {
                NbTestCase.deleteSubFiles(ud);
            }
            lastUserDir = ud;
            ud.mkdirs();
            System.setProperty("netbeans.user", ud.getPath());
            TreeSet<String> modules = new TreeSet<String>();
            if (this.config.enableClasspathModules) {
                modules.addAll(S.findEnabledModules(NbTestSuite.class.getClassLoader()));
            }
            modules.add("org.openide.filesystems");
            modules.add("org.openide.modules");
            modules.add("org.openide.util");
            modules.remove("org.netbeans.insane");
            modules.add("org.netbeans.core.startup");
            modules.add("org.netbeans.bootstrap");
            S.turnModules(ud, !this.config.honorAutoEager, modules, this.config.moduleRegExp, platform);
            if (this.config.enableClasspathModules) {
                S.turnClassPathModules(ud, NbTestSuite.class.getClassLoader());
            }
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (File f : this.findClusters()) {
                S.turnModules(ud, !this.config.honorAutoEager, modules, this.config.moduleRegExp, f);
                sb.append(sep);
                sb.append(f.getPath());
                sep = File.pathSeparator;
            }
            System.setProperty("netbeans.dirs", sb.toString());
            System.setProperty("netbeans.security.nocheck", "true");
            ArrayList allClasses = new ArrayList(this.config.tests.size());
            for (Item item : this.config.tests) {
                allClasses.add(item.clazz);
            }
            S.preparePatches(System.getProperty("java.class.path"), System.getProperties(), allClasses.toArray(new Class[0]));
            ArrayList<String> args = new ArrayList<String>();
            args.add("--nosplash");
            if (!this.config.gui) {
                args.add("--nogui");
            }
            if (this.config.startupArgs != null) {
                args.addAll(this.config.startupArgs);
            }
            Test handler = NbModuleLogHandler.registerBuffer(this.config.failOnMessage, this.config.failOnException);
            m.invoke(null, new Object[]{args.toArray(new String[0])});
            ClassLoader global = Thread.currentThread().getContextClassLoader();
            Assert.assertNotNull((String)"Global classloader is initialized", (Object)global);
            ClassLoader testLoader = global;
            try {
                testLoader.loadClass("junit.framework.Test");
                testLoader.loadClass("org.netbeans.junit.NbTestSuite");
                NbTestSuite toRun = new NbTestSuite();
                for (Item item : this.config.tests) {
                    Class<TestCase> sndClazz;
                    if (item.isTestCase) {
                        sndClazz = testLoader.loadClass(item.clazz.getName()).asSubclass(TestCase.class);
                        if (item.fileNames == null) {
                            MethodOrder.orderMethods(sndClazz, null);
                            toRun.addTest(new NbTestSuiteLogCheck(sndClazz));
                            continue;
                        }
                        NbTestSuiteLogCheck t = new NbTestSuiteLogCheck();
                        t.addTests(sndClazz, item.fileNames);
                        toRun.addTest(t);
                        continue;
                    }
                    sndClazz = testLoader.loadClass(item.clazz.getName()).asSubclass(Test.class);
                    toRun.addTest((Test)sndClazz.newInstance());
                }
                if (handler != null) {
                    toRun.addTest(handler);
                }
                this.testCount = toRun.countTestCases();
                toRun.run(result);
            }
            catch (ClassNotFoundException ex) {
                result.addError((Test)this, (Throwable)ex);
            }
            catch (NoClassDefFoundError ex) {
                result.addError((Test)this, (Throwable)ex);
            }
            if (handler != null) {
                NbModuleLogHandler.finish();
            }
            Class<?> lifeClazz = global.loadClass("org.openide.LifecycleManager");
            Method getDefault = lifeClazz.getMethod("getDefault", new Class[0]);
            Method exit = lifeClazz.getMethod("exit", new Class[0]);
            Object life = getDefault.invoke(null, new Object[0]);
            if (!life.getClass().getName().startsWith("org.openide.LifecycleManager")) {
                System.setProperty("netbeans.close.no.exit", "true");
                exit.invoke(life, new Object[0]);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        }

        static File findPlatform() {
            File d;
            String allClusters;
            String clusterPath = System.getProperty("cluster.path.final");
            if (clusterPath != null) {
                for (String piece : S.tokenizePath(clusterPath)) {
                    File d2 = new File(piece);
                    if (!d2.getName().matches("platform\\d*")) continue;
                    return d2;
                }
            }
            if ((allClusters = System.getProperty("all.clusters")) != null && (d = new File(allClusters, "platform")).isDirectory()) {
                return d;
            }
            try {
                Class<?> lookup = Class.forName("org.openide.util.Lookup");
                File util = new File(lookup.getProtectionDomain().getCodeSource().getLocation().toURI());
                Assert.assertTrue((String)("Util exists: " + util), (boolean)util.exists());
                return util.getParentFile().getParentFile();
            }
            catch (Exception ex) {
                try {
                    File nbjunit = new File(NbModuleSuite.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    File harness = nbjunit.getParentFile().getParentFile();
                    Assert.assertEquals((String)(nbjunit + " is in a folder named 'harness'"), (String)"harness", (String)harness.getName());
                    TreeSet<File> sorted = new TreeSet<File>();
                    for (File p : harness.getParentFile().listFiles()) {
                        if (!p.getName().startsWith("platform")) continue;
                        sorted.add(p);
                    }
                    Assert.assertFalse((String)("Platform shall be found in " + harness.getParent()), (boolean)sorted.isEmpty());
                    return (File)sorted.last();
                }
                catch (Exception ex2) {
                    Assert.fail((String)("Cannot find utilities JAR: " + ex + " and: " + ex2));
                    return null;
                }
            }
        }

        private File[] findClusters() throws IOException {
            LinkedHashSet<File> clusters = new LinkedHashSet<File>();
            if (this.config.clusterRegExp != null) {
                S.findClusters(clusters, this.config.clusterRegExp);
            }
            if (this.config.enableClasspathModules) {
                for (String s : S.tokenizePath(System.getProperty("java.class.path"))) {
                    File module = new File(s);
                    File cluster = module.getParentFile().getParentFile();
                    File m = new File(new File(cluster, "config"), "Modules");
                    if (!m.exists() && !cluster.getName().equals("cluster")) continue;
                    clusters.add(cluster);
                }
            }
            return clusters.toArray(new File[0]);
        }

        private static String cnb(Manifest m) {
            String cn = m.getMainAttributes().getValue("OpenIDE-Module");
            return cn != null ? cn.replaceFirst("/\\d+", "") : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Set<String> findEnabledModules(ClassLoader loader) throws IOException {
            TreeSet<String> cnbs = new TreeSet<String>();
            Enumeration<URL> en = loader.getResources("META-INF/MANIFEST.MF");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                InputStream is = url.openStream();
                try {
                    String cnb = S.cnb(new Manifest(is));
                    if (cnb == null) continue;
                    cnbs.add(cnb);
                }
                finally {
                    is.close();
                }
            }
            return cnbs;
        }

        static void turnClassPathModules(File ud, ClassLoader loader) throws IOException {
            Enumeration<URL> en = loader.getResources("META-INF/MANIFEST.MF");
            while (en.hasMoreElements()) {
                File jar;
                Manifest m;
                URL url = en.nextElement();
                InputStream is = url.openStream();
                try {
                    m = new Manifest(is);
                }
                catch (IOException x) {
                    throw new IOException("parsing " + url + ": " + x, x);
                }
                finally {
                    is.close();
                }
                String cnb = S.cnb(m);
                if (cnb == null || (jar = S.jarFromURL(url)) == null || pseudoModules.contains(cnb)) continue;
                String mavenCP = m.getMainAttributes().getValue("Maven-Class-Path");
                if (mavenCP != null) {
                    jar = S.rewrite(jar, mavenCP.split(" "), System.getProperty("java.class.path"));
                }
                String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + cnb + "\">\n" + "    <param name=\"autoload\">false</param>\n" + "    <param name=\"eager\">false</param>\n" + "    <param name=\"enabled\">true</param>\n" + "    <param name=\"jar\">" + jar + "</param>\n" + "    <param name=\"reloadable\">false</param>\n" + "</module>\n";
                File conf = new File(new File(ud, "config"), "Modules");
                conf.mkdirs();
                File f = new File(conf, cnb.replace('.', '-') + ".xml");
                S.writeModule(f, xml);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static File rewrite(File jar, String[] mavenCP, String classpath) throws IOException {
            String[] classpathEntries = S.tokenizePath(classpath);
            StringBuilder classPathHeader = new StringBuilder();
            for (String artifact : mavenCP) {
                String[] grpArtVers = artifact.split(":");
                String suffix = File.separatorChar + grpArtVers[0].replace('.', File.separatorChar) + File.separatorChar + grpArtVers[1] + File.separatorChar + grpArtVers[2] + File.separatorChar + grpArtVers[1] + '-' + grpArtVers[2] + ".jar";
                File dep = null;
                for (String classpathEntry : classpathEntries) {
                    if (!classpathEntry.endsWith(suffix)) continue;
                    dep = new File(classpathEntry);
                    break;
                }
                if (dep == null) {
                    throw new IOException("no match for " + artifact + " found in " + classpath);
                }
                File depCopy = File.createTempFile(artifact.replace(':', '-') + '-', ".jar");
                depCopy.deleteOnExit();
                NbTestCase.copytree(dep, depCopy);
                if (classPathHeader.length() > 0) {
                    classPathHeader.append(' ');
                }
                classPathHeader.append(depCopy.getName());
            }
            String n = jar.getName();
            int dot = n.lastIndexOf(46);
            File jarCopy = File.createTempFile(n.substring(0, dot) + '-', n.substring(dot));
            jarCopy.deleteOnExit();
            FileInputStream is = new FileInputStream(jar);
            try {
                FileOutputStream os = new FileOutputStream(jarCopy);
                try {
                    JarEntry entry;
                    JarInputStream jis = new JarInputStream(is);
                    Manifest mani = new Manifest(jis.getManifest());
                    mani.getMainAttributes().putValue("Class-Path", classPathHeader.toString());
                    JarOutputStream jos = new JarOutputStream((OutputStream)os, mani);
                    while ((entry = jis.getNextJarEntry()) != null) {
                        if (entry.getName().matches("META-INF/.+[.]SF")) {
                            throw new IOException("cannot handle signed JARs");
                        }
                        jos.putNextEntry(entry);
                        byte[] buf = new byte[(int)entry.getSize()];
                        int read = jis.read(buf, 0, buf.length);
                        if (read != buf.length) {
                            throw new IOException("read wrong amount");
                        }
                        jos.write(buf);
                    }
                    jis.close();
                    jos.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
            return jarCopy;
        }

        private static File jarFromURL(URL u) {
            Matcher m = MANIFEST.matcher(u.toExternalForm());
            if (m.matches()) {
                return new File(URI.create(m.group(1)));
            }
            if (!u.getProtocol().equals("file")) {
                throw new IllegalStateException(u.toExternalForm());
            }
            return null;
        }

        static void preparePatches(String path, Properties prop, Class<?> ... classes) throws URISyntaxException {
            Pattern tests = Pattern.compile(".*\\" + File.separator + "([^\\" + File.separator + "]+)\\" + File.separator + "tests\\.jar");
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String jar : S.tokenizePath(path)) {
                Matcher m = tests.matcher(jar);
                if (!m.matches()) continue;
                sb.append(sep).append(jar);
                sep = File.pathSeparator;
            }
            HashSet<URL> uniqueURLs = new HashSet<URL>();
            for (Class<?> c : classes) {
                URL test = c.getProtectionDomain().getCodeSource().getLocation();
                Assert.assertNotNull((String)("URL found for " + c), (Object)test);
                if (!uniqueURLs.add(test)) continue;
                sb.append(sep).append(new File(test.toURI()).getPath());
                sep = File.pathSeparator;
            }
            prop.setProperty("netbeans.systemclassloader.patches", sb.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String asString(InputStream is, boolean close) throws IOException {
            int index;
            StringBuilder builder = new StringBuilder();
            byte[] bytes = new byte[4096];
            try {
                int i;
                while ((i = is.read(bytes)) != -1) {
                    builder.append(new String(bytes, 0, i, "UTF-8"));
                }
            }
            finally {
                if (close) {
                    is.close();
                }
            }
            while ((index = builder.indexOf("\r\n")) != -1) {
                builder.deleteCharAt(index);
            }
            return builder.toString();
        }

        private static void turnModules(File ud, boolean autoloads, TreeSet<String> modules, List<String> regExp, File ... clusterDirs) throws IOException {
            if (regExp == null) {
                return;
            }
            File config = new File(new File(ud, "config"), "Modules");
            config.mkdirs();
            Iterator<String> it = regExp.iterator();
            while (it.hasNext()) {
                String clusterReg = it.next();
                String moduleReg = it.next();
                Pattern modPattern = Pattern.compile(moduleReg);
                for (File c : clusterDirs) {
                    File modulesDir;
                    File[] allModules;
                    if (!c.getName().matches(clusterReg) || (allModules = (modulesDir = new File(new File(c, "config"), "Modules")).listFiles()) == null) continue;
                    for (File m : allModules) {
                        String n = m.getName();
                        if (n.endsWith(".xml")) {
                            n = n.substring(0, n.length() - 4);
                        }
                        n = n.replace('-', '.');
                        String xml = S.asString(new FileInputStream(m), true);
                        boolean contains = modules.contains(n);
                        if (!contains && modPattern != null) {
                            contains = modPattern.matcher(n).matches();
                        }
                        if (!contains) continue;
                        S.enableModule(xml, autoloads, contains, new File(config, m.getName()));
                    }
                }
            }
        }

        private static void enableModule(String xml, boolean autoloads, boolean enable, File target) throws IOException {
            Matcher matcherEager;
            Matcher matcherAuto;
            Matcher matcherEager2;
            boolean toEnable = false;
            Matcher matcherEnabled = ENABLED.matcher(xml);
            if (matcherEnabled.find()) {
                toEnable = "false".equals(matcherEnabled.group(1));
            }
            if ((matcherEager2 = EAGER.matcher(xml)).find() && "true".equals(matcherEager2.group(1))) {
                return;
            }
            if (!autoloads && (matcherAuto = AUTO.matcher(xml)).find() && "true".equals(matcherAuto.group(1))) {
                return;
            }
            if (toEnable) {
                assert (matcherEnabled.groupCount() == 1) : "Groups: " + matcherEnabled.groupCount() + " for:\n" + xml;
                try {
                    String out = xml.substring(0, matcherEnabled.start(1)) + (enable ? "true" : "false") + xml.substring(matcherEnabled.end(1));
                    S.writeModule(target, out);
                }
                catch (IllegalStateException ex) {
                    throw new IOException("Unparsable:\n" + xml, ex);
                }
            }
            if ((matcherEager = AUTO.matcher(xml)).find()) {
                int begin = xml.indexOf("<param name=\"autoload");
                int end = xml.indexOf("<param name=\"jar");
                String middle = "<param name=\"autoload\">false</param>\n    <param name=\"eager\">false</param>\n    <param name=\"enabled\">true</param>\n    ";
                String out = xml.substring(0, begin) + middle + xml.substring(end);
                try {
                    S.writeModule(target, out);
                }
                catch (IllegalStateException ex) {
                    throw new IOException("Unparsable:\n" + xml, ex);
                }
            }
        }

        private static void writeModule(File file, String xml) throws IOException {
            String previous = null;
            if (file.exists()) {
                previous = S.asString(new FileInputStream(file), true);
                if (previous.equals(xml)) {
                    return;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "rewrite module file: {0}", file);
                    S.charDump(previous);
                    LOG.fine("new----");
                    S.charDump(xml);
                    LOG.fine("end----");
                }
            }
            FileOutputStream os = new FileOutputStream(file);
            os.write(xml.getBytes("UTF-8"));
            os.close();
        }

        private static void charDump(String text) {
            StringBuilder sb = new StringBuilder(5 * text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch;
                if (i % 8 == 0) {
                    if (i > 0) {
                        sb.append('\n');
                    }
                } else {
                    sb.append(' ');
                }
                if (' ' <= (ch = text.charAt(i)) && ch <= 'z') {
                    sb.append('\'').append(ch).append('\'');
                    continue;
                }
                sb.append('x').append(S.two(Integer.toHexString(ch).toUpperCase()));
            }
            sb.append('\n');
            LOG.fine(sb.toString());
        }

        private static String two(String s) {
            int len = s.length();
            switch (len) {
                case 0: {
                    return "00";
                }
                case 1: {
                    return "0" + s;
                }
                case 2: {
                    return s;
                }
            }
            return s.substring(len - 2);
        }

        static {
            pseudoModules = new HashSet<String>(Arrays.asList("org.openide.util", "org.openide.util.lookup", "org.openide.modules", "org.netbeans.bootstrap", "org.openide.filesystems", "org.netbeans.core.startup"));
            MANIFEST = Pattern.compile("jar:(file:.*)!/META-INF/MANIFEST.MF", 8);
            ENABLED = Pattern.compile("<param name=[\"']enabled[\"']>([^<]*)</param>", 8);
            AUTO = Pattern.compile("<param name=[\"']autoload[\"']>([^<]*)</param>", 8);
            EAGER = Pattern.compile("<param name=[\"']eager[\"']>([^<]*)</param>", 8);
        }

        private static final class JUnitLoader
        extends ClassLoader {
            private final ClassLoader junit;

            public JUnitLoader(ClassLoader parent, ClassLoader junit) {
                super(parent);
                this.junit = junit;
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (this.isUnit(name)) {
                    return this.junit.loadClass(name);
                }
                return super.findClass(name);
            }

            @Override
            public URL findResource(String name) {
                if (this.isUnit(name)) {
                    return this.junit.getResource(name);
                }
                if (name.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResource("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResource(name);
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                if (this.isUnit(name)) {
                    return this.junit.getResources(name);
                }
                if (name.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResources("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResources(name);
            }

            private boolean isUnit(String res) {
                if (res.startsWith("junit")) {
                    return true;
                }
                if (res.startsWith("org.junit") || res.startsWith("org/junit")) {
                    return true;
                }
                if (res.startsWith("org.netbeans.junit") || res.startsWith("org/netbeans/junit")) {
                    return !res.startsWith("org.netbeans.junit.ide") && !res.startsWith("org/netbeans/junit/ide");
                }
                return false;
            }
        }
    }

    private static final class Item {
        boolean isTestCase;
        Class<?> clazz;
        String[] fileNames;

        public Item(boolean isTestCase, Class<?> clazz, String[] fileNames) {
            this.isTestCase = isTestCase;
            this.clazz = clazz;
            this.fileNames = fileNames;
        }
    }

    public static final class Configuration {
        final List<Item> tests;
        final Class<? extends TestCase> latestTestCaseClass;
        final List<String> clusterRegExp;
        final List<String> moduleRegExp;
        final List<String> startupArgs;
        final ClassLoader parentClassLoader;
        final boolean reuseUserDir;
        final boolean gui;
        final boolean enableClasspathModules;
        final boolean honorAutoEager;
        final Level failOnMessage;
        final Level failOnException;

        private Configuration(List<String> clusterRegExp, List<String> moduleRegExp, List<String> startupArgs, ClassLoader parent, List<Item> testItems, Class<? extends TestCase> latestTestCase, boolean reuseUserDir, boolean gui, boolean enableCPModules, boolean honorAutoEager, Level failOnMessage, Level failOnException) {
            this.clusterRegExp = clusterRegExp;
            this.moduleRegExp = moduleRegExp;
            this.startupArgs = startupArgs;
            this.parentClassLoader = parent;
            this.tests = testItems;
            this.reuseUserDir = reuseUserDir;
            this.latestTestCaseClass = latestTestCase;
            this.gui = gui;
            this.enableClasspathModules = enableCPModules;
            this.honorAutoEager = honorAutoEager;
            this.failOnException = failOnException;
            this.failOnMessage = failOnMessage;
        }

        static Configuration create(Class<? extends TestCase> clazz) {
            return new Configuration(null, null, null, ClassLoader.getSystemClassLoader().getParent(), Collections.<Item>emptyList(), clazz, false, true, true, false, null, null);
        }

        public Configuration clusters(String regExp) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.clusterRegExp != null) {
                list.addAll(this.clusterRegExp);
            }
            if (regExp != null) {
                list.add(regExp);
            }
            if (list.isEmpty()) {
                list = null;
            }
            return new Configuration(list, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration enableModules(String regExp) {
            if (regExp == null) {
                return this;
            }
            return this.enableModules(".*", regExp);
        }

        public Configuration enableModules(String clusterRegExp, String moduleRegExp) {
            ArrayList<String> arr = new ArrayList<String>();
            if (this.moduleRegExp != null) {
                arr.addAll(this.moduleRegExp);
            }
            arr.add(clusterRegExp);
            arr.add(moduleRegExp);
            return new Configuration(this.clusterRegExp, arr, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addStartupArgument(String ... arguments) {
            if (arguments == null || arguments.length < 1) {
                throw new IllegalStateException("Must specify at least one startup argument");
            }
            ArrayList<String> newArgs = new ArrayList<String>();
            if (this.startupArgs != null) {
                newArgs.addAll(this.startupArgs);
            }
            newArgs.addAll(Arrays.asList(arguments));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, newArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        Configuration classLoader(ClassLoader parent) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, parent, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(String ... testNames) {
            if (this.latestTestCaseClass == null) {
                throw new IllegalStateException();
            }
            ArrayList<Item> newTests = new ArrayList<Item>(this.tests);
            newTests.add(new Item(true, this.latestTestCaseClass, testNames));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, newTests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(Class<? extends TestCase> test, String ... testNames) {
            if (test.equals(this.latestTestCaseClass)) {
                return this.addTest(testNames);
            }
            ArrayList<Item> newTests = new ArrayList<Item>(this.tests);
            this.addLatest(newTests);
            if (testNames != null && testNames.length != 0) {
                newTests.add(new Item(true, test, testNames));
            }
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, newTests, test, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration addTest(Class<? extends Test> test) {
            if (TestCase.class.isAssignableFrom(test)) {
                Class<TestCase> tc = test.asSubclass(TestCase.class);
                return this.addTest(tc, new String[0]);
            }
            ArrayList<Item> newTests = new ArrayList<Item>(this.tests);
            newTests.add(new Item(false, test, null));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, newTests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration enableClasspathModules(boolean enable) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, enable, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration honorAutoloadEager(boolean honor) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, honor, this.failOnMessage, this.failOnException);
        }

        public Configuration failOnMessage(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, level, this.failOnException);
        }

        public Configuration failOnException(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, level);
        }

        private void addLatest(List<Item> newTests) {
            if (this.latestTestCaseClass == null) {
                return;
            }
            for (Item item : newTests) {
                if (!item.clazz.equals(this.latestTestCaseClass)) continue;
                return;
            }
            newTests.add(new Item(true, this.latestTestCaseClass, null));
        }

        private Configuration getReady() {
            ArrayList<Item> newTests = new ArrayList<Item>(this.tests);
            this.addLatest(newTests);
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, newTests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration gui(boolean gui) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Configuration reuseUserDir(boolean reuse) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, reuse, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException);
        }

        public Test suite() {
            return new S(this);
        }
    }
}

