/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.EntityClosure;
import org.netbeans.modules.j2ee.persistence.wizard.PersistenceClientEntitySelection;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceClientEntitySelectionVisual
extends JPanel {
    private static final long serialVersionUID = -4552755466067867817L;
    private WizardDescriptor wizard;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Project project;
    boolean waitingForScan;
    boolean waitingForEntities;
    private boolean createPU = true;
    private EntityClosure entityClosure;
    private final boolean disableNoIdSelection;
    private JButton buttonAdd;
    private JButton buttonAddAll;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JCheckBox cbAddRelated;
    private JCheckBox createPUCheckbox;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailableEntities;
    private JLabel labelSelectedEntities;
    private JList listAvailable;
    private JList listSelected;
    private JPanel panelButtons;
    private final ListCellRenderer ENTITY_LIST_RENDERER_AV = new EntityListCellRenderer(true);
    private final ListCellRenderer ENTITY_LIST_RENDERER_SEL = new EntityListCellRenderer(false);

    public PersistenceClientEntitySelectionVisual(String name, WizardDescriptor wizard) {
        this(name, wizard, false);
    }

    public PersistenceClientEntitySelectionVisual(String name, WizardDescriptor wizard, boolean requireReferencedClasses) {
        this.setName(name);
        this.wizard = wizard;
        this.initComponents();
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PersistenceClientEntitySelectionVisual.this.updateButtons();
            }
        };
        this.listAvailable.getSelectionModel().addListSelectionListener(selectionListener);
        this.listSelected.getSelectionModel().addListSelectionListener(selectionListener);
        boolean bl = this.disableNoIdSelection = wizard.getProperty(PersistenceClientEntitySelection.DISABLENOIDSELECTION) == Boolean.TRUE;
        if (requireReferencedClasses) {
            this.cbAddRelated.setSelected(true);
            this.cbAddRelated.setVisible(false);
        }
    }

    public boolean getCreatePersistenceUnit() {
        return this.createPU && this.createPUCheckbox.isVisible();
    }

    private Set<String> getSelectedEntities(JList list) {
        HashSet<String> result = new HashSet<String>();
        for (Object elem : Util.getSelectedItems(list, true)) {
            result.add((String)elem);
        }
        return result;
    }

    private Set<String> getEnabledEntities(JList list) {
        HashSet<String> result = new HashSet<String>();
        for (Object elem : Util.getEnabledItems(list)) {
            result.add((String)elem);
        }
        return result;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JList();
        this.cbAddRelated = new JCheckBox();
        this.labelAvailableEntities = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonRemove = new JButton();
        this.buttonAdd = new JButton();
        this.buttonAddAll = new JButton();
        this.buttonRemoveAll = new JButton();
        this.labelSelectedEntities = new JLabel();
        this.createPUCheckbox = new JCheckBox();
        this.listAvailable.setCellRenderer(this.ENTITY_LIST_RENDERER_AV);
        this.jScrollPane1.setViewportView(this.listAvailable);
        this.listAvailable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntitiesList"));
        this.listAvailable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AvailableEntitiesList"));
        this.listSelected.setCellRenderer(this.ENTITY_LIST_RENDERER_SEL);
        this.jScrollPane2.setViewportView(this.listSelected);
        this.listSelected.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntitiesList"));
        this.listSelected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_SelectedEntitiesList"));
        this.cbAddRelated.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_InludeRelated").charAt(0));
        this.cbAddRelated.setSelected(true);
        this.cbAddRelated.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferenced"));
        this.cbAddRelated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddRelated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.cbAddRelatedActionPerformed(evt);
            }
        });
        this.labelAvailableEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AvailableEntityClasses").charAt(0));
        this.labelAvailableEntities.setLabelFor(this.listAvailable);
        this.labelAvailableEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AvailableEntities"));
        this.buttonRemove.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Remove").charAt(0));
        this.buttonRemove.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Remove"));
        this.buttonRemove.setActionCommand("< &Remove");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveActionPerformed(evt);
            }
        });
        this.buttonAdd.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Add").charAt(0));
        this.buttonAdd.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Add"));
        this.buttonAdd.setActionCommand("&Add >");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddActionPerformed(evt);
            }
        });
        this.buttonAddAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AddAll").charAt(0));
        this.buttonAddAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_AddAll"));
        this.buttonAddAll.setActionCommand("Add A&ll >>");
        this.buttonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddAllActionPerformed(evt);
            }
        });
        this.buttonRemoveAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_RemoveAll").charAt(0));
        this.buttonRemoveAll.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_RemoveAll"));
        this.buttonRemoveAll.setActionCommand("<< Re&moveAll");
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveAllActionPerformed(evt);
            }
        });
        GroupLayout panelButtonsLayout = new GroupLayout(this.panelButtons);
        this.panelButtons.setLayout(panelButtonsLayout);
        panelButtonsLayout.setHorizontalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelButtonsLayout.createSequentialGroup().addContainerGap().addGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonAdd, GroupLayout.Alignment.TRAILING, -1, 124, Short.MAX_VALUE).addComponent(this.buttonRemove, GroupLayout.Alignment.TRAILING, -1, 124, Short.MAX_VALUE).addComponent(this.buttonRemoveAll, GroupLayout.Alignment.TRAILING, -2, 124, Short.MAX_VALUE).addComponent(this.buttonAddAll, GroupLayout.Alignment.TRAILING, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        panelButtonsLayout.setVerticalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelButtonsLayout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.buttonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemove).addGap(20, 20, 20).addComponent(this.buttonAddAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveAll).addContainerGap(127, Short.MAX_VALUE)));
        this.buttonRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Remove"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_Add"));
        this.buttonAddAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_AddAll"));
        this.buttonRemoveAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_RemoveAll"));
        this.labelSelectedEntities.setDisplayedMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_SelectedEntityClasses").charAt(0));
        this.labelSelectedEntities.setLabelFor(this.listSelected);
        this.labelSelectedEntities.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_SelectedEntities"));
        this.createPUCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.setEnabled(false);
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PersistenceClientEntitySelectionVisual.this.createPUCheckboxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelAvailableEntities).addComponent(this.jScrollPane1, -1, 306, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelButtons, -2, -1, -2).addGap(0, 0, 0)).addGroup(layout.createSequentialGroup().addComponent(this.createPUCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAddRelated).addComponent(this.labelSelectedEntities).addComponent(this.jScrollPane2, -1, 217, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSelectedEntities).addComponent(this.labelAvailableEntities)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 326, Short.MAX_VALUE).addComponent(this.panelButtons, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 326, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAddRelated).addComponent(this.createPUCheckbox)).addGap(31, 31, 31)));
        this.cbAddRelated.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_IncludeReferencedCheckbox"));
        this.cbAddRelated.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ACSD_IncludeReferencedCheckbox"));
    }

    private void cbAddRelatedActionPerformed(ActionEvent evt) {
        this.listSelected.clearSelection();
        this.listAvailable.clearSelection();
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.changeSupport.fireChange();
    }

    private void buttonRemoveAllActionPerformed(ActionEvent evt) {
        this.entityClosure.removeAllEntities();
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddAllActionPerformed(ActionEvent evt) {
        this.entityClosure.addEntities(this.getEnabledEntities(this.listAvailable));
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        this.entityClosure.removeEntities(this.getSelectedEntities(this.listSelected));
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.entityClosure.addEntities(this.getSelectedEntities(this.listAvailable));
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void createPUCheckboxItemStateChanged(ItemEvent evt) {
        this.createPU = this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public boolean valid(WizardDescriptor wizard) {
        ClassPath compileCP;
        SourceGroup[] groups = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (groups.length > 0 && (compileCP = ClassPath.getClassPath((FileObject)groups[0].getRootFolder(), (String)"classpath/compile")).findResource("javax/persistence/Entity.class") == null) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoPersistenceProvider"));
            return false;
        }
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_MissingServer"));
            return false;
        }
        if (!this.entityClosure.isModelReady()) {
            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                @Override
                public void run() {
                    PersistenceClientEntitySelectionVisual.this.entityClosure.waitModelIsReady();
                    PersistenceClientEntitySelectionVisual.this.changeSupport.fireChange();
                    PersistenceClientEntitySelectionVisual.this.updateButtons();
                }
            });
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"scanning-in-progress"));
            task.schedule(0);
            return false;
        }
        if (this.listSelected.getModel().getSize() == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MSG_NoEntityClassesSelected"));
            return false;
        }
        wizard.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.project.getProjectDirectory());
        this.entityClosure = EntityClosure.create(entityClassScope, this.project);
        this.entityClosure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersistenceClientEntitySelectionVisual.this.updateAddAllButton();
            }
        });
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.listAvailable.setModel(new EntityListModel(this.entityClosure, true));
        this.listSelected.setModel(new EntityListModel(this.entityClosure, false));
        ArrayList entities = (ArrayList)settings.getProperty("EntityClass");
        if (entities == null) {
            entities = new ArrayList();
        }
        this.entityClosure.addEntities(new HashSet<String>(entities));
        this.updateButtons();
        this.updatePersistenceUnitButton();
    }

    public void store(WizardDescriptor settings) {
        ListModel model = this.listSelected.getModel();
        if (model instanceof EntityListModel) {
            EntityListModel elm = (EntityListModel)model;
            settings.putProperty("EntityClass", elm.getEntityClasses());
        }
    }

    private void updateButtons() {
        Set selectedItems = Util.getSelectedItems(this.listAvailable, true);
        this.buttonAdd.setEnabled(!selectedItems.isEmpty());
        this.updateAddAllButton();
        this.buttonRemove.setEnabled(this.listSelected.getSelectedValues().length > 0);
        this.buttonRemoveAll.setEnabled(this.entityClosure.getSelectedEntities().size() > 0);
    }

    private void updateAddAllButton() {
        this.buttonAddAll.setEnabled(!Util.getEnabledItems(this.listAvailable).isEmpty());
    }

    public void updatePersistenceUnitButton() {
        boolean visible = true;
        if (ProviderUtil.isValidServerInstanceOrNone(this.project) && visible) {
            PersistenceScope[] scopes = PersistenceUtils.getPersistenceScopes(this.project);
            for (int i = 0; i < scopes.length; ++i) {
                FileObject persistenceXml = scopes[i].getPersistenceXml();
                if (persistenceXml == null) continue;
                try {
                    Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceXml);
                    if (persistence.getPersistenceUnit().length <= 0) continue;
                    visible = false;
                    break;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        this.createPUCheckbox.setVisible(visible);
    }

    private final class EntityListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private boolean available;

        public EntityListCellRenderer(boolean available) {
            this.setOpaque(true);
            this.available = available;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = null;
            boolean disable = false;
            if (value instanceof Entity) {
                Entity entity = (Entity)value;
                text = entity.getClass2();
                if (text != null) {
                    String simpleName = JavaIdentifiers.unqualify((String)text);
                    String packageName = text.length() > simpleName.length() ? text.substring(0, text.length() - simpleName.length() - 1) : "<default package>";
                    text = simpleName + " (" + packageName + ")";
                } else {
                    Logger.getLogger("global").log(Level.INFO, "Entity:" + value + " returns null from getClass2(); see IZ 80024");
                }
                if (PersistenceClientEntitySelectionVisual.this.disableNoIdSelection && this.available && PersistenceClientEntitySelectionVisual.this.entityClosure.haveId(entity.getClass2()) != Boolean.TRUE) {
                    text = text + " (" + NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoId") + ")";
                    disable = PersistenceClientEntitySelectionVisual.this.disableNoIdSelection;
                }
            }
            if (text == null) {
                text = value.toString();
                if (PersistenceClientEntitySelectionVisual.this.disableNoIdSelection && this.available && PersistenceClientEntitySelectionVisual.this.entityClosure.haveId(text) != Boolean.TRUE && PersistenceClientEntitySelectionVisual.this.entityClosure.getEntity(text) != null) {
                    text = text + " (" + NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoId") + ")";
                    disable = PersistenceClientEntitySelectionVisual.this.disableNoIdSelection;
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled((PersistenceClientEntitySelectionVisual.this.entityClosure.getAvailableEntities().contains(value) || PersistenceClientEntitySelectionVisual.this.entityClosure.getWantedEntities().contains(value)) && !disable);
            this.setFont(list.getFont());
            this.setText(text);
            return this;
        }
    }

    private class EntityListModel
    extends AbstractListModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<String> entities = new ArrayList<String>();
        private boolean available;

        EntityListModel(EntityClosure entityClosure, boolean available) {
            this.entityClosure = entityClosure;
            this.available = available;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.entities.get(index);
        }

        public List<String> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.entities = new ArrayList<String>(this.available ? this.entityClosure.getAvailableEntities() : this.entityClosure.getSelectedEntities());
            Collections.sort(this.entities);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }
    }
}

