/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indent;

import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzer;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.editor.ext.html.parser.spi.HtmlModel;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;
import org.netbeans.modules.web.indent.api.support.MarkupAbstractIndenter;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HtmlIndenter
extends MarkupAbstractIndenter<HTMLTokenId> {
    private HtmlModel model;
    private static final String[] TAGS_WITH_UNFORMATTABLE_CONTENT = new String[]{"pre", "textarea"};

    public HtmlIndenter(Context context) {
        super(HTMLTokenId.language(), context);
        try {
            Document doc = context.document();
            FileObject file = DataLoadersBridge.getDefault().getFileObject(doc);
            String code = doc.getText(0, doc.getLength());
            HtmlSource source = new HtmlSource((CharSequence)code, null, file);
            SyntaxAnalyzerResult result = SyntaxAnalyzer.create((HtmlSource)source).analyze();
            this.model = result.getHtmlModel();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        assert (this.model != null);
    }

    protected boolean isWhiteSpaceToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.TEXT && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected boolean isOpenTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().toUpperCase().startsWith("<!");
    }

    protected boolean isCloseTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE;
    }

    protected boolean isStartTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("<");
    }

    protected boolean isStartTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("</");
    }

    protected boolean isEndTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals(">");
    }

    protected boolean isEndTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals("/>") || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().startsWith(">");
    }

    protected boolean isTagArgumentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.ARGUMENT;
    }

    protected boolean isBlockCommentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.BLOCK_COMMENT;
    }

    protected boolean isTagContentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TEXT;
    }

    protected boolean isClosingTagOptional(CharSequence tagName) {
        HtmlTag elem = this.model.getTag(((Object)tagName).toString());
        if (elem == null) {
            return false;
        }
        return elem.hasOptionalEndTag();
    }

    protected boolean isOpeningTagOptional(CharSequence tagName) {
        HtmlTag elem = this.model.getTag(((Object)tagName).toString());
        if (elem == null) {
            return false;
        }
        return elem.hasOptionalOpenTag();
    }

    protected Boolean isEmptyTag(CharSequence tagName) {
        HtmlTag elem = this.model.getTag(((Object)tagName).toString());
        if (elem == null) {
            return false;
        }
        return elem.isEmpty();
    }

    protected boolean isTagContentUnformattable(CharSequence tagName) {
        for (String t : TAGS_WITH_UNFORMATTABLE_CONTENT) {
            if (!t.equalsIgnoreCase(((Object)tagName).toString())) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getTagChildren(CharSequence tagName) {
        HtmlTag tag = this.model.getTag(((Object)tagName).toString());
        if (tag == null) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (HtmlTag child : tag.getChildren()) {
            String name = child.getName().toUpperCase();
            set.add(name);
        }
        return set;
    }

    protected boolean isPreservedLine(Token<HTMLTokenId> token, IndenterContextData<HTMLTokenId> context) {
        String comment;
        return this.isBlockCommentToken(token) && !(comment = ((Object)token.text()).toString().trim()).startsWith("<!--") && !comment.startsWith("-->");
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<HTMLTokenId> ts) throws BadLocationException {
        int[] index = ts.index();
        boolean found = false;
        while (this.isBlockCommentToken((Token<HTMLTokenId>)ts.token())) {
            String comment = ((Object)ts.token().text()).toString().trim();
            if (comment.startsWith("<!--")) {
                found = true;
                break;
            }
            if (ts.movePrevious()) continue;
        }
        int indent = 0;
        if (found) {
            int lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)ts.offset());
            int column = ts.offset();
            indent = column - lineStart;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return indent;
    }

    private boolean isOpeningTag(JoinedTokenSequence<HTMLTokenId> ts) {
        int[] index = ts.index();
        boolean found = false;
        while (ts.moveNext()) {
            if (this.isEndTagSymbol((Token<HTMLTokenId>)ts.currentTokenSequence().token())) {
                found = true;
                break;
            }
            if (!this.isEndTagClosingSymbol((Token<HTMLTokenId>)ts.currentTokenSequence().token())) continue;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return found;
    }

    protected boolean isForeignLanguageStartToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> ts) {
        return this.isOpenTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script")) && this.isOpeningTag(ts);
    }

    protected boolean isForeignLanguageEndToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> ts) {
        return this.isCloseTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script"));
    }
}

