/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.HtmlErrorFilter;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.ProjectDefaultHtmlSourceVersionController;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.EmbeddingUtil;
import org.netbeans.modules.html.editor.hints.FatalHtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.HtmlValidatorRule;
import org.netbeans.modules.html.editor.hints.RemoveSurroundingTag;
import org.netbeans.modules.html.editor.hints.SurroundWithTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HtmlHintsProvider
implements HintsProvider {
    private static final HtmlRule ERROR_RULE = new HtmlRule(HintSeverity.ERROR, true);
    private static final HtmlRule WARNING_RULE = new HtmlRule(HintSeverity.WARNING, true);
    private static final HtmlRule INFO_RULE = new HtmlRule(HintSeverity.INFO, true);

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        HtmlVersion version = result.getDetectedHtmlVersion();
        FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        boolean xhtml = result.getSyntaxAnalyzerResult().mayBeXhtml();
        if (version == null) {
            if (project == null) {
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_CANNOT_DETERMINE_HTML_VERSION_NO_PROJECT"), file, new OffsetRange(0, 0), Collections.emptyList(), 100){});
            } else {
                HtmlVersion defaulted = ProjectDefaultHtmlSourceVersionController.getDefaultHtmlVersion(project, xhtml);
                String msg = defaulted == null ? NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION" : "MSG_CANNOT_DETERMINE_HTML_VERSION")) : NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION_DEFAULTED_ALREADY" : "MSG_CANNOT_DETERMINE_HTML_VERSION_DEFAULTED_ALREADY"), (Object)defaulted.getDisplayName());
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), msg, file, new OffsetRange(0, 0), HtmlHintsProvider.generateSetDefaultHtmlVersionHints(project, result.getSnapshot().getSource().getDocument(false), xhtml), 100){});
            }
        }
    }

    private static List<HintFix> generateSetDefaultHtmlVersionHints(Project project, Document doc, boolean xhtml) {
        LinkedList<HintFix> fixes = new LinkedList<HintFix>();
        if (project != null) {
            for (HtmlVersion v : HtmlVersion.values()) {
                if (xhtml != v.isXhtml()) continue;
                fixes.add(new SetDefaultHtmlVersionHintFix(v, project, doc, xhtml));
            }
        }
        return fixes;
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            ext.computeSelectionHints(manager, context, suggestions, start, end);
        }
        suggestions.add(new SurroundWithTag(context, new OffsetRange(start, end)));
        suggestions.add(new RemoveSurroundingTag(context, new OffsetRange(start, end)));
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        SyntaxAnalyzerResult saresult = result.getSyntaxAnalyzerResult();
        Snapshot snapshot = result.getSnapshot();
        FileObject fo = snapshot.getSource().getFileObject();
        if (fo == null) {
            return;
        }
        ArrayList<HintFix> defaultFixes = new ArrayList<HintFix>(3);
        if (!HtmlErrorFilter.isErrorCheckingDisabledForFile(saresult)) {
            defaultFixes.add(new DisableErrorChecksFix(snapshot));
        }
        if (HtmlErrorFilter.isErrorCheckingEnabledForMimetype(saresult)) {
            defaultFixes.add(new DisableErrorChecksForMimetypeFix(saresult));
        }
        HtmlRuleContext htmlRuleContext = new HtmlRuleContext(result, saresult, defaultFixes);
        ArrayList<Error> fatalErrors = new ArrayList<Error>();
        for (Error error : htmlRuleContext.getLeftDiagnostics()) {
            if (error.getSeverity() != Severity.FATAL) continue;
            fatalErrors.add(error);
        }
        for (Error error : fatalErrors) {
            htmlRuleContext.getLeftDiagnostics().remove(error);
            String message = error.getDescription() + '\n' + NbBundle.getMessage(HtmlValidatorRule.class, (String)"MSG_FatalHtmlErrorAddendum");
            Hint fatalErrorHint = new Hint((Rule)new FatalHtmlRule(), message, fo, EmbeddingUtil.getErrorOffsetRange(error, snapshot), Collections.emptyList(), 5);
            hints.add(fatalErrorHint);
        }
        if (HtmlErrorFilter.isErrorCheckingEnabled(saresult)) {
            Map allHints = manager.getHints(false, context);
            List list = (List)allHints.get((Object)HtmlRule.Kinds.DEFAULT);
            if (list == null) {
                return;
            }
            for (org.netbeans.modules.html.editor.hints.HtmlRule rule : list) {
                boolean enabled = manager.isEnabled((Rule.UserConfigurableRule)rule);
                if (rule.isSpecialHtmlValidatorRule()) {
                    rule.setEnabled(enabled);
                    rule.run(htmlRuleContext, hints);
                    continue;
                }
                if (!enabled) continue;
                rule.run(htmlRuleContext, hints);
            }
        } else {
            ArrayList<Object> fixes = new ArrayList<Object>(3);
            if (HtmlErrorFilter.isErrorCheckingDisabledForFile(saresult)) {
                fixes.add(new EnableErrorChecksFix(snapshot));
            }
            if (!HtmlErrorFilter.isErrorCheckingEnabledForMimetype(saresult)) {
                fixes.add(new EnableErrorChecksForMimetypeFix(saresult));
            }
            Hint hint = new Hint((Rule)new HtmlRule(HintSeverity.INFO, false), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fo, new OffsetRange(0, 0), fixes, 50);
            hints.add(hint);
        }
        for (HtmlExtension htmlExtension : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            htmlExtension.computeErrors(manager, context, hints, unhandled);
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static HtmlRule getRule(Severity s) {
        switch (s) {
            case INFO: {
                return INFO_RULE;
            }
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private static void forceReparse(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static class SetDefaultHtmlVersionHintFix
    implements HintFix {
        private HtmlVersion version;
        private Document doc;
        private Project project;
        private boolean xhtml;

        public SetDefaultHtmlVersionHintFix(HtmlVersion version, Project project, Document doc, boolean xhtml) {
            this.version = version;
            this.project = project;
            this.doc = doc;
            this.xhtml = xhtml;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_SET_DEFAULT_HTML_VERSION", (Object)this.version.getDisplayName());
        }

        public void implement() throws Exception {
            ProjectDefaultHtmlSourceVersionController.setDefaultHtmlVersion(this.project, this.version, this.xhtml);
            HtmlHintsProvider.forceReparse(this.doc);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class EnableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public EnableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_MIMETYPE", (Object)this.mimeType);
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.mimeType, true);
            if (this.doc != null) {
                HtmlHintsProvider.forceReparse(this.doc);
            }
        }
    }

    private static final class DisableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public DisableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_MIMETYPE", (Object)this.mimeType);
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.mimeType, false);
            if (this.doc != null) {
                HtmlHintsProvider.forceReparse(this.doc);
            }
        }
    }

    private static abstract class AbstractErrorChecksForMimetypeFix
    implements HintFix {
        protected Document doc;
        protected String mimeType;

        public AbstractErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            this.doc = result.getSource().getSnapshot().getSource().getDocument(false);
            this.mimeType = HtmlErrorFilter.getWebPageMimeType(result);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public EnableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute("disable_error_checking", null);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public DisableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute("disable_error_checking", (Object)Boolean.TRUE);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class HtmlRule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private HtmlRule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "html";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

