/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeWizards;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.newproject.Bundle;
import org.netbeans.modules.maven.j2ee.newproject.EAWizardIterator;
import org.netbeans.modules.maven.j2ee.newproject.EELevelPanel;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class BasicEEWizardIterator
implements WizardDescriptor.BackgroundInstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;
    private Archetype[] archs;
    static final String PROP_EE_LEVEL = "eeLevel";

    private BasicEEWizardIterator(Archetype[] archs) {
        this.archs = archs;
    }

    public static BasicEEWizardIterator createWebAppIterator() {
        return new BasicEEWizardIterator(EAWizardIterator.WEB_APP_ARCHS);
    }

    public static BasicEEWizardIterator createEJBIterator() {
        return new BasicEEWizardIterator(EAWizardIterator.EJB_ARCHS);
    }

    public static BasicEEWizardIterator createAppClientIterator() {
        return new BasicEEWizardIterator(EAWizardIterator.APPCLIENT_ARCHS);
    }

    static String[] eeLevels() {
        return new String[]{Bundle.LBL_JEE6(), Bundle.LBL_JEE5(), Bundle.LBL_J2EE14()};
    }

    private WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{ArchetypeWizards.basicWizardPanel((ValidationGroup)vg, (boolean)false, null), new EELevelPanel()};
    }

    private String[] createSteps() {
        return new String[]{Bundle.LBL_CreateProjectStep2ee(), Bundle.LBL_EESettings()};
    }

    public Set<FileObject> instantiate() throws IOException {
        ProjectInfo vi = new ProjectInfo((String)this.wiz.getProperty("groupId"), (String)this.wiz.getProperty("artifactId"), (String)this.wiz.getProperty("version"), (String)this.wiz.getProperty("package"));
        Archetype arch = this.archs[(Integer)this.wiz.getProperty(PROP_EE_LEVEL)];
        ArchetypeWizards.logUsage((String)arch.getGroupId(), (String)arch.getArtifactId(), (String)arch.getVersion());
        File projFile = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        ArchetypeWizards.createFromArchetype((File)projFile, (ProjectInfo)vi, (Archetype)arch, null, (boolean)true);
        return ArchetypeWizards.openProjects((File)projFile, null);
    }

    public void initialize(WizardDescriptor wiz) {
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = this.createPanels(vg);
        this.wiz = wiz;
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public String name() {
        return Bundle.NameFormat(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

