/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SmartyOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SmartyOptionsPanel smartyOptionsPanel = null;
    private volatile boolean changed = false;

    public void update() {
        this.getOptions().setDefaultOpenDelimiter(this.smartyOptionsPanel.getOpenDelimiter());
        this.getOptions().setDefaultCloseDelimiter(this.smartyOptionsPanel.getCloseDelimiter());
        this.getOptions().setScanningDepth(this.smartyOptionsPanel.getDepthOfScanning());
        this.changed = false;
    }

    public void applyChanges() {
        this.getOptions().setDefaultOpenDelimiter(this.smartyOptionsPanel.getOpenDelimiter());
        this.getOptions().setDefaultCloseDelimiter(this.smartyOptionsPanel.getCloseDelimiter());
        this.getOptions().setScanningDepth(this.smartyOptionsPanel.getDepthOfScanning());
        this.changed = false;
        LexerUtils.relexerOpenedTpls();
    }

    public void cancel() {
    }

    public boolean isValid() {
        if (this.smartyOptionsPanel.getOpenDelimiter().equals("") || this.smartyOptionsPanel.getCloseDelimiter().equals("")) {
            this.smartyOptionsPanel.setError(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"WRN_EmptyDelimiterFields"));
            return false;
        }
        if (this.smartyOptionsPanel.getDepthOfScanning() > 1) {
            this.smartyOptionsPanel.setWarning(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"WRN_TooDeepScanningLevel"));
            return true;
        }
        this.smartyOptionsPanel.setWarning(" ");
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.smartyOptionsPanel == null) {
            this.smartyOptionsPanel = new SmartyOptionsPanel();
            this.smartyOptionsPanel.addChangeListener(this);
        }
        return this.smartyOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private SmartyOptions getOptions() {
        return SmartyOptions.getInstance();
    }
}

