/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.ui.options;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SmartyOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -1384644114740L;
    private final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final int MAX_SCANNING_DEPTH = 3;
    private JLabel closeDelimiterLabel;
    private JTextField closeDelimiterTextField;
    private JComboBox depthOfScanningComboBox;
    private JLabel depthOfScanningLabel;
    private JLabel depthOfScanningNoteLabel;
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JSeparator jSeparator1;
    private JLabel learnMoreLabel;
    private JLabel openDelimiterLabel;
    private JTextField openDelimiterTextField;

    public SmartyOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.setDepthOfScanningComboBox();
        this.setOpenDelimiter(SmartyOptions.getInstance().getDefaultOpenDelimiter());
        this.setCloseDelimiter(SmartyOptions.getInstance().getDefaultCloseDelimiter());
        this.setDepthOfScanning(SmartyFramework.getDepthOfScanningForTpl());
        this.openDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
        this.closeDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
        this.depthOfScanningComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartyOptionsPanel.this.fireChange();
            }
        });
    }

    private void setDepthOfScanningComboBox() {
        for (int i = 0; i <= 3; ++i) {
            this.depthOfScanningComboBox.addItem(String.valueOf(i));
        }
    }

    public String getCloseDelimiter() {
        return this.closeDelimiterTextField.getText();
    }

    public void setCloseDelimiter(String closeDelimiter) {
        this.closeDelimiterTextField.setText(closeDelimiter);
    }

    public String getOpenDelimiter() {
        return this.openDelimiterTextField.getText();
    }

    public void setOpenDelimiter(String openDelimiter) {
        this.openDelimiterTextField.setText(openDelimiter);
    }

    public int getDepthOfScanning() {
        return this.depthOfScanningComboBox.getSelectedIndex();
    }

    public void setDepthOfScanning(int depth) {
        if (depth > 3) {
            depth = 3;
        } else if (depth < 0) {
            depth = 0;
        }
        this.depthOfScanningComboBox.setSelectedIndex(depth);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(Color.ORANGE);
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.openDelimiterLabel = new JLabel();
        this.closeDelimiterLabel = new JLabel();
        this.closeDelimiterTextField = new JTextField();
        this.errorLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.depthOfScanningLabel = new JLabel();
        this.depthOfScanningNoteLabel = new JLabel();
        this.depthOfScanningComboBox = new JComboBox();
        this.openDelimiterTextField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.openDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.openDelimiterLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.closeDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.closeDelimiterLabel.text"));
        this.closeDelimiterTextField.setText(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.closeDelimiterTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.depthOfScanningLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.depthOfScanningLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.depthOfScanningNoteLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.depthOfScanningNoteLabel.text"));
        this.openDelimiterTextField.setText(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.openDelimiterTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 586, Short.MAX_VALUE).addComponent(this.errorLabel).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.installationInfoLabel).addGroup(layout.createSequentialGroup().addComponent(this.depthOfScanningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthOfScanningComboBox, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.depthOfScanningNoteLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeDelimiterLabel).addComponent(this.openDelimiterLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.openDelimiterTextField).addComponent(this.closeDelimiterTextField, -1, 100, Short.MAX_VALUE)).addGap(13, 13, 13))).addContainerGap()));
        layout.linkSize(0, this.closeDelimiterTextField, this.openDelimiterTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openDelimiterLabel).addComponent(this.openDelimiterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeDelimiterLabel).addComponent(this.closeDelimiterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.depthOfScanningLabel).addComponent(this.depthOfScanningNoteLabel).addComponent(this.depthOfScanningComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 161, Short.MAX_VALUE).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addGap(6, 6, 6)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://www.smarty.net/manual/en/installing.smarty.basic.php");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class SmartyDocumentListener
    implements DocumentListener {
        private SmartyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SmartyOptionsPanel.this.fireChange();
        }
    }
}

