/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;

public class TplEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";
    private boolean isPhpEnabled;

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), TplTopTokenId.language());
        TokenSequence sequence = th.tokenSequence(TplTopTokenId.language());
        if (sequence == null) {
            Logger.getLogger("TplEmbeddingProvider").warning("TokenHierarchy.tokenSequence(TplTopTokenId.language()) == null for static immutable TPL TokenHierarchy!\nFile = '" + snapshot.getSource().getFileObject().getPath() + "' ;snapshot mimepath='" + snapshot.getMimePath() + "'");
            return Collections.emptyList();
        }
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int len = 0;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id().getClass() == TplTopTokenId.class && this.isSmartyToken((TplTopTokenId)t.id())) {
                if (this.isPhpEnabled) {
                    this.isPhpEnabled = false;
                    embeddings.add(snapshot.create((CharSequence)";?>", "text/x-php5"));
                }
                if (from < 0) {
                    from = sequence.offset();
                }
                len += t.length();
                continue;
            }
            if (from < 0) {
                from = sequence.offset();
            }
            if (len > 0 && from >= 0) {
                from += len;
                len = 0;
            }
            len += t.length();
            if (from >= 0) {
                if (t.id() == TplTopTokenId.T_PHP) {
                    if (!this.isPhpEnabled) {
                        this.isPhpEnabled = true;
                        embeddings.add(snapshot.create((CharSequence)"<?", "text/x-php5"));
                    }
                    embeddings.add(snapshot.create(from, len, "text/x-php5"));
                } else {
                    if (this.isPhpEnabled) {
                        this.isPhpEnabled = false;
                        embeddings.add(snapshot.create((CharSequence)";?>", "text/x-php5"));
                    }
                    embeddings.add(snapshot.create(from, len, "text/x-php5"));
                }
            }
            from = -1;
            len = 0;
        }
        if (from >= 0) {
            embeddings.add(snapshot.create(from, len, "text/x-php5"));
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 130;
    }

    public void cancel() {
    }

    public boolean isSmartyToken(TplTopTokenId tokenId) {
        return tokenId == TplTopTokenId.T_COMMENT || tokenId == TplTopTokenId.T_LITERAL_DEL || tokenId == TplTopTokenId.T_PHP_DEL || tokenId == TplTopTokenId.T_SMARTY || tokenId == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER || tokenId == TplTopTokenId.T_SMARTY_OPEN_DELIMITER;
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new TplEmbeddingProvider());
        }
    }
}

