/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.completion;

import java.util.ArrayList;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.editor.completion.TplCompletionItem;
import org.netbeans.modules.php.smarty.editor.completion.entries.SmartyCodeCompletionOffer;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.openide.util.Exceptions;

public class CodeCompletionUtils {
    private static final int COMPLETION_MAX_FILTER_LENGHT = 20;
    private static final int SCANNING_MAX_FILTER_LENGHT = 100;

    public static String getTextPrefix(Document doc, int offset) {
        int readLength = 20 > offset ? offset : 20;
        try {
            int lastWS = CodeCompletionUtils.getLastWS(doc.getText(offset - readLength, readLength), SmartyFramework.getOpenDelimiter(NbEditorUtilities.getFileObject((Document)doc)));
            return doc.getText(offset - lastWS, lastWS);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    public static int getSubstitutionLenght(Document doc, int offset) {
        return CodeCompletionUtils.getTextPrefix(doc, offset).length();
    }

    public static int getLastWS(String area, String openDelimiter) {
        for (int i = area.length() - 1; i >= 0; --i) {
            if (LexerUtils.isWS(area.charAt(i)) || area.charAt(i) == '|' || area.charAt(i) == '/') {
                return area.length() - i - 1;
            }
            if (!area.substring(i).startsWith(openDelimiter)) continue;
            return area.length() - i - openDelimiter.length();
        }
        return area.length();
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        return text.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    public static boolean insideSmartyCode(Document doc, int offset) {
        TokenId tokenID;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(offset);
        return !tokenSequence.moveNext() && !tokenSequence.movePrevious() || (tokenID = tokenSequence.token().id()) != TplTopTokenId.T_HTML && tokenID != TplTopTokenId.T_PHP && tokenID != TplTopTokenId.T_COMMENT;
    }

    static boolean inVariableModifiers(Document doc, int caretOffset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(caretOffset);
        tokenSequence.movePrevious();
        tokenSequence.moveNext();
        while (!tokenSequence.isEmpty()) {
            if (tokenSequence.token().id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                return false;
            }
            if (tokenSequence.token().id() == TplTopTokenId.T_SMARTY && ((Object)tokenSequence.token().text()).toString().contains("|")) {
                return true;
            }
            tokenSequence.movePrevious();
        }
        return false;
    }

    static ArrayList<String> afterSmartyCommand(Document doc, int offset) {
        int readLength = 100 > offset ? offset : 100;
        try {
            return CodeCompletionUtils.getLastKeywords(doc.getText(offset - readLength, readLength), SmartyFramework.getOpenDelimiter(NbEditorUtilities.getFileObject((Document)doc)));
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> getLastKeywords(String area, String openDelimiter) {
        int delimiterPosition = area.lastIndexOf(openDelimiter);
        String searchingContent = delimiterPosition > -1 ? area.substring(delimiterPosition + openDelimiter.length()) : area;
        String[] keywords = searchingContent.split("[ =]");
        ArrayList<String> availableItems = new ArrayList<String>();
        for (String string : keywords) {
            if (SmartyCodeCompletionOffer.getFunctionParameters().get(string) != null) {
                if (availableItems.isEmpty()) {
                    availableItems.add(string);
                } else {
                    availableItems.set(0, string);
                }
            }
            if (availableItems.isEmpty()) continue;
            for (TplCompletionItem completionItem : SmartyCodeCompletionOffer.getFunctionParameters().get(availableItems.get(0))) {
                if (!completionItem.getItemText().equals(string)) continue;
                availableItems.add(string);
            }
        }
        return availableItems;
    }
}

