/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.CustomizerProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jdk.ConvertToDiamondBulkHintPanel;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ConvertToDiamondBulkHint {
    public static final String ID = "Javac_canUseDiamond";
    public static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.diamond.redundant.args", "compiler.warn.diamond.redundant.args.1"));
    private static final Map<String, Collection<String>> key2Pattern = new LinkedHashMap<String, Collection<String>>();
    private static final String KEY = "enabledVariants";
    static final String ALL = "initializer,assignment,return,argument,other";

    public static boolean isHintEnabled() {
        for (HintMetadata hm : RulesManager.getInstance().allHints.keySet()) {
            if (!ID.equals(hm.id)) continue;
            return HintsSettings.isEnabled(hm);
        }
        return true;
    }

    public static ErrorDescription compute(HintContext ctx) {
        if (ctx.getMultiVariables().get("$tparams$").isEmpty()) {
            return null;
        }
        TreePath clazz = ctx.getVariables().get("$clazz");
        long start = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(clazz.getCompilationUnit(), clazz.getLeaf());
        ctx.getVariables().put("$init", ctx.getPath());
        block0: for (Diagnostic d : ctx.getInfo().getDiagnostics()) {
            if (start != d.getStartPosition() || !CODES.contains(d.getCode())) continue;
            for (Map.Entry<String, Collection<String>> e : key2Pattern.entrySet()) {
                for (String p : e.getValue()) {
                    if (p != null && !MatcherUtilities.matches(ctx, ctx.getPath().getParentPath(), p)) continue;
                    boolean enabled = ConvertToDiamondBulkHint.isEnabled(ctx, e.getKey());
                    if (!enabled) continue block0;
                }
            }
            List<Fix> fixes = Arrays.asList(JavaFix.toEditorFix(new FixImpl(ctx.getInfo(), ctx.getPath())));
            return ErrorDescriptionFactory.createErrorDescription((Severity)ctx.getSeverity().toEditorSeverity(), (String)d.getMessage(null), fixes, (FileObject)ctx.getInfo().getFileObject(), (int)((int)d.getStartPosition()), (int)((int)d.getEndPosition()));
        }
        return null;
    }

    static String getConfiguration(Preferences p) {
        return p.get(KEY, ALL);
    }

    static void putConfiguration(Preferences p, String configuration) {
        p.put(KEY, configuration);
    }

    private static boolean isEnabled(HintContext ctx, String key) {
        return ConvertToDiamondBulkHint.isEnabled(ctx.getPreferences(), key);
    }

    static boolean isEnabled(Preferences p, String key) {
        return ("," + ConvertToDiamondBulkHint.getConfiguration(p) + ",").contains("," + key + ",");
    }

    static {
        key2Pattern.put("initializer", Arrays.asList("$mods$ $type $name = $init;"));
        key2Pattern.put("assignment", Arrays.asList("$var = $init"));
        key2Pattern.put("return", Arrays.asList("return $init;"));
        key2Pattern.put("argument", Arrays.asList("$site.<$T$>$name($p$, $init, $s$)", "$name($p$, $init, $s$)", "new $type<$T$>($p$, $init, $s$)", "new $type($p$, $init, $s$)"));
        key2Pattern.put("other", Arrays.asList(new String[]{null}));
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(ConvertToDiamondBulkHint.class, (String)"FIX_ConvertToDiamond");
        }

        @Override
        protected void performRewrite(WorkingCopy copy, TreePath tp, boolean canShowUI) {
            if (tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            NewClassTree nct = (NewClassTree)tp.getLeaf();
            if (nct.getIdentifier().getKind() != Tree.Kind.PARAMETERIZED_TYPE) {
                return;
            }
            TreeMaker make = copy.getTreeMaker();
            ParameterizedTypeTree ptt = (ParameterizedTypeTree)((Object)nct.getIdentifier());
            ParameterizedTypeTree nue = make.ParameterizedType(ptt.getType(), Collections.emptyList());
            copy.rewrite((Tree)ptt, (Tree)nue);
        }
    }

    public static final class CustomizerProviderImpl
    implements CustomizerProvider {
        @Override
        public JComponent getCustomizer(Preferences prefs) {
            return new ConvertToDiamondBulkHintPanel(prefs);
        }
    }
}

