/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.hints.jackpot.spi.CustomizerProvider;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.util.NbBundle;

public class HintMetadata {
    public final String id;
    public final String displayName;
    public final String description;
    public final String category;
    public final boolean enabled;
    public final Kind kind;
    public final AbstractHint.HintSeverity severity;
    public final Collection<? extends String> suppressWarnings;
    public final CustomizerProvider customizer;
    public final boolean showInTaskList = false;
    public final Set<Options> options;

    HintMetadata(String id, String displayName, String description, String category, boolean enabled, Kind kind, AbstractHint.HintSeverity severity, Collection<? extends String> suppressWarnings, CustomizerProvider customizer, Set<Options> options) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.category = category;
        this.enabled = enabled;
        this.kind = kind;
        this.severity = severity;
        this.suppressWarnings = suppressWarnings;
        this.customizer = customizer;
        this.options = options;
    }

    public String toString() {
        return this.displayName;
    }

    private static String lookup(ResourceBundle bundle, String key, String def) {
        try {
            return bundle != null ? bundle.getString(key) : def;
        }
        catch (MissingResourceException mre) {
            Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
            return def;
        }
    }

    public static final class Builder {
        private final String id;
        private String displayName;
        private String description;
        private String category;
        private boolean enabled;
        private Kind kind;
        private AbstractHint.HintSeverity severity;
        private final Collection<String> suppressWarnings = new ArrayList<String>();
        private CustomizerProvider customizer;
        private final Set<Options> options = EnumSet.noneOf(Options.class);

        private Builder(String id) {
            this.id = id;
            this.displayName = "";
            this.description = "";
            this.category = "";
            this.enabled = true;
            this.kind = Kind.HINT;
            this.severity = AbstractHint.HintSeverity.WARNING;
        }

        public static Builder create(String id) {
            return new Builder(id);
        }

        public Builder setDescription(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
            return this;
        }

        public Builder setBundle(ResourceBundle bundle) {
            return this.setBundle(bundle, null, null);
        }

        public Builder setBundle(ResourceBundle bundle, String fallbackDisplayName, String fallbackDescription) {
            if (fallbackDisplayName == null) {
                fallbackDisplayName = "No Display Name";
            }
            if (fallbackDescription == null) {
                fallbackDescription = "No Description";
            }
            this.displayName = HintMetadata.lookup(bundle, "DN_" + this.id.replace('$', '.'), fallbackDisplayName);
            this.description = HintMetadata.lookup(bundle, "DESC_" + this.id.replace('$', '.'), fallbackDescription);
            return this;
        }

        public Builder setBundle(String bundleForFQN) {
            ResourceBundle bundle;
            try {
                int lastDot = bundleForFQN.lastIndexOf(46);
                assert (lastDot >= 0);
                bundle = NbBundle.getBundle((String)(bundleForFQN.substring(0, lastDot + 1) + "Bundle"));
            }
            catch (MissingResourceException mre) {
                Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
                bundle = null;
            }
            return this.setBundle(bundle);
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setKind(Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder setSeverity(AbstractHint.HintSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder addSuppressWarnings(String ... keys) {
            this.suppressWarnings.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder setCustomizerProvider(CustomizerProvider customizer) {
            this.customizer = customizer;
            return this;
        }

        public Builder addOptions(Options ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public HintMetadata build() {
            return new HintMetadata(this.id, this.displayName, this.description, this.category, this.enabled, this.kind, this.severity, this.suppressWarnings, this.customizer, this.options);
        }
    }

    public static enum Options {
        NON_GUI,
        QUERY,
        NO_BATCH;

    }

    public static enum Kind {
        HINT,
        SUGGESTION;

    }
}

