/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.Trigger;
import org.netbeans.spi.editor.hints.ErrorDescription;

public final class HintDescription {
    private final HintMetadata metadata;
    private final Trigger trigger;
    private final Worker worker;
    private final AdditionalQueryConstraints additionalConstraints;
    private final String hintText;

    private HintDescription(HintMetadata metadata, Trigger trigger, Worker worker, AdditionalQueryConstraints additionalConstraints, String hintText) {
        this.metadata = metadata;
        this.trigger = trigger;
        this.worker = worker;
        this.additionalConstraints = additionalConstraints;
        this.hintText = hintText;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public HintMetadata getMetadata() {
        return this.metadata;
    }

    public Iterable<? extends String> getSuppressWarnings() {
        return this.metadata.suppressWarnings;
    }

    public AdditionalQueryConstraints getAdditionalConstraints() {
        return this.additionalConstraints;
    }

    @CheckForNull
    public String getHintText() {
        return this.hintText;
    }

    static HintDescription create(HintMetadata metadata, Trigger trigger, Worker worker, AdditionalQueryConstraints additionalConstraints, String hintText) {
        return new HintDescription(metadata, trigger, worker, additionalConstraints, hintText);
    }

    public String toString() {
        return "[HintDescription:" + this.getTrigger() + "]";
    }

    public static final class AdditionalQueryConstraints {
        public final Set<String> requiredErasedTypes;
        private static final AdditionalQueryConstraints EMPTY = new AdditionalQueryConstraints(Collections.<String>emptySet());

        public AdditionalQueryConstraints(Set<String> requiredErasedTypes) {
            this.requiredErasedTypes = Collections.unmodifiableSet(new HashSet<String>(requiredErasedTypes));
        }

        public static AdditionalQueryConstraints empty() {
            return EMPTY;
        }
    }

    public static interface Worker {
        public Collection<? extends ErrorDescription> createErrors(HintContext var1);
    }
}

