/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.refactoring;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class Utilities {
    public static List<PositionBounds> prepareSpansFor(FileObject file, Iterable<? extends int[]> spans) {
        AbstractList result = new ArrayList<PositionBounds>();
        try {
            DataObject d = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
            CloneableEditorSupport ces = (CloneableEditorSupport)ec;
            result = new LinkedList();
            for (int[] nArray : spans) {
                PositionRef start = ces.createPositionRef(nArray[0], Position.Bias.Forward);
                PositionRef end = ces.createPositionRef(nArray[1], Position.Bias.Forward);
                result.add((PositionBounds)new PositionBounds(start, end));
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public static Collection<RefactoringElementImplementation> createRefactoringElementImplementation(FileObject file, List<PositionBounds> spans, boolean verified) {
        LinkedList<RefactoringElementImplementation> result = new LinkedList<RefactoringElementImplementation>();
        try {
            DataObject d = DataObject.find((FileObject)file);
            LineCookie lc = (LineCookie)d.getLookup().lookup(LineCookie.class);
            for (PositionBounds bound : spans) {
                PositionRef start = bound.getBegin();
                PositionRef end = bound.getEnd();
                Line l = lc.getLineSet().getCurrent(start.getLine());
                String lineText = l.getText();
                int boldStart = start.getColumn();
                int boldEnd = end.getLine() == start.getLine() ? end.getColumn() : lineText.length();
                StringBuilder displayName = new StringBuilder();
                if (!verified) {
                    displayName.append("(not verified) ");
                }
                displayName.append(Utilities.escapedSubstring(lineText, 0, boldStart).replaceAll("^[ ]*", ""));
                displayName.append("<b>");
                displayName.append(Utilities.escapedSubstring(lineText, boldStart, boldEnd));
                displayName.append("</b>");
                displayName.append(Utilities.escapedSubstring(lineText, boldEnd, lineText.length()));
                result.add((RefactoringElementImplementation)new RefactoringElementImpl(file, bound, displayName.toString()));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private static String escapedSubstring(String str, int start, int end) {
        String substring = str.substring(start, end);
        try {
            return XMLUtil.toElementContent((String)substring);
        }
        catch (CharConversionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return substring;
        }
    }

    public static ArrayList<HintMetadata> getBatchSupportedHints() {
        HashSet<HintMetadata> hintSet = new HashSet<HintMetadata>();
        for (Map.Entry<HintMetadata, Collection<? extends HintDescription>> entry : RulesManager.getInstance().allHints.entrySet()) {
            if (entry.getKey().options.contains((Object)HintMetadata.Options.NO_BATCH)) continue;
            hintSet.add(entry.getKey());
        }
        ArrayList<HintMetadata> hints = new ArrayList<HintMetadata>(hintSet);
        Collections.sort(hints, new Comparator<HintMetadata>(){

            @Override
            public int compare(HintMetadata t, HintMetadata t1) {
                return t.displayName.compareTo(t1.displayName);
            }
        });
        return hints;
    }

    private static final class RefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final FileObject file;
        private final PositionBounds span;
        private final String displayName;
        private final Lookup lookup;

        public RefactoringElementImpl(FileObject file, PositionBounds span, String displayName) {
            this.file = file;
            this.span = span;
            this.lookup = Lookups.fixed((Object[])new Object[]{file});
            this.displayName = displayName;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.displayName;
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.span;
        }
    }
}

