/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.refactoring;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.impl.batch.BatchSearch;
import org.netbeans.modules.java.hints.jackpot.impl.batch.Scopes;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.Configuration;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.ConfigurationRenderer;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.ConfigurationsComboModel;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.InspectAndRefactorUI;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.InspectionComboModel;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.InspectionRenderer;
import org.netbeans.modules.java.hints.jackpot.impl.refactoring.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsPanel;
import org.netbeans.modules.java.hints.options.HintsPanelLogic;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.api.ui.JavaScopeBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Union2;

public class InspectAndRefactorPanel
extends JPanel
implements PopupMenuListener {
    private static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private FileObject fileObject;
    private final InspectAndRefactorUI.HintWrap hintWrap;
    Scope customScope;
    private JLabel customScopeLab = null;
    private JLabel currentFile = null;
    private JLabel currentPackage = null;
    private JLabel currentProject = null;
    private JLabel allProjects = null;
    private Project project;
    private ButtonGroup buttonGroup;
    private JComboBox configurationCombo;
    private JRadioButton configurationRadio;
    private JButton customScopeButton;
    private JLabel inspectLabel;
    private JButton manageConfigurations;
    private JButton manageSingleRefactoring;
    private JLabel refactorUsingLabel;
    private JComboBox scopeCombo;
    private JRadioButton singleRefactorRadio;
    private JComboBox singleRefactoringCombo;
    private boolean prefsLoading = false;
    private Popup popup = null;
    private PropertyChangeListener listener;

    public InspectAndRefactorPanel(Lookup context, ChangeListener parent, boolean query) {
        FileObject file;
        this.initComponents();
        this.hintWrap = (InspectAndRefactorUI.HintWrap)context.lookup(InspectAndRefactorUI.HintWrap.class);
        this.configurationCombo.setModel(new ConfigurationsComboModel(false));
        this.singleRefactoringCombo.setModel(new InspectionComboModel(this.hintWrap != null ? Collections.singletonList(this.hintWrap.hm) : Utilities.getBatchSupportedHints()));
        this.singleRefactoringCombo.addActionListener(new ActionListener(){
            Object currentItem;
            {
                this.currentItem = InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tempItem = InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
                if (!(tempItem instanceof HintMetadata)) {
                    InspectAndRefactorPanel.this.singleRefactoringCombo.setSelectedItem(this.currentItem);
                } else {
                    this.currentItem = tempItem;
                }
            }
        });
        this.configurationCombo.setRenderer(new ConfigurationRenderer());
        this.singleRefactoringCombo.setRenderer(new InspectionRenderer());
        this.singleRefactoringCombo.addPopupMenuListener(this);
        DataObject dob = (DataObject)context.lookup(DataObject.class);
        Icon prj = null;
        ProjectInformation pi = null;
        if (dob != null && (file = (FileObject)context.lookup(FileObject.class)) != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)file);
            if (this.project != null) {
                this.fileObject = file;
                pi = ProjectUtils.getInformation((Project)this.project);
                prj = pi.getIcon();
            }
        }
        this.customScopeLab = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CustomScope"), prj, 2);
        if (this.fileObject != null) {
            if (!this.fileObject.isFolder()) {
                this.currentFile = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentFile", (Object)this.fileObject.getNameExt()), new ImageIcon(dob.getNodeDelegate().getIcon(2)), 2);
            }
            this.currentPackage = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentPackage", (Object)this.getPackageName(this.fileObject)), ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false), 2);
            this.currentProject = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
        } else {
            this.project = (Project)context.lookup(Project.class);
            if (this.project == null && dob != null) {
                this.project = FileOwnerQuery.getOwner((FileObject)dob.getPrimaryFile());
            }
            if (this.project != null) {
                pi = ProjectUtils.getInformation((Project)this.project);
                prj = pi.getIcon();
                this.currentProject = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
            }
        }
        this.allProjects = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_AllProjects"), prj, 2);
        this.scopeCombo.setModel(new DefaultComboBoxModel<Object>(InspectAndRefactorPanel.createArray(this.allProjects, this.currentProject, this.currentPackage, this.currentFile, this.customScopeLab)));
        this.scopeCombo.setRenderer(new JLabelRenderer());
        this.loadPrefs();
        if (this.scopeCombo.getItemCount() > 2) {
            this.scopeCombo.setSelectedIndex(this.scopeCombo.getItemCount() - 2);
        }
        if (this.hintWrap != null) {
            this.singleRefactoringCombo.setSelectedItem(this.hintWrap.hm);
            this.setConfig(false);
            this.singleRefactorRadio.setSelected(true);
            this.singleRefactorRadio.setEnabled(false);
            this.singleRefactoringCombo.setEnabled(false);
            this.manageSingleRefactoring.setEnabled(false);
            this.configurationRadio.setEnabled(false);
        }
    }

    private static Object[] createArray(Object ... items) {
        ArrayList<Object> a = new ArrayList<Object>();
        for (Object o : items) {
            if (o == null) continue;
            a.add(o);
        }
        return a.toArray(new Object[a.size()]);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.inspectLabel = new JLabel();
        this.scopeCombo = new JComboBox();
        this.refactorUsingLabel = new JLabel();
        this.configurationRadio = new JRadioButton();
        this.singleRefactorRadio = new JRadioButton();
        this.configurationCombo = new JComboBox();
        this.singleRefactoringCombo = new JComboBox();
        this.manageConfigurations = new JButton();
        this.manageSingleRefactoring = new JButton();
        this.customScopeButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.inspectLabel, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.inspectLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.refactorUsingLabel, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.refactorUsingLabel.text"));
        this.buttonGroup.add(this.configurationRadio);
        this.configurationRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.configurationRadio, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.configurationRadio.text"));
        this.configurationRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.configurationRadioActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.singleRefactorRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.singleRefactorRadio, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.singleRefactorRadio.text"));
        this.singleRefactorRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.singleRefactorRadioActionPerformed(evt);
            }
        });
        this.configurationCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.configurationComboItemStateChanged(evt);
            }
        });
        this.singleRefactoringCombo.setEnabled(false);
        this.singleRefactoringCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.singleRefactoringComboItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageConfigurations, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.manageConfigurations.text"));
        this.manageConfigurations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.manageConfigurationsItemStateChanged(evt);
            }
        });
        this.manageConfigurations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.manageConfigurationsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageSingleRefactoring, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.manageSingleRefactoring.text"));
        this.manageSingleRefactoring.setEnabled(false);
        this.manageSingleRefactoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.manageSingleRefactoringActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.customScopeButton, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.customScopeButton.text"));
        this.customScopeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.customScopeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refactorUsingLabel).addComponent(this.inspectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationRadio).addComponent(this.singleRefactorRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleRefactoringCombo, 0, 45, Short.MAX_VALUE).addComponent(this.configurationCombo, 0, 45, Short.MAX_VALUE))).addComponent(this.scopeCombo, GroupLayout.Alignment.TRAILING, 0, 191, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.manageSingleRefactoring, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.manageConfigurations, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addComponent(this.customScopeButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inspectLabel).addComponent(this.scopeCombo, -2, -1, -2).addComponent(this.customScopeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationRadio).addComponent(this.configurationCombo, -2, -1, -2).addComponent(this.manageConfigurations).addComponent(this.refactorUsingLabel)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleRefactoringCombo, -2, -1, -2).addComponent(this.manageSingleRefactoring).addComponent(this.singleRefactorRadio))));
    }

    private void configurationRadioActionPerformed(ActionEvent evt) {
        this.setConfig(true);
    }

    private void setConfig(boolean yes) {
        this.singleRefactoringCombo.setEnabled(!yes);
        this.manageSingleRefactoring.setEnabled(!yes);
        this.configurationCombo.setEnabled(yes);
        this.manageConfigurations.setEnabled(yes);
        this.storePrefs();
    }

    private void singleRefactorRadioActionPerformed(ActionEvent evt) {
        this.setConfig(false);
    }

    private void manageConfigurationsActionPerformed(ActionEvent evt) {
        this.manageRefactorings(false);
    }

    private void manageSingleRefactoringActionPerformed(ActionEvent evt) {
        this.manageRefactorings(true);
    }

    private void manageConfigurationsItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void singleRefactoringComboItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void configurationComboItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void customScopeButtonActionPerformed(ActionEvent evt) {
        Object selectedItem = this.scopeCombo.getSelectedItem();
        if (selectedItem == this.allProjects) {
            HashSet<FileObject> todo = new HashSet<FileObject>();
            for (ClassPath source : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                todo.addAll(Arrays.asList(source.getRoots()));
            }
            this.customScope = Scope.create(todo, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST);
        } else if (selectedItem == this.currentProject) {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (SourceGroup gr : ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
                roots.add(gr.getRootFolder());
            }
            this.customScope = Scope.create(roots, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST);
        } else if (selectedItem == this.currentPackage) {
            if (this.fileObject != null) {
                Set<10> col = Collections.singleton(new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return InspectAndRefactorPanel.this.fileObject.getParent();
                    }
                });
                this.customScope = Scope.create((Collection)Collections.EMPTY_LIST, col, (Collection)Collections.EMPTY_LIST);
            }
        } else {
            this.customScope = selectedItem == this.currentFile ? Scope.create((Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST, Collections.singleton(this.fileObject)) : Scope.create((Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST);
        }
        Scope s = JavaScopeBuilder.open((String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"CTL_CustomScope"), (Scope)this.customScope);
        if (s != null) {
            this.customScope = s;
            this.scopeCombo.setSelectedIndex(this.scopeCombo.getItemCount() - 1);
        }
    }

    public Union2<String, Iterable<? extends HintDescription>> getPattern() {
        if (this.singleRefactorRadio.isSelected()) {
            if (this.hintWrap != null) {
                return Union2.createSecond(this.hintWrap.hints);
            }
            HintMetadata hint = (HintMetadata)this.singleRefactoringCombo.getSelectedItem();
            Collection<? extends HintDescription> hintDesc = RulesManager.getInstance().allHints.get(hint);
            return Union2.createSecond(hintDesc);
        }
        Configuration config = (Configuration)this.configurationCombo.getSelectedItem();
        LinkedList<? extends HintDescription> hintsToApply = new LinkedList<HintDescription>();
        for (HintMetadata hint : config.getHints()) {
            hintsToApply.addAll(RulesManager.getInstance().allHints.get(hint));
        }
        return Union2.createSecond(hintsToApply);
    }

    public BatchSearch.Scope getScope() {
        switch (this.scopeCombo.getSelectedIndex()) {
            case 0: {
                return Scopes.allOpenedProjectsScope();
            }
            case 1: {
                if (this.fileObject != null) {
                    return this.getThisProjectScope();
                }
                return this.getCustomScope();
            }
            case 2: {
                return this.getThisPackageScope();
            }
            case 3: {
                return this.getThisFileScope();
            }
            case 4: {
                return this.getCustomScope();
            }
        }
        return Scopes.allOpenedProjectsScope();
    }

    private BatchSearch.Scope getCustomScope() {
        if (this.customScope == null) {
            return Scopes.specifiedFoldersScope(new BatchSearch.Folder[0]);
        }
        LinkedList list = new LinkedList();
        list.addAll(this.customScope.getFiles());
        list.addAll(this.customScope.getFolders());
        list.addAll(this.customScope.getSourceRoots());
        return Scopes.specifiedFoldersScope(BatchSearch.Folder.convert(list));
    }

    private BatchSearch.Scope getThisProjectScope() {
        return Scopes.specifiedFoldersScope(BatchSearch.Folder.convert(ClassPath.getClassPath((FileObject)this.fileObject, (String)"classpath/source").getRoots()));
    }

    private BatchSearch.Scope getThisPackageScope() {
        return Scopes.specifiedFoldersScope(BatchSearch.Folder.convert(Collections.singleton(this.fileObject.getParent())));
    }

    private BatchSearch.Scope getThisFileScope() {
        return Scopes.specifiedFoldersScope(BatchSearch.Folder.convert(Collections.singleton(this.fileObject)));
    }

    private void manageRefactorings(boolean single) {
        HintMetadata selectedHint;
        HintsPanel panel = single ? new HintsPanel((HintMetadata)this.singleRefactoringCombo.getSelectedItem()) : new HintsPanel((Configuration)this.configurationCombo.getSelectedItem());
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"CTL_ManageRefactorings"), true, new Object[0], null, 0, null, null);
        JDialog dialog = (JDialog)DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.validate();
        dialog.pack();
        dialog.setVisible(true);
        Configuration selectedConfiguration = panel.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            this.configurationCombo.setSelectedItem(selectedConfiguration);
        }
        if ((selectedHint = panel.getSelectedHint()) != null) {
            this.singleRefactoringCombo.setSelectedItem(selectedHint);
        }
    }

    private void storePrefs() {
        if (this.prefsLoading) {
            return;
        }
        Preferences prefs = NbPreferences.forModule(InspectAndRefactorPanel.class);
        if (this.hintWrap == null) {
            prefs.putBoolean("InspectAndRefactorPanel.singleRefactorRadio", this.singleRefactorRadio.isSelected());
            prefs.putInt("InspectAndRefactorPanel.configurationCombo", this.configurationCombo.getSelectedIndex());
            prefs.putInt("InspectAndRefactorPanel.singleRefactoringCombo", this.singleRefactoringCombo.getSelectedIndex());
        }
        prefs.putInt("InspectAndRefactorPanel.scopeCombo", this.scopeCombo.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrefs() {
        this.prefsLoading = true;
        try {
            Preferences prefs = NbPreferences.forModule(InspectAndRefactorPanel.class);
            boolean sel = prefs.getBoolean("InspectAndRefactorPanel.singleRefactorRadio", true);
            this.setConfig(!sel);
            this.singleRefactorRadio.setSelected(sel);
            try {
                this.configurationCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.configurationCombo", 0));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            try {
                this.singleRefactoringCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.singleRefactoringCombo", 0));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            try {
                this.scopeCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.scopeCombo", 0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.prefsLoading = false;
        }
    }

    private String getPackageName(FileObject file) {
        return ClassPath.getClassPath((FileObject)file, (String)"classpath/source").getResourceName(file.isFolder() ? file : file.getParent(), '.', false);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        final Accessible comp = this.singleRefactoringCombo.getUI().getAccessibleChild(this.singleRefactoringCombo, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            private static final String HTML_DESC_FOOTER = "</body></html>";
            private final String HTML_DESC_HEADER = "<html><body><b>" + NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border") + "</b><br>";

            @Override
            public void run() {
                JPopupMenu menu = (JPopupMenu)comp;
                HintMetadata item = (HintMetadata)InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
                final JEditorPane pane = new JEditorPane();
                pane.setContentType("text/html");
                pane.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(pane);
                pane.setText(this.HTML_DESC_HEADER + item.description + HintsPanelLogic.getQueryWarning(item) + HTML_DESC_FOOTER);
                scrollPane.setPreferredSize(menu.getSize());
                Dimension size = menu.getSize();
                Point location = menu.getLocationOnScreen();
                InspectAndRefactorPanel.this.singleRefactoringCombo.getAccessibleContext().addPropertyChangeListener(InspectAndRefactorPanel.this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("AccessibleActiveDescendant")) {
                            AccessibleContext context = (AccessibleContext)evt.getNewValue();
                            Object elementAt = InspectAndRefactorPanel.this.singleRefactoringCombo.getModel().getElementAt(context.getAccessibleIndexInParent());
                            if (elementAt instanceof HintMetadata) {
                                HintMetadata item = (HintMetadata)elementAt;
                                pane.setText(HTML_DESC_HEADER + item.description + HintsPanelLogic.getQueryWarning(item) + 11.HTML_DESC_FOOTER);
                                pane.setCaretPosition(0);
                            }
                        }
                    }
                });
                InspectAndRefactorPanel.this.popup = PopupFactory.getSharedInstance().getPopup(menu, scrollPane, (int)location.getX(), (int)(location.getY() - size.getHeight() - (double)InspectAndRefactorPanel.this.singleRefactoringCombo.getHeight()) + 5);
                InspectAndRefactorPanel.this.popup.show();
            }
        });
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        this.singleRefactoringCombo.getAccessibleContext().removePropertyChangeListener(this.listener);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(((JLabel)value).getText());
                this.setIcon(((JLabel)value).getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

