/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.batch;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.editor.semantic.SemanticHighlighter;
import org.netbeans.modules.java.hints.jackpot.impl.JavaFixImpl;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.SyntheticFix;
import org.netbeans.modules.java.hints.jackpot.impl.batch.BatchSearch;
import org.netbeans.modules.java.hints.jackpot.impl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.ProjectDependencyUpgrader;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class BatchUtilities {
    private static final Logger LOG = Logger.getLogger(BatchUtilities.class.getName());

    public static Collection<ModificationResult> applyFixes(BatchSearch.BatchResult candidates, @NonNull ProgressHandleWrapper progress, AtomicBoolean cancel, final Collection<? super MessageImpl> problems) {
        final IdentityHashMap processedDependencyChanges = new IdentityHashMap();
        final LinkedHashMap result = new LinkedHashMap();
        BatchSearch.VerifiedSpansCallBack callback = new BatchSearch.VerifiedSpansCallBack(){
            private ElementOverlay overlay;

            @Override
            public void groupStarted() {
                this.overlay = new ElementOverlay();
            }

            @Override
            public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                Constructor wcConstr = WorkingCopy.class.getDeclaredConstructor(CompilationInfoImpl.class, ElementOverlay.class);
                wcConstr.setAccessible(true);
                WorkingCopy copy = (WorkingCopy)wcConstr.newInstance(JavaSourceAccessor.getINSTANCE().getCompilationInfoImpl((CompilationInfo)wc), this.overlay);
                Method setJavaSource = CompilationInfo.class.getDeclaredMethod("setJavaSource", JavaSource.class);
                setJavaSource.setAccessible(true);
                setJavaSource.invoke((Object)copy, wc.getJavaSource());
                copy.toPhase(JavaSource.Phase.RESOLVED);
                if (BatchUtilities.applyFixes(copy, processedDependencyChanges, hints, (Collection<? super MessageImpl>)problems)) {
                    return false;
                }
                JavacTaskImpl jt = JavaSourceAccessor.getINSTANCE().getJavacTask((CompilationInfo)copy);
                Log.instance((Context)jt.getContext()).nerrors = 0;
                Method getChanges = WorkingCopy.class.getDeclaredMethod("getChanges", Map.class);
                getChanges.setAccessible(true);
                result.put(copy.getFileObject(), (List)getChanges.invoke((Object)copy, new HashMap()));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "fixes applied to: {0}", FileUtil.getFileDisplayName((FileObject)wc.getFileObject()));
                }
                return true;
            }

            @Override
            public void groupFinished() {
                this.overlay = null;
            }

            @Override
            public void cannotVerifySpan(BatchSearch.Resource r) {
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "Cannot parse: " + r.getRelativePath()));
            }
        };
        BatchSearch.getVerifiedSpans(candidates, progress, callback, problems);
        return Collections.singletonList(JavaSourceAccessor.getINSTANCE().createModificationResult(result, Collections.emptyMap()));
    }

    private static String positionToString(ErrorDescription ed) {
        try {
            return ed.getFile().getNameExt() + ":" + ed.getRange().getBegin().getLine();
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
            return ed.getFile().getNameExt();
        }
    }

    public static void removeUnusedImports(Collection<? extends FileObject> files) throws IOException {
        Map<ClasspathInfo, Collection<FileObject>> sortedFastFiles = BatchUtilities.sortFiles(files);
        for (Map.Entry<ClasspathInfo, Collection<FileObject>> e : sortedFastFiles.entrySet()) {
            JavaSource.create((ClasspathInfo)e.getKey(), e.getValue()).runModificationTask((Task)new RemoveUnusedImports()).commit();
        }
    }

    public static boolean applyFixes(WorkingCopy copy, Map<Project, Set<String>> processedDependencyChanges, Collection<? extends ErrorDescription> hints, Collection<? super MessageImpl> problems) throws IllegalStateException, Exception {
        ArrayList<JavaFix> fixes = new ArrayList<JavaFix>();
        for (ErrorDescription errorDescription : hints) {
            if (!errorDescription.getFixes().isComputed()) {
                throw new IllegalStateException();
            }
            Fix toApply = null;
            for (Fix f : errorDescription.getFixes().getFixes()) {
                if (f instanceof SyntheticFix) continue;
                if (toApply == null) {
                    toApply = f;
                    continue;
                }
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "More than one fix for: " + errorDescription.getDescription() + " at " + BatchUtilities.positionToString(errorDescription) + ", only the first one will be used."));
            }
            if (toApply == null) {
                boolean doWarning = false;
                if (!$assertionsDisabled) {
                    doWarning = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!doWarning) continue;
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "No fix for: " + errorDescription.getDescription() + " at " + BatchUtilities.positionToString(errorDescription) + "."));
                continue;
            }
            if (!(toApply instanceof JavaFixImpl)) {
                throw new IllegalStateException();
            }
            fixes.add(((JavaFixImpl)toApply).jf);
        }
        if (BatchUtilities.fixDependencies(copy.getFileObject(), fixes, processedDependencyChanges)) {
            return true;
        }
        for (JavaFix javaFix : fixes) {
            JavaFixImpl.Accessor.INSTANCE.process(javaFix, copy, false);
        }
        return false;
    }

    public static Collection<FileObject> getSourceGroups(Iterable<? extends Project> prjs) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (Project project : prjs) {
            Sources s = ProjectUtils.getSources((Project)project);
            for (SourceGroup sg : s.getSourceGroups("java")) {
                result.add(sg.getRootFolder());
            }
        }
        return result;
    }

    public static Map<ClasspathInfo, Collection<FileObject>> sortFiles(Collection<? extends FileObject> from) {
        HashMap m = new HashMap();
        for (FileObject fileObject : from) {
            ArrayList<Object> cps = new ArrayList<Object>(4);
            cps.add(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"));
            cps.add(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile"));
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            cps.add(sourceCP);
            cps.add(sourceCP != null ? sourceCP.findOwnerRoot(fileObject) : null);
            LinkedList<FileObject> files = (LinkedList<FileObject>)m.get(cps);
            if (files == null) {
                files = new LinkedList<FileObject>();
                m.put(cps, files);
            }
            files.add(fileObject);
        }
        IdentityHashMap<ClasspathInfo, Collection<FileObject>> result = new IdentityHashMap<ClasspathInfo, Collection<FileObject>>();
        for (Map.Entry e : m.entrySet()) {
            result.put(ClasspathInfo.create((ClassPath)((ClassPath)((List)e.getKey()).get(0)), (ClassPath)((ClassPath)((List)e.getKey()).get(1)), (ClassPath)((ClassPath)((List)e.getKey()).get(2))), (Collection<FileObject>)e.getValue());
        }
        return result;
    }

    public static boolean fixDependencies(FileObject file, List<JavaFix> toProcess, Map<Project, Set<String>> alreadyProcessed) {
        boolean modified = false;
        block0: for (JavaFix fix : toProcess) {
            Project p;
            String updateTo = JavaFixImpl.Accessor.INSTANCE.getOptions(fix).get("ensure-dependency");
            if (updateTo == null || (p = FileOwnerQuery.getOwner((FileObject)file)) == null) continue;
            Set<String> seen = alreadyProcessed.get(p);
            if (seen == null) {
                seen = new HashSet<String>();
                alreadyProcessed.put(p, seen);
            }
            if (!seen.add(updateTo)) continue;
            for (ProjectDependencyUpgrader up : Lookup.getDefault().lookupAll(ProjectDependencyUpgrader.class)) {
                if (!up.ensureDependency(p, updateTo, false)) continue;
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    public static void recursive(FileObject root, FileObject file, Collection<FileObject> collected, ProgressHandleWrapper progress, int depth, Properties timeStamps, Set<String> removedFiles, boolean recursive) {
        if (!VisibilityQuery.getDefault().isVisible(file)) {
            return;
        }
        if (file.isData()) {
            if (timeStamps != null) {
                String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)file);
                String lastModified = Long.toHexString(file.lastModified().getTime());
                removedFiles.remove(relativePath);
                if (lastModified.equals(timeStamps.getProperty(relativePath))) {
                    return;
                }
                timeStamps.setProperty(relativePath, lastModified);
            }
            if ("java".equals(file.getExt()) || "text/x-java".equals(FileUtil.getMIMEType((FileObject)file, (String[])new String[]{"text/x-java"}))) {
                collected.add(file);
            }
        } else {
            ProgressHandleWrapper inner;
            FileObject[] children = file.getChildren();
            if (children.length == 0) {
                return;
            }
            ProgressHandleWrapper progressHandleWrapper = inner = depth < 2 ? progress.startNextPartWithEmbedding(ProgressHandleWrapper.prepareParts(children.length)) : null;
            if (inner == null && progress != null) {
                progress.startNextPart(children.length);
            } else {
                progress = null;
            }
            for (FileObject c : children) {
                if (recursive || c.isData()) {
                    BatchUtilities.recursive(root, c, collected, inner, depth + 1, timeStamps, removedFiles, recursive);
                }
                if (progress == null) continue;
                progress.tick();
            }
        }
    }

    private static final class RemoveUnusedImports
    implements Task<WorkingCopy> {
        private RemoveUnusedImports() {
        }

        public void run(WorkingCopy wc) throws IOException {
            Document doc = wc.getSnapshot().getSource().getDocument(true);
            if (wc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            List unusedImports = SemanticHighlighter.computeUnusedImports((CompilationInfo)wc);
            CompilationUnitTree cut = wc.getCompilationUnit();
            for (TreePathHandle handle : unusedImports) {
                TreePath path = handle.resolve((CompilationInfo)wc);
                assert (path != null);
                cut = wc.getTreeMaker().removeCompUnitImport(cut, (ImportTree)path.getLeaf());
            }
            if (!unusedImports.isEmpty()) {
                wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)cut);
            }
        }
    }
}

