/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.ChangeParametersFix;
import org.netbeans.modules.java.hints.errors.CreateElement;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChangeMethodParameters
implements ErrorRule<Void> {
    private String DEFAULT_NAME = "par";
    private boolean cancel = false;

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.apply.symbol.1", "compiler.err.cant.apply.symbols"));
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            this.cancel = false;
            return this.analyze(info, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    public String getId() {
        return ChangeMethodParameters.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_ChangeMethodParameters");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_ChangeMethodParameters");
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    private List<Fix> analyze(CompilationInfo info, int offset) throws IOException {
        MethodInvocationTree invocation;
        TreePath errorPath = ErrorHintsProvider.findUnresolvedElement(info, offset);
        if (errorPath == null) {
            return Collections.emptyList();
        }
        Tree error = errorPath.getParentPath().getLeaf();
        if (error == null) {
            return Collections.emptyList();
        }
        if (info.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        if (error.getKind() == Tree.Kind.METHOD_INVOCATION && (invocation = (MethodInvocationTree)error).getMethodSelect().getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
            IdentifierTree methodSelect = (IdentifierTree)invocation.getMethodSelect();
            TreePath typePath = this.findEnclosingType(errorPath.getParentPath());
            LinkedList<TreePath> methods = new LinkedList<TreePath>();
            for (Tree tree : ((ClassTree)typePath.getLeaf()).getMembers()) {
                MethodTree method;
                if (this.cancel) {
                    return Collections.emptyList();
                }
                if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || !(method = (MethodTree)tree).getName().contentEquals(methodSelect.getName())) continue;
                methods.add(new TreePath(typePath, method));
            }
            LinkedList<Fix> fixes = new LinkedList<Fix>();
            for (TreePath path : methods) {
                boolean bl;
                if (this.cancel) {
                    return Collections.emptyList();
                }
                ExecutableElement method = (ExecutableElement)info.getTrees().getElement(path);
                List<? extends VariableElement> parameters = method.getParameters();
                ChangeParametersRefactoring.ParameterInfo[] parameterInfo = new ChangeParametersRefactoring.ParameterInfo[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement param = parameters.get(i);
                    parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(i, param.toString(), ((Object)param.asType()).toString(), null);
                }
                ChangeParametersRefactoring.ParameterInfo[] newParameterInfo = new ChangeParametersRefactoring.ParameterInfo[invocation.getArguments().size()];
                MethodTree methodTree = (MethodTree)path.getLeaf();
                BlockTree methodBody = methodTree.getBody();
                Scope scope = null;
                if (methodBody != null) {
                    TreePath bodyPath = new TreePath(path, methodBody);
                    scope = info.getTrees().getScope(bodyPath);
                }
                int i = 0;
                for (ExpressionTree expressionTree : invocation.getArguments()) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    TreePath argumentPath = new TreePath(path, expressionTree);
                    TypeMirror argumentType = info.getTrees().getTypeMirror(argumentPath);
                    String type = ((Object)argumentType).toString();
                    String name = Utilities.getName(argumentPath.getLeaf());
                    if (name == null) {
                        name = this.DEFAULT_NAME;
                    }
                    name = ChangeMethodParameters.makeNameUnique(info, scope, name, newParameterInfo, i);
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, name, type, expressionTree.toString());
                    ++i;
                }
                for (i = 0; i < newParameterInfo.length; ++i) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    ChangeParametersRefactoring.ParameterInfo param = newParameterInfo[i];
                    ChangeParametersRefactoring.ParameterInfo parameterInfo2 = this.findNextByType(info, parameterInfo, param.getType());
                    if (parameterInfo2 == null) continue;
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(parameterInfo2.getOriginalIndex(), parameterInfo2.getName(), parameterInfo2.getType(), param.getDefaultValue());
                }
                TreePathHandle tph = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                boolean bl2 = true;
                if (methodTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                    bl = false;
                }
                Set<Modifier> modifiers = method.getModifiers();
                fixes.add(new ChangeParametersFix(bl, tph, modifiers, this.genDeclarationString(methodTree, parameterInfo), this.genDeclarationString(methodTree, newParameterInfo), newParameterInfo));
            }
            return fixes;
        }
        return Collections.emptyList();
    }

    private static String makeNameUnique(CompilationInfo info, Scope s, String name, ChangeParametersRefactoring.ParameterInfo[] parameters, int current) {
        int counter = 0;
        boolean cont = true;
        String proposedName = name;
        block0: while (cont) {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "");
            cont = false;
            if (s != null) {
                for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new Utilities.VariablesFilter())) {
                    if (!proposedName.equals(e.getSimpleName().toString())) continue;
                    ++counter;
                    cont = true;
                    break;
                }
            }
            for (int i = 0; i < parameters.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parameterInfo = parameters[i];
                if (current == i || parameterInfo == null || !proposedName.equals(parameterInfo.getName())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        }
        return proposedName;
    }

    public String genDeclarationString(MethodTree methodTree, ChangeParametersRefactoring.ParameterInfo[] parameters) {
        StringBuilder buf = new StringBuilder();
        buf.append(methodTree.getName());
        buf.append('(');
        if (parameters.length > 0) {
            int i;
            for (i = 0; i < parameters.length - 1; ++i) {
                buf.append(parameters[i].getType());
                buf.append(' ');
                buf.append(parameters[i].getName());
                buf.append(',').append(' ');
            }
            buf.append(parameters[i].getType());
            buf.append(' ');
            buf.append(parameters[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }

    private TreePath findEnclosingType(TreePath parentPath) {
        for (TreePath klazz = parentPath; klazz != null; klazz = klazz.getParentPath()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)klazz.getLeaf().getKind())) continue;
            return klazz;
        }
        return null;
    }

    private ChangeParametersRefactoring.ParameterInfo findNextByType(CompilationInfo info, ChangeParametersRefactoring.ParameterInfo[] parameterInfo, String type) {
        for (int i = 0; i < parameterInfo.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo param = parameterInfo[i];
            if (param.getOriginalIndex() <= -1 || !this.isSameType(info, type, param.getType())) continue;
            parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, param.getName(), param.getType(), null);
            return param;
        }
        return null;
    }

    private boolean isSameType(CompilationInfo info, String from, String to) {
        if (from.equals(to)) {
            return true;
        }
        TypeElement fromType = info.getElements().getTypeElement(from);
        TypeElement toType = info.getElements().getTypeElement(to);
        if (fromType != null && toType != null) {
            return info.getTypes().isSubtype(fromType.asType(), toType.asType());
        }
        return false;
    }
}

