/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class UnusedAssignmentOrBranch
implements CancellableTask<CompilationInfo> {
    private static final String UNUSED_ASSIGNMENT_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.unusedAssignment";
    private static final String DEAD_BRANCH_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.deadBranch";
    private final AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    static final String ENABLED_KEY = "enabled";

    public void run(CompilationInfo info) throws Exception {
        this.cancel.set(false);
        Document doc = info.getDocument();
        if (doc == null) {
            return;
        }
        OffsetsBag unusedValue = UnusedAssignmentOrBranch.compute(info, doc, this.cancel);
        if (unusedValue == null || this.cancel.get()) {
            return;
        }
        UnusedAssignmentOrBranch.getBag(doc).setHighlights(unusedValue);
    }

    static OffsetsBag compute(final CompilationInfo info, Document doc, AtomicBoolean cancel) {
        final OffsetsBag unusedValue = new OffsetsBag(doc);
        boolean computeUnusedAssignments = UnusedAssignmentOrBranch.isEnabled(UNUSED_ASSIGNMENT_ID);
        boolean computeDeadBranch = UnusedAssignmentOrBranch.isEnabled(DEAD_BRANCH_ID);
        if (!computeUnusedAssignments && !computeDeadBranch) {
            return unusedValue;
        }
        Flow.FlowResult flow = Flow.assignmentsForUse(info, cancel);
        if (flow == null || cancel.get()) {
            return null;
        }
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)"text/x-java").lookup(FontColorSettings.class);
        AttributeSet unusedCode = fcs == null ? AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]) : fcs.getTokenFontColors("unusedCode");
        String unusedAssignmentLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_UNUSED_ASSIGNMENT_LABEL");
        String deadBranchLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_DEAD_BRANCH");
        final AttributeSet unusedAssignment = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{unusedCode, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, unusedAssignmentLabel})});
        AttributeSet deadBranch = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{unusedCode, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, deadBranchLabel})});
        if (computeUnusedAssignments) {
            final HashSet<Tree> usedAssignments = new HashSet<Tree>();
            for (Iterable<? extends TreePath> i : flow.getAssignmentsForUse().values()) {
                for (TreePath treePath : i) {
                    if (treePath == null) continue;
                    usedAssignments.add(treePath.getLeaf());
                }
            }
            final HashSet hashSet = new HashSet();
            new CancellableTreePathScanner<Void, Void>(cancel){

                public Void visitAssignment(AssignmentTree node, Void p) {
                    Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                    if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                        this.scan(node.getExpression(), null);
                        return null;
                    }
                    return (Void)super.visitAssignment(node, (Object)p);
                }

                public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
                    Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                    if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                        this.scan(node.getExpression(), null);
                        return null;
                    }
                    return (Void)super.visitCompoundAssignment(node, (Object)p);
                }

                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element var = info.getTrees().getElement(this.getCurrentPath());
                    if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind())) {
                        hashSet.add(var);
                    }
                    return (Void)super.visitIdentifier(node, (Object)p);
                }
            }.scan((Tree)info.getCompilationUnit(), null);
            new CancellableTreePathScanner<Void, Void>(cancel){

                public Void visitAssignment(AssignmentTree node, Void p) {
                    Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                    if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression()) && hashSet.contains(var)) {
                        this.unusedValue(node.getExpression());
                    }
                    return (Void)super.visitAssignment(node, (Object)p);
                }

                public Void visitVariable(VariableTree node, Void p) {
                    Element var = info.getTrees().getElement(this.getCurrentPath());
                    if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && node.getInitializer() != null && !usedAssignments.contains(node.getInitializer()) && hashSet.contains(var)) {
                        this.unusedValue(node.getInitializer());
                    }
                    return (Void)super.visitVariable(node, (Object)p);
                }

                private void unusedValue(Tree t) {
                    int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), t);
                    int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), t);
                    if (start < 0 || end < 0) {
                        return;
                    }
                    unusedValue.addHighlight(start, end, unusedAssignment);
                }
            }.scan((Tree)info.getCompilationUnit(), null);
        }
        if (computeDeadBranch) {
            for (Tree tree : flow.getDeadBranches()) {
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
                if (start < 0 || end < 0) continue;
                unusedValue.addHighlight(start, end, deadBranch);
            }
        }
        return unusedValue;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    private static OffsetsBag getBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(UnusedAssignmentOrBranch.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(UnusedAssignmentOrBranch.class, bag);
        }
        return bag;
    }

    private static boolean isEnabled(String id) {
        Preferences p = RulesManager.getPreferences(id, HintsSettings.getCurrentProfileId());
        return p.getBoolean(ENABLED_KEY, true);
    }

    public static ErrorDescription unusedAssignment(HintContext ctx) {
        return null;
    }

    public static ErrorDescription deadBranch(HintContext ctx) {
        return null;
    }

    public static final class JavaFactoryImpl
    extends EditorAwareJavaSourceTaskFactory
    implements PreferenceChangeListener,
    LookupListener {
        private Lookup.Result<FontColorSettings> fcsResult;
        private boolean initialized;

        public JavaFactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
        }

        private synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Preferences unusedAssignmentPrefs = RulesManager.getPreferences(UnusedAssignmentOrBranch.UNUSED_ASSIGNMENT_ID, HintsSettings.getCurrentProfileId());
            unusedAssignmentPrefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)unusedAssignmentPrefs));
            Preferences deadBranchPrefs = RulesManager.getPreferences(UnusedAssignmentOrBranch.DEAD_BRANCH_ID, HintsSettings.getCurrentProfileId());
            deadBranchPrefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)deadBranchPrefs));
            this.fcsResult = MimeLookup.getLookup((String)"text/x-java").lookupResult(FontColorSettings.class);
            this.fcsResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.fcsResult));
            this.fcsResult.allItems();
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            this.initialize();
            return new UnusedAssignmentOrBranch();
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            this.refresh();
        }

        private void refresh() throws IllegalArgumentException {
            for (FileObject f : this.getFileObjects()) {
                this.reschedule(f);
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.refresh();
        }
    }

    public static final class HighlightsFactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)UnusedAssignmentOrBranch.class.getName(), (ZOrder)ZOrder.CARET_RACK, (boolean)true, (HighlightsContainer)UnusedAssignmentOrBranch.getBag(context.getDocument()))};
        }
    }
}

