/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OrganizeImports {
    public static ErrorDescription checkImports(HintContext context) {
        List diffs;
        Source source = context.getInfo().getSnapshot().getSource();
        ModificationResult result = null;
        try {
            result = ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    OrganizeImports.doOrganizeImports(copy);
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List list = diffs = result != null ? result.getDifferences(source.getFileObject()) : null;
        if (diffs != null && !diffs.isEmpty()) {
            Fix fix = JavaFix.toEditorFix(new OrganizeImportsFix(context.getInfo(), context.getPath()));
            return ErrorDescriptionFactory.forTree(context, context.getInfo().getCompilationUnit().getImports().get(0), NbBundle.getMessage(OrganizeImports.class, (String)"MSG_OragnizeImports"), fix);
        }
        return null;
    }

    private static void doOrganizeImports(WorkingCopy copy) throws IllegalStateException {
        Set<Element> toImport;
        Trees trees = copy.getTrees();
        CompilationUnitTree cu = copy.getCompilationUnit();
        if (!cu.getImports().isEmpty() && !(toImport = OrganizeImports.getUsedElements(cu, trees)).isEmpty()) {
            CompilationUnitTree cut = copy.getTreeMaker().CompilationUnit(cu.getPackageAnnotations(), cu.getPackageName(), Collections.emptyList(), cu.getTypeDecls(), cu.getSourceFile());
            ((JCTree.JCCompilationUnit)cut).packge = ((JCTree.JCCompilationUnit)cu).packge;
            CompilationUnitTree ncu = GeneratorUtilities.get((WorkingCopy)copy).addImports(cut, toImport);
            copy.rewrite((Tree)cu, (Tree)ncu);
        }
    }

    private static Set<Element> getUsedElements(final CompilationUnitTree cut, final Trees trees) {
        final HashSet<Element> ret = new HashSet<Element>();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element element = trees.getElement(this.getCurrentPath());
                if (element != null) {
                    switch (element.getKind()) {
                        case ENUM_CONSTANT: 
                        case FIELD: 
                        case METHOD: {
                            if (!element.getModifiers().contains((Object)Modifier.STATIC)) break;
                        }
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            Element glob = this.global(element);
                            if (glob == null) break;
                            ret.add(glob);
                        }
                    }
                }
                return null;
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }

            private Element global(Element element) {
                Scope.Entry e = ((JCTree.JCCompilationUnit)cut).namedImportScope.lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        return e.sym;
                    }
                    e = e.next();
                }
                e = ((JCTree.JCCompilationUnit)cut).packge.members().lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        return e.sym;
                    }
                    e = e.next();
                }
                e = ((JCTree.JCCompilationUnit)cut).starImportScope.lookup((Name)element.getSimpleName());
                while (e.scope != null) {
                    if (element == e.sym || element.asType().getKind() == TypeKind.ERROR && element.getKind() == e.sym.getKind()) {
                        return e.sym;
                    }
                    e = e.next();
                }
                return null;
            }
        }.scan(cut, null);
        return ret;
    }

    private static final class OrganizeImportsFix
    extends JavaFix {
        public OrganizeImportsFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(OrganizeImports.class, (String)"FIX_OrganizeImports");
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath tp, boolean canShowUI) {
            OrganizeImports.doOrganizeImports(wc);
        }
    }
}

