/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MissingHashCode {
    public static List<ErrorDescription> run(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element clazz = compilationInfo.getTrees().getElement(treePath);
        if (clazz == null || !clazz.getKind().isClass()) {
            return null;
        }
        ExecutableElement[] ret = EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)compilationInfo, (Element)clazz, (EqualsHashCodeGenerator.Cancel)new EqualsHashCodeGenerator.Cancel(){

            public boolean isCanceled() {
                return false;
            }
        });
        ExecutableElement warningToElement = null;
        String addHint = null;
        if (ret[0] == null && ret[1] != null) {
            addHint = "MSG_GenEquals";
            warningToElement = ret[1];
        }
        if (ret[1] == null && ret[0] != null) {
            addHint = "MSG_GenHashCode";
            warningToElement = ret[0];
        }
        if (addHint != null) {
            assert (warningToElement != null);
            TreePath warningTo = compilationInfo.getTrees().getPath(warningToElement);
            if (warningTo == null || warningTo.getLeaf().getKind() != Tree.Kind.METHOD) {
                return null;
            }
            List<FixImpl> fixes = Collections.singletonList(new FixImpl(addHint, TreePathHandle.create((Element)clazz, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
            int[] span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)warningTo.getLeaf());
            if (span != null) {
                ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)ctx.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(MissingHashCode.class, (String)addHint), fixes, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
                return Collections.singletonList(ed);
            }
        }
        return null;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"MSG_MissingHashCode");
    }

    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"HINT_MissingHashCode");
    }

    private static final class FixImpl
    implements Fix,
    Runnable,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;
        private boolean fieldFound;

        public FixImpl(String type, TreePathHandle handle, FileObject file) {
            this.handle = handle;
            this.file = file;
            this.msg = type;
        }

        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, (String)this.msg);
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            if (this.fieldFound) {
                EventQueue.invokeLater(this);
            } else {
                result.commit();
            }
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie cook = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                JEditorPane[] arr = cook.getOpenedPanes();
                if (arr == null) {
                    return;
                }
                EqualsHashCodeGenerator.invokeEqualsHashCode((TreePathHandle)this.handle, (JTextComponent)arr[0]);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Element element : this.handle.resolveElement((CompilationInfo)wc).getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                this.fieldFound = true;
                return;
            }
            EqualsHashCodeGenerator.generateEqualsAndHashCode((WorkingCopy)wc, (TreePath)this.handle.resolve((CompilationInfo)wc));
        }

        public String toString() {
            return "Fix";
        }
    }
}

