/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public class DoubleCheck
extends AbstractHint {
    private volatile transient boolean stop;
    private static final SpecificationVersion SOURCE_LEVEL_1_5 = new SpecificationVersion("1.5");

    public DoubleCheck() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.SYNCHRONIZED);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = false;
        Tree e = treePath.getLeaf();
        if (e == null || e.getKind() != Tree.Kind.SYNCHRONIZED) {
            return null;
        }
        SynchronizedTree synch = (SynchronizedTree)e;
        TreePath outer = this.findOuterIf(compilationInfo, treePath);
        if (outer == null) {
            return null;
        }
        IfTree same = null;
        TreePath block = new TreePath(treePath, synch.getBlock());
        for (StatementTree statementTree : synch.getBlock().getStatements()) {
            if (this.sameIfAndValidate(compilationInfo, new TreePath(block, statementTree), outer)) {
                same = (IfTree)statementTree;
                break;
            }
            if (!this.stop) continue;
            return null;
        }
        if (same == null) {
            return null;
        }
        List<Fix> fixes = Collections.singletonList(JavaFix.toEditorFix(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), TreePathHandle.create((TreePath)outer, (CompilationInfo)compilationInfo), compilationInfo.getFileObject())));
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), synch);
        ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(DoubleCheck.class, (String)"ERR_DoubleCheck"), fixes, (FileObject)compilationInfo.getFileObject(), (int)n, (int)(n + "synchronized".length()));
        return Collections.singletonList(ed);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_DoubleCheck");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_DoubleCheck");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private TreePath findOuterIf(CompilationInfo compilationInfo, TreePath treePath) {
        while (!this.stop && (treePath = treePath.getParentPath()) != null) {
            BlockTree b;
            Tree leaf = treePath.getLeaf();
            if (leaf.getKind() == Tree.Kind.IF) {
                return treePath;
            }
            if (leaf.getKind() == Tree.Kind.BLOCK && (b = (BlockTree)leaf).getStatements().size() == 1) continue;
            return null;
        }
        return null;
    }

    private boolean sameIfAndValidate(CompilationInfo info, TreePath statementTP, TreePath secondTP) {
        StatementTree statement = (StatementTree)statementTP.getLeaf();
        if (statement.getKind() != Tree.Kind.IF) {
            return false;
        }
        IfTree first = (IfTree)statement;
        IfTree second = (IfTree)secondTP.getLeaf();
        if (first.getElseStatement() != null) {
            return false;
        }
        if (second.getElseStatement() != null) {
            return false;
        }
        TreePath varFirst = this.equalToNull(new TreePath(statementTP, first.getCondition()));
        TreePath varSecond = this.equalToNull(new TreePath(secondTP, second.getCondition()));
        if (varFirst == null || varSecond == null) {
            return false;
        }
        Element firstVariable = info.getTrees().getElement(varFirst);
        Element secondVariable = info.getTrees().getElement(varSecond);
        if (firstVariable != null && ((Object)firstVariable).equals(secondVariable)) {
            return DoubleCheck.getSourceLevel(info).compareTo((Object)SOURCE_LEVEL_1_5) < 0 || !firstVariable.getModifiers().contains((Object)Modifier.VOLATILE);
        }
        return false;
    }

    private TreePath equalToNull(TreePath tp) {
        ExpressionTree t = (ExpressionTree)tp.getLeaf();
        if (t.getKind() == Tree.Kind.PARENTHESIZED) {
            ParenthesizedTree p = (ParenthesizedTree)t;
            t = p.getExpression();
            tp = new TreePath(tp, t);
        }
        if (t.getKind() != Tree.Kind.EQUAL_TO) {
            return null;
        }
        BinaryTree bt = (BinaryTree)t;
        if (bt.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() != Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getRightOperand());
        }
        if (bt.getLeftOperand().getKind() != Tree.Kind.NULL_LITERAL && bt.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            return new TreePath(tp, bt.getLeftOperand());
        }
        return null;
    }

    private static SpecificationVersion getSourceLevel(CompilationInfo info) {
        String sl = SourceLevelQuery.getSourceLevel((FileObject)info.getFileObject());
        if (sl == null) {
            return SOURCE_LEVEL_1_5;
        }
        return new SpecificationVersion(sl);
    }

    private static final class FixImpl
    extends JavaFix {
        private TreePathHandle synchHandle;
        private FileObject file;

        public FixImpl(TreePathHandle synchHandle, TreePathHandle ifHandle, FileObject file) {
            super(ifHandle);
            this.synchHandle = synchHandle;
            this.file = file;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(DoubleCheck.class, (String)"FIX_DoubleCheck");
        }

        public String toString() {
            return "FixDoubleCheck";
        }

        @Override
        protected void performRewrite(WorkingCopy wc, TreePath ifTreePath, boolean canShowUI) {
            Tree syncTree = this.synchHandle.resolve((CompilationInfo)wc).getLeaf();
            wc.rewrite(ifTreePath.getLeaf(), syncTree);
        }
    }
}

