/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class AbstractInfoDisplayPresenter
extends DisplayableDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midpnb/resources/broken-image.png";
    private static final Icon ICON_BROKEN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midpnb/resources/broken-image.png", (boolean)false);
    private JLabel imageLabel = new JLabel();
    private JLabel stringLabel;
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public AbstractInfoDisplayPresenter() {
        this.imageLabel.setHorizontalAlignment(0);
        this.stringLabel = new JLabel();
        this.stringLabel.setHorizontalAlignment(0);
        JPanel contentPanel = this.getPanel().getContentPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 10;
        contentPanel.add((Component)this.imageLabel, constraints);
        constraints.anchor = 18;
        contentPanel.add((Component)this.stringLabel, constraints);
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        PropertyValue value = this.getComponent().readProperty("image");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            DesignComponent imageComponent = value.getComponent();
            String path = null;
            if (imageComponent != null && !PropertyValue.Kind.USERCODE.equals((Object)(value = imageComponent.readProperty("resourcePath")).getKind())) {
                path = MidpTypes.getString((PropertyValue)value);
            }
            Icon icon = ScreenSupport.getIconFromImageComponent((DesignComponent)imageComponent);
            this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent((DesignComponent)imageComponent);
            if (this.imageFileObject != null) {
                this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
                this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), imageComponent, "resourcePath");
                this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
            }
            if (icon != null) {
                this.imageLabel.setText(null);
                this.imageLabel.setIcon(icon);
            } else if (path != null) {
                this.imageLabel.setText(path);
                this.imageLabel.setIcon(ICON_BROKEN);
            } else {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_image_not_specified"));
            }
        } else {
            this.imageLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_image_is_usercode"));
        }
        value = this.getComponent().readProperty("text");
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            String text = MidpTypes.getString((PropertyValue)this.getComponent().readProperty("text"));
            if (text == null) {
                this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_not_specified"));
            } else if (text.length() == 0) {
                this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_is_empty"));
            } else {
                this.stringLabel.setText(text);
                value = this.getComponent().readProperty("textFont");
                if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
                    DesignComponent font = value.getComponent();
                    this.stringLabel.setFont(ScreenSupport.getFont((ScreenDeviceInfo)deviceInfo, (DesignComponent)font));
                }
            }
        } else {
            this.stringLabel.setText(NbBundle.getMessage(AbstractInfoDisplayPresenter.class, (String)"DISP_text_is_usercode"));
        }
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor imagePropertyEditor = new ResourcePropertyEditor("image", this.getComponent());
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.imageLabel, (ScreenPropertyEditor)imagePropertyEditor));
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.stringLabel, (ScreenPropertyEditor)new ScreenStringPropertyEditor("text")));
        return descriptors;
    }

    protected void notifyDetached(DesignComponent component) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }
}

