/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.Hyperlinker;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ShowFailures
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ShowFailures.class.getName());
    private final HudsonJob job;
    private final String url;
    private final String displayName;
    private static final Pattern ASSERTION_FAILURE = Pattern.compile("(?m)junit[.]framework[.](AssertionFailedError|(Array)?ComparisonFailure)|java[.]lang[.]AssertionError($|: )");

    public ShowFailures(HudsonJobBuild build) {
        this(build.getJob(), build.getUrl(), build.getDisplayName());
    }

    public ShowFailures(HudsonMavenModuleBuild module) {
        this(module.getBuild().getJob(), module.getUrl(), module.getBuildDisplayName());
    }

    private ShowFailures(HudsonJob job, String url, String displayName) {
        this.job = job;
        this.url = url;
        this.displayName = displayName;
        this.putValue("Name", Bundle.ShowFailures_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new RequestProcessor(this.url + "testReport").post((Runnable)this);
    }

    @Override
    public void run() {
        try {
            XMLReader parser = XMLUtil.createXMLReader();
            parser.setContentHandler(new DefaultHandler(){
                InputOutput io;
                StringBuilder buf;
                Hyperlinker hyperlinker;
                TestSession session;
                Stack<Suite> suites;
                boolean firstLine;
                {
                    this.hyperlinker = new Hyperlinker(ShowFailures.this.job);
                    this.session = new TestSession(ShowFailures.this.displayName, new Project(){

                        public FileObject getProjectDirectory() {
                            return FileUtil.createMemoryFileSystem().getRoot();
                        }

                        public Lookup getLookup() {
                            return Lookup.EMPTY;
                        }
                    }, TestSession.SessionType.TEST, new TestRunnerNodeFactory(){

                        public TestsuiteNode createTestSuiteNode(String suiteName, boolean filtered) {
                            return new TestsuiteNode(suiteName, filtered);
                        }

                        public Node createTestMethodNode(Testcase testcase, Project project) {
                            return new TestMethodNode(testcase, project){

                                public Action[] getActions(boolean context) {
                                    return new Action[]{OpenUrlAction.forOpenable(new OpenableInBrowser(){

                                        @Override
                                        public String getUrl() {
                                            return ShowFailures.this.url + "testReport/" + testcase.getClassName().replaceFirst("[.][^.]+$", "") + "/" + testcase.getClassName().replaceFirst(".+[.]", "") + "/" + testcase.getName() + "/";
                                        }
                                    }), new DiffViewAction(this.testcase)};
                                }
                            };
                        }

                        public Node createCallstackFrameNode(String frameInfo, String displayName) {
                            return new CallstackFrameNode(frameInfo, displayName){

                                public Action getPreferredAction() {
                                    return new AbstractAction(Bundle.LBL_GotoSource()){
                                        FileObject f;
                                        int line;
                                        {
                                            Matcher m = Pattern.compile("\tat (.+[.])[^.]+[.][^.]+[(]([^.]+[.]java):([0-9]+)[)]").matcher(frameInfo);
                                            if (m.matches()) {
                                                String resource = m.group(1).replace('.', '/') + m.group(2);
                                                this.f = GlobalPathRegistry.getDefault().findResource(resource);
                                                this.line = Integer.parseInt(m.group(3));
                                                LOG.log(Level.FINER, "matched {0} -> {1}", new Object[]{resource, this.f});
                                            } else {
                                                LOG.log(Level.FINER, "no match for {0}", frameInfo);
                                            }
                                            this.setEnabled(this.f != null);
                                        }

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            if (this.f != null) {
                                                HudsonLogger.Helper.openAt(this.f, this.line - 1, -1, true);
                                            }
                                        }
                                    };
                                }

                                public Action[] getActions(boolean context) {
                                    return new Action[]{this.getPreferredAction()};
                                }
                            };
                        }
                    });
                    this.suites = new Stack();
                    this.firstLine = true;
                }

                private void prepareOutput() {
                    if (this.io == null) {
                        String title = Bundle.ShowFailures_title(ShowFailures.this.displayName);
                        this.io = IOProvider.getDefault().getIO(title, new Action[0]);
                        this.io.select();
                        Manager.getInstance().testStarted(this.session);
                    }
                }

                long parseDuration(String d) {
                    if (d == null) {
                        return 0L;
                    }
                    try {
                        return (long)(1000.0f * Float.parseFloat(d));
                    }
                    catch (NumberFormatException x) {
                        return 0L;
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.matches("errorStackTrace|stdout|stderr|name|className")) {
                        this.buf = new StringBuilder();
                    } else if (qName.equals("suite")) {
                        this.suites.push(new Suite());
                    } else if (qName.equals("case") && !this.suites.empty()) {
                        this.suites.peek().cases.push(new Case());
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.buf != null) {
                        this.buf.append(ch, start, length);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.suites.empty()) {
                        return;
                    }
                    Suite s = this.suites.peek();
                    String text = this.buf != null && this.buf.length() > 0 ? this.buf.toString() : null;
                    this.buf = null;
                    if (s.cases.empty()) {
                        if (qName.equals("stdout")) {
                            s.stdout = text;
                        } else if (qName.equals("stderr")) {
                            s.stderr = text;
                        } else if (qName.equals("name")) {
                            s.name = text;
                        } else if (qName.equals("duration")) {
                            s.duration = this.parseDuration(text);
                        }
                    } else {
                        Case c = s.cases.peek();
                        if (qName.equals("errorStackTrace")) {
                            c.errorStackTrace = text;
                        } else if (qName.equals("name")) {
                            c.name = text;
                        } else if (qName.equals("className")) {
                            c.className = text;
                        } else if (qName.equals("duration")) {
                            c.duration = this.parseDuration(text);
                        }
                    }
                    if (qName.equals("suite")) {
                        try {
                            this.show(s);
                        }
                        catch (IOException x) {
                            LOG.log(Level.FINE, null, x);
                        }
                        this.suites.pop();
                    } else if (qName.equals("case")) {
                        s.casesDone.add(s.cases.pop());
                    }
                }

                void show(Suite s) throws IOException {
                    this.prepareOutput();
                    OutputWriter out = this.io.getOut();
                    OutputWriter err = this.io.getErr();
                    TestSuite suite = new TestSuite(s.name);
                    this.session.addSuite(suite);
                    Manager.getInstance().displaySuiteRunning(this.session, suite.getName());
                    if (s.stderr != null) {
                        Manager.getInstance().displayOutput(this.session, s.stderr, true);
                    }
                    if (s.stdout != null) {
                        Manager.getInstance().displayOutput(this.session, s.stdout, false);
                    }
                    for (Case c : s.casesDone) {
                        if (c.errorStackTrace == null) continue;
                        String name = c.className + "." + c.name;
                        String shortName = c.name;
                        if (s.name != null && !s.name.equals(c.className)) {
                            shortName = name;
                            name = Bundle.ShowFailures_from_suite(name, s.name);
                        }
                        this.println();
                        out.println("[" + name + "]");
                        this.show(c.errorStackTrace, out);
                        Testcase test = new Testcase(shortName, null, this.session);
                        test.setClassName(c.className);
                        Trouble trouble = new Trouble(!ASSERTION_FAILURE.matcher(c.errorStackTrace).lookingAt());
                        trouble.setStackTrace(c.errorStackTrace.split("\r?\n"));
                        test.setTrouble(trouble);
                        LOG.log(Level.FINE, "got {0} as {1}", new Object[]{name, test.getStatus()});
                        test.setTimeMillis(c.duration);
                        this.session.addTestCase(test);
                    }
                    if (s.stderr != null || s.stdout != null) {
                        this.println();
                        this.show(s.stderr, err);
                        this.show(s.stdout, out);
                    }
                    Manager.getInstance().displayReport(this.session, this.session.getReport(s.duration));
                }

                void println() {
                    if (this.firstLine) {
                        this.firstLine = false;
                    } else {
                        this.io.getOut().println();
                    }
                }

                void show(String lines, OutputWriter w) {
                    if (lines == null) {
                        return;
                    }
                    for (String line : lines.split("\r\n?|\n")) {
                        this.hyperlinker.handleLine(line, w);
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                    if (this.io != null) {
                        this.io.getOut().close();
                        this.io.getErr().close();
                        Manager.getInstance().sessionFinished(this.session);
                    }
                }

                class Case {
                    String className;
                    String name;
                    String errorStackTrace;
                    long duration;

                    Case() {
                    }
                }

                class Suite {
                    String name;
                    String stdout;
                    String stderr;
                    Stack<Case> cases = new Stack();
                    List<Case> casesDone = new ArrayList<Case>();
                    long duration;

                    Suite() {
                    }
                }
            });
            String u = this.url + "testReport/api/xml?xpath=//suite[case/errorStackTrace]&wrapper=failures";
            InputSource source = new InputSource(new ConnectionBuilder().job(this.job).url(u).connection().getInputStream());
            source.setSystemId(u);
            parser.parse(source);
        }
        catch (FileNotFoundException x) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(Bundle.no_test_result());
        }
        catch (Exception x) {
            Toolkit.getDefaultToolkit().beep();
            LOG.log(Level.INFO, null, x);
        }
    }
}

