/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.status.SyncFileNode;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class HgUtils {
    private static final Pattern httpPasswordPattern = Pattern.compile("(https*://)(\\w+\\b):(\\b\\S*)@");
    private static final String httpPasswordReplacementStr = "$1$2:\\*\\*\\*\\*@";
    private static final Pattern httpCredentialsPattern = Pattern.compile("(.*://)(\\w+\\b):(\\b\\S*)@");
    private static final String httpCredentialsReplacementStr = "$1";
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)hg(\\" + File.separatorChar + ".*|$)");
    private static final String[] HG_IGNORE_FILES = new String[]{"\\.orig$", "\\.orig\\..*$", "\\.chg\\..*$", "\\.rej$", "\\.conflict\\~$"};
    private static final String HG_IGNORE_ORIG_FILES = "\\.orig$";
    private static final String HG_IGNORE_ORIG_ANY_FILES = "\\.orig\\..*$";
    private static final String HG_IGNORE_CHG_ANY_FILES = "\\.chg\\..*$";
    private static final String HG_IGNORE_REJ_ANY_FILES = "\\.rej$";
    private static final String HG_IGNORE_CONFLICT_ANY_FILES = "\\.conflict\\~$";
    private static final String FILENAME_HGIGNORE = ".hgignore";
    private static final String IGNORE_SYNTAX_PREFIX = "syntax:";
    private static final String IGNORE_SYNTAX_GLOB = "glob";
    private static final String IGNORE_SYNTAX_REGEXP = "regexp";
    private static HashMap<String, Set<Pattern>> ignorePatterns;
    public static final String HG_CHECK_REPOSITORY_TIMEOUT_SWITCH = "mercurial.checkRepositoryTimeout";
    public static final String HG_CHECK_REPOSITORY_DEFAULT_TIMEOUT = "5";
    public static final int HG_CHECK_REPOSITORY_DEFAULT_ROUNDS = 50;
    public static final String HG_FOLDER_NAME = ".hg";
    private static int repositoryValidityCheckRounds;
    public static String PREFIX_VERSIONING_MERCURIAL_URL;
    private static final Map<File, Set<String>> notSharable;
    private static int HG_NUM_PATTERNS_TO_CHECK;
    private static Logger TY9_LOG;

    public static Date addDaysToDate(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static String createAnnotationFormat(String format) {
        String string = format;
        string = Utils.skipUnsupportedVariables((String)string, (String[])new String[]{"{status}", "{folder}"});
        string = string.replaceAll("\\{status\\}", "\\{0\\}");
        string = string.replaceAll("\\{folder\\}", "\\{1\\}");
        return string;
    }

    public static boolean isSolaris() {
        return System.getProperty("os.name").equals("SunOS");
    }

    public static String removeHttpCredentials(String s) {
        Matcher m = httpCredentialsPattern.matcher(s);
        return m.replaceAll(httpCredentialsReplacementStr);
    }

    public static String replaceHttpPassword(String s) {
        Matcher m = httpPasswordPattern.matcher(s);
        return m.replaceAll(httpPasswordReplacementStr);
    }

    public static List<String> replaceHttpPassword(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>(list.size());
        for (String s : list) {
            out.add(HgUtils.replaceHttpPassword(s));
        }
        return out;
    }

    public static boolean isInUserPath(String name) {
        String path = HgUtils.findInUserPath(name);
        return path != null && !path.equals("");
    }

    public static String findInUserPath(String ... names) {
        String[] paths;
        String pathEnv = System.getenv().get("PATH");
        if (pathEnv == null) {
            pathEnv = System.getenv().get("Path");
        }
        if (pathEnv == null) {
            pathEnv = System.getenv().get("path");
        }
        String pathSeparator = System.getProperty("path.separator");
        if (pathEnv == null || pathSeparator == null) {
            return "";
        }
        for (String path : paths = pathEnv.split(pathSeparator)) {
            for (String name : names) {
                File f = new File(path, name);
                if (!f.exists() || f.isDirectory()) continue;
                return path;
            }
        }
        return "";
    }

    public static boolean confirmDialog(Class bundleLocation, String title, String query) {
        int response = JOptionPane.showOptionDialog(null, NbBundle.getMessage((Class)bundleLocation, (String)query), NbBundle.getMessage((Class)bundleLocation, (String)title), 0, 3, null, null, null);
        return response == 0;
    }

    public static void warningDialog(Class bundleLocation, String title, String warning) {
        JOptionPane.showMessageDialog(null, NbBundle.getMessage((Class)bundleLocation, (String)warning), NbBundle.getMessage((Class)bundleLocation, (String)title), 2);
    }

    public static JComponent addContainerBorder(JComponent comp) {
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        JPanel panel = new JPanel();
        panel.add(comp);
        panel.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap(comp, 1, null), layoutStyle.getContainerGap(comp, 7, null), layoutStyle.getContainerGap(comp, 5, null), layoutStyle.getContainerGap(comp, 3, null)));
        return panel;
    }

    public static String stripDoubleSlash(String path) {
        if (Utilities.isWindows()) {
            return path.replace("\\\\", "\\");
        }
        return path;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static void resetIgnorePatterns(File file) {
        if (ignorePatterns == null) {
            return;
        }
        String key = file.getAbsolutePath();
        ignorePatterns.remove(key);
    }

    private static Set<Pattern> getIgnorePatterns(File file) {
        String key;
        Set<Pattern> patterns;
        if (ignorePatterns == null) {
            ignorePatterns = new HashMap();
        }
        if ((patterns = ignorePatterns.get(key = file.getAbsolutePath())) == null) {
            patterns = new HashSet<Pattern>(5);
            HgUtils.addIgnorePatterns(patterns, file);
            ignorePatterns.put(key, patterns);
        }
        return patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNotSharable(File topFile, String ignoredPath) {
        Map<File, Set<String>> map = notSharable;
        synchronized (map) {
            Set<String> ignores = notSharable.get(topFile);
            if (ignores == null) {
                ignores = new HashSet<String>();
            }
            String patternCandidate = ignoredPath;
            Iterator<String> it = ignores.iterator();
            while (it.hasNext()) {
                String storedPattern = it.next();
                if (storedPattern.equals(ignoredPath) || ignoredPath.startsWith(storedPattern + '/')) {
                    patternCandidate = null;
                    break;
                }
                if (!storedPattern.startsWith(ignoredPath + '/')) continue;
                it.remove();
            }
            if (patternCandidate != null) {
                ignores.add(patternCandidate);
            }
            notSharable.put(topFile, ignores);
        }
    }

    private static boolean isNotSharable(String path, File topFile) {
        boolean retval = false;
        Set<String> notSharablePaths = notSharable.get(topFile);
        if (notSharablePaths == null) {
            notSharablePaths = Collections.emptySet();
        }
        retval = notSharablePaths.contains(path);
        return retval;
    }

    public static boolean isIgnored(File file) {
        return HgUtils.isIgnored(file, true);
    }

    public static boolean isIgnored(File file, boolean checkSharability) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        File topFile = Mercurial.getInstance().getRepositoryRoot(file);
        if (topFile == null || topFile.equals(file)) {
            return false;
        }
        Set<Pattern> patterns = HgUtils.getIgnorePatterns(topFile);
        path = path.substring(topFile.getAbsolutePath().length() + 1);
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(path).find()) continue;
            return true;
        }
        if (HgUtils.isNotSharable(path, topFile)) {
            return true;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.equals(topFile) && HgUtils.isIgnored(parentFile, false)) {
            return true;
        }
        if (FILENAME_HGIGNORE.equals(file.getName())) {
            return false;
        }
        if (checkSharability) {
            Logger.getLogger(HgUtils.class.getName()).log(Level.FINE, "Calling sharability for {0}:::{1}", new Object[]{file, topFile});
            int sharability = SharabilityQuery.getSharability((File)FileUtil.normalizeFile((File)file));
            if (sharability == 2) {
                HgUtils.addNotSharable(topFile, path);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createIgnored(File path) {
        block18: {
            File ignore;
            Mercurial hg;
            BufferedWriter fileWriter;
            block17: {
                if (path == null) {
                    return;
                }
                fileWriter = null;
                hg = Mercurial.getInstance();
                File root = hg.getRepositoryRoot(path);
                if (root == null) {
                    return;
                }
                ignore = new File(root, FILENAME_HGIGNORE);
                if (!ignore.exists()) {
                    fileWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(ignore)));
                    for (String name : HG_IGNORE_FILES) {
                        fileWriter.write(name + "\n");
                    }
                    break block17;
                }
                HgUtils.addToExistingIgnoredFile(ignore);
            }
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
                hg.getFileStatusCache().refresh(ignore);
            }
            catch (IOException ex) {
                Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{ignore.getAbsolutePath(), ex.toString()});
            }
            break block18;
            catch (IOException ex) {
                try {
                    Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{ignore.getAbsolutePath(), ex.toString()});
                }
                catch (Throwable throwable) {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        hg.getFileStatusCache().refresh(ignore);
                    }
                    catch (IOException ex2) {
                        Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{ignore.getAbsolutePath(), ex2.toString()});
                    }
                    throw throwable;
                }
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                    hg.getFileStatusCache().refresh(ignore);
                }
                catch (IOException ex3) {
                    Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{ignore.getAbsolutePath(), ex3.toString()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void addToExistingIgnoredFile(File hgignoreFile) {
        block53: {
            boolean bConflictAnyPresent;
            boolean bRejAnyPresent;
            boolean bChgAnyPresent;
            boolean bOrigPresent;
            boolean bOrigAnyPresent;
            PrintWriter pw;
            BufferedReader br;
            File tempFile;
            block52: {
                block51: {
                    if (hgignoreFile == null || !hgignoreFile.exists() || !hgignoreFile.canWrite()) {
                        return;
                    }
                    tempFile = null;
                    br = null;
                    pw = null;
                    bOrigAnyPresent = false;
                    bOrigPresent = false;
                    bChgAnyPresent = false;
                    bRejAnyPresent = false;
                    bConflictAnyPresent = false;
                    assert (HG_IGNORE_FILES.length == HG_NUM_PATTERNS_TO_CHECK);
                    tempFile = new File(hgignoreFile.getAbsolutePath() + ".tmp");
                    if (tempFile != null) break block51;
                    try {
                        boolean bAnyAdditions;
                        if (pw != null) {
                            pw.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        boolean bl = bAnyAdditions = !bOrigAnyPresent || !bOrigPresent || !bChgAnyPresent || !bRejAnyPresent || !bConflictAnyPresent;
                        if (bAnyAdditions) {
                            if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                                tempFile.delete();
                                return;
                            }
                            if (tempFile != null && tempFile.isFile() && tempFile.canWrite() && hgignoreFile != null) {
                                hgignoreFile.delete();
                                tempFile.renameTo(hgignoreFile);
                            }
                        } else {
                            tempFile.delete();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return;
                }
                br = new BufferedReader(new FileReader(hgignoreFile));
                pw = new PrintWriter(new FileWriter(tempFile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!bOrigAnyPresent && line.equals(HG_IGNORE_ORIG_ANY_FILES)) {
                        bOrigAnyPresent = true;
                    } else if (!bOrigPresent && line.equals(HG_IGNORE_ORIG_FILES)) {
                        bOrigPresent = true;
                    } else if (!bChgAnyPresent && line.equals(HG_IGNORE_CHG_ANY_FILES)) {
                        bChgAnyPresent = true;
                    } else if (!bRejAnyPresent && line.equals(HG_IGNORE_REJ_ANY_FILES)) {
                        bRejAnyPresent = true;
                    } else if (!bConflictAnyPresent && line.equals(HG_IGNORE_CONFLICT_ANY_FILES)) {
                        bConflictAnyPresent = true;
                    }
                    pw.println(line);
                    pw.flush();
                }
                if (!bOrigAnyPresent) {
                    pw.println(HG_IGNORE_ORIG_ANY_FILES);
                    pw.flush();
                }
                if (!bOrigPresent) {
                    pw.println(HG_IGNORE_ORIG_FILES);
                    pw.flush();
                }
                if (!bChgAnyPresent) {
                    pw.println(HG_IGNORE_CHG_ANY_FILES);
                    pw.flush();
                }
                if (!bRejAnyPresent) {
                    pw.println(HG_IGNORE_REJ_ANY_FILES);
                    pw.flush();
                }
                if (bConflictAnyPresent) break block52;
                pw.println(HG_IGNORE_CONFLICT_ANY_FILES);
                pw.flush();
            }
            try {
                boolean bAnyAdditions;
                if (pw != null) {
                    pw.close();
                }
                if (br != null) {
                    br.close();
                }
                boolean bl = bAnyAdditions = !bOrigAnyPresent || !bOrigPresent || !bChgAnyPresent || !bRejAnyPresent || !bConflictAnyPresent;
                if (bAnyAdditions) {
                    if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                        tempFile.delete();
                        return;
                    }
                    if (tempFile != null && tempFile.isFile() && tempFile.canWrite() && hgignoreFile != null) {
                        hgignoreFile.delete();
                        tempFile.renameTo(hgignoreFile);
                    }
                    break block53;
                }
                tempFile.delete();
            }
            catch (IOException ex) {}
            break block53;
            catch (IOException ex) {
                try {
                    boolean bAnyAdditions;
                    if (pw != null) {
                        pw.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                    boolean bl = bAnyAdditions = !bOrigAnyPresent || !bOrigPresent || !bChgAnyPresent || !bRejAnyPresent || !bConflictAnyPresent;
                    if (bAnyAdditions) {
                        if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                            tempFile.delete();
                            return;
                        }
                        if (tempFile != null && tempFile.isFile() && tempFile.canWrite() && hgignoreFile != null) {
                            hgignoreFile.delete();
                            tempFile.renameTo(hgignoreFile);
                        }
                        break block53;
                    }
                    tempFile.delete();
                }
                catch (IOException ex2) {}
                break block53;
                catch (Throwable throwable) {
                    try {
                        boolean bAnyAdditions;
                        if (pw != null) {
                            pw.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        boolean bl = bAnyAdditions = !bOrigAnyPresent || !bOrigPresent || !bChgAnyPresent || !bRejAnyPresent || !bConflictAnyPresent;
                        if (bAnyAdditions) {
                            if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                                tempFile.delete();
                                return;
                            }
                            if (tempFile != null && tempFile.isFile() && tempFile.canWrite() && hgignoreFile != null) {
                                hgignoreFile.delete();
                                tempFile.renameTo(hgignoreFile);
                            }
                        } else {
                            tempFile.delete();
                        }
                    }
                    catch (IOException ex3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private static void addIgnorePatterns(Set<Pattern> patterns, File file) {
        Set<String> shPatterns;
        try {
            shPatterns = HgUtils.readIgnoreEntries(file, true);
        }
        catch (IOException e) {
            return;
        }
        for (String shPattern : shPatterns) {
            if ("!".equals(shPattern)) {
                patterns.clear();
                continue;
            }
            try {
                patterns.add(Pattern.compile(shPattern));
            }
            catch (Exception e) {}
        }
    }

    private static String removeCommentsInIgnore(String line) {
        boolean cont;
        int indexOfHash = -1;
        do {
            cont = false;
            if ((indexOfHash = line.indexOf("#", indexOfHash)) <= 0 || line.charAt(indexOfHash - 1) != '\\') continue;
            ++indexOfHash;
            cont = true;
        } while (cont);
        if (indexOfHash != -1) {
            line = indexOfHash == 0 ? "" : line.substring(0, indexOfHash).trim();
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean ignoreContainsSyntax(File directory) throws IOException {
        File hgIgnore = new File(directory, FILENAME_HGIGNORE);
        Boolean val = false;
        if (!hgIgnore.canRead()) {
            return val;
        }
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(hgIgnore));
            while ((s = r.readLine()) != null) {
                String[] array;
                String line = s.trim();
                if ((line = HgUtils.removeCommentsInIgnore(line)).length() == 0 || !(array = line.split(" "))[0].equals(IGNORE_SYNTAX_PREFIX)) continue;
                val = true;
                break;
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readIgnoreEntries(File directory, boolean transformEntries) throws IOException {
        File hgIgnore = new File(directory, FILENAME_HGIGNORE);
        LinkedHashSet<String> entries = new LinkedHashSet<String>(5);
        if (!hgIgnore.canRead()) {
            return entries;
        }
        BufferedReader r = null;
        boolean glob = false;
        try {
            String s;
            r = new BufferedReader(new FileReader(hgIgnore));
            while ((s = r.readLine()) != null) {
                String line = s;
                if (transformEntries) {
                    line = line.trim();
                    if ((line = HgUtils.removeCommentsInIgnore(line)).length() == 0) continue;
                    String[] array = line.split(" ");
                    if (array[0].equals(IGNORE_SYNTAX_PREFIX)) {
                        String syntax = line.substring(IGNORE_SYNTAX_PREFIX.length()).trim();
                        if (IGNORE_SYNTAX_GLOB.equals(syntax)) {
                            glob = true;
                            continue;
                        }
                        if (!IGNORE_SYNTAX_REGEXP.equals(syntax)) continue;
                        glob = false;
                        continue;
                    }
                }
                entries.add(glob ? HgUtils.transformFromGlobPattern(line) : line);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
        return entries;
    }

    private static String transformFromGlobPattern(String pattern) {
        pattern = pattern.replace("$", "\\$").replace("^", "\\^").replace(".", "\\.").replace("*", ".*") + '$';
        return "^" + pattern + "|" + ".*/" + pattern;
    }

    private static String computePatternToIgnore(File directory, File file) {
        String name = "^" + file.getAbsolutePath().substring(directory.getAbsolutePath().length() + 1) + "$";
        return name.replace(File.separatorChar, '/').replace("#", "\\#").replace(".", "\\.").replace("+", "\\+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIgnoreEntries(File directory, Set entries) throws IOException {
        File hgIgnore = new File(directory, FILENAME_HGIGNORE);
        FileObject fo = FileUtil.toFileObject((File)hgIgnore);
        if (entries.isEmpty()) {
            if (fo != null) {
                fo.delete();
            }
            HgUtils.resetIgnorePatterns(directory);
            return;
        }
        if (fo == null || !fo.isValid()) {
            fo = FileUtil.toFileObject((File)directory);
            fo = fo.createData(FILENAME_HGIGNORE);
        }
        FileLock lock = fo.lock();
        PrintWriter w = null;
        try {
            w = new PrintWriter(fo.getOutputStream(lock));
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                w.println(i.next());
            }
        }
        finally {
            lock.releaseLock();
            if (w != null) {
                w.close();
            }
            HgUtils.resetIgnorePatterns(directory);
        }
    }

    public static void addIgnored(File directory, File[] files) throws IOException {
        if (HgUtils.ignoreContainsSyntax(directory).booleanValue()) {
            HgUtils.warningDialog(HgUtils.class, "MSG_UNABLE_TO_IGNORE_TITLE", "MSG_UNABLE_TO_IGNORE");
            return;
        }
        Set<String> entries = HgUtils.readIgnoreEntries(directory, false);
        for (File file : files) {
            String patterntoIgnore = HgUtils.computePatternToIgnore(directory, file);
            entries.add(patterntoIgnore);
        }
        HgUtils.writeIgnoreEntries(directory, entries);
    }

    public static void removeIgnored(File directory, File[] files) throws IOException {
        if (HgUtils.ignoreContainsSyntax(directory).booleanValue()) {
            HgUtils.warningDialog(HgUtils.class, "MSG_UNABLE_TO_UNIGNORE_TITLE", "MSG_UNABLE_TO_UNIGNORE");
            return;
        }
        Set<String> entries = HgUtils.readIgnoreEntries(directory, false);
        for (File file : files) {
            String patterntoIgnore = HgUtils.computePatternToIgnore(directory, file);
            entries.remove(patterntoIgnore);
        }
        HgUtils.writeIgnoreEntries(directory, entries);
    }

    public static VCSContext getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (File file : context.getRootFiles()) {
            FileInformation fi = cache.getStatus(file);
            if (!(file.isDirectory() ? (fi.getStatus() & includingFolderStatus) == 0 : (fi.getStatus() & includingFileStatus) == 0)) continue;
            return VCSContext.EMPTY;
        }
        return context;
    }

    public static VCSContext getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        return VCSContext.forNodes((Node[])nodes);
    }

    public static String getRootPath(VCSContext context) {
        File root = HgUtils.getRootFile(context);
        return root == null ? null : root.getAbsolutePath();
    }

    public static boolean isFromHgRepository(VCSContext context) {
        return HgUtils.getRootFile(context) != null;
    }

    public static File getRootFile(VCSContext context) {
        if (context == null) {
            return null;
        }
        Mercurial hg = Mercurial.getInstance();
        File[] files = context.getRootFiles().toArray(new File[context.getRootFiles().size()]);
        if (files == null || files.length == 0) {
            return null;
        }
        File root = hg.getRepositoryRoot(files[0]);
        return root;
    }

    public static Set<File> getRepositoryRoots(VCSContext context) {
        Set rootsSet = context.getRootFiles();
        return HgUtils.getRepositoryRoots(rootsSet);
    }

    public static Set<File> getRepositoryRoots(Set<File> roots) {
        HashSet<File> ret = new HashSet<File>();
        for (File file : roots) {
            File repoRoot;
            if (!Mercurial.getInstance().isManaged(file) || (repoRoot = Mercurial.getInstance().getRepositoryRoot(file)) == null) continue;
            ret.add(repoRoot);
        }
        return ret;
    }

    public static File[] getActionRoots(VCSContext ctx) {
        List l;
        Set rootsSet = ctx.getRootFiles();
        HashMap<File, LinkedList<File>> map = new HashMap<File, LinkedList<File>>();
        for (File file : rootsSet) {
            File repoRoot;
            if (!Mercurial.getInstance().isManaged(file) || (repoRoot = Mercurial.getInstance().getRepositoryRoot(file)) == null) continue;
            l = (LinkedList<File>)map.get(repoRoot);
            if (l == null) {
                l = new LinkedList<File>();
                map.put(repoRoot, (LinkedList<File>)l);
            }
            l.add(file);
        }
        Set repoRoots = map.keySet();
        if (map.size() > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(HgUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(HgUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.mercurial.FileSelector"), HgModuleConfig.getDefault().getPreferences());
            if (fs.show(repoRoots.toArray(new File[repoRoots.size()]))) {
                File selection = fs.getSelectedFile();
                l = (List)map.get(selection);
                return l.toArray(new File[l.size()]);
            }
            return null;
        }
        if (map.isEmpty()) {
            return new File[0];
        }
        List l2 = (List)map.get(map.keySet().iterator().next());
        return l2.toArray(new File[l2.size()]);
    }

    public static File[] filterForRepository(VCSContext ctx, File repository, boolean rootFiles) {
        File[] files = null;
        if (ctx != null) {
            Set s = rootFiles ? ctx.getRootFiles() : ctx.getFiles();
            files = s.toArray(new File[s.size()]);
        }
        if (files != null) {
            LinkedList<File> l = new LinkedList<File>();
            for (File file : files) {
                File r = Mercurial.getInstance().getRepositoryRoot(file);
                if (r == null || !r.equals(repository)) continue;
                l.add(file);
            }
            files = l.toArray(new File[l.size()]);
        }
        return files;
    }

    public static Map<File, Set<File>> sortUnderRepository(VCSContext ctx, boolean rootFiles) {
        Set files = null;
        if (ctx != null) {
            files = rootFiles ? ctx.getRootFiles() : ctx.getFiles();
        }
        return HgUtils.sortUnderRepository(files);
    }

    public static Map<File, Set<File>> sortUnderRepository(Set<File> files) {
        HashMap<File, HashSet<File>> sortedRoots = null;
        if (files != null) {
            sortedRoots = new HashMap<File, HashSet<File>>();
            for (File file : files) {
                File r = Mercurial.getInstance().getRepositoryRoot(file);
                HashSet<File> repositoryRoots = (HashSet<File>)sortedRoots.get(r);
                if (repositoryRoots == null) {
                    repositoryRoots = new HashSet<File>();
                    sortedRoots.put(r, repositoryRoots);
                }
                repositoryRoots.add(file);
            }
        }
        return sortedRoots == null ? Collections.emptyMap() : sortedRoots;
    }

    public static boolean isPartOfMercurialMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static void forceStatusRefresh(File file) {
        if (HgUtils.isAdministrative(file)) {
            return;
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        File repositoryRoot = Mercurial.getInstance().getRepositoryRoot(file);
        if (file.equals(repositoryRoot)) {
            cache.refreshAllRoots(Collections.singletonMap(repositoryRoot, Mercurial.getInstance().getSeenRoots(repositoryRoot)));
        } else {
            cache.refresh(file);
        }
    }

    public static void forceStatusRefreshProject(VCSContext context) {
        Project project = Utils.getProject((VCSContext)context);
        if (project == null) {
            return;
        }
        File[] files = Utils.getProjectRootFiles((Project)project);
        for (int j = 0; j < files.length; ++j) {
            HgUtils.forceStatusRefresh(files[j]);
        }
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(File file) {
        if (file == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        String shortPath = file.getAbsolutePath();
        if (shortPath == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        Mercurial mercurial = Mercurial.getInstance();
        File rootManagedFolder = mercurial.getRepositoryRoot(file);
        if (rootManagedFolder == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        String root = rootManagedFolder.getAbsolutePath();
        if (shortPath.startsWith(root)) {
            return shortPath.substring(root.length() + 1);
        }
        return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
    }

    public static File[] flatten(File[] files, int status) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if ((status & info.getStatus()) != 0) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if ((status & info.getStatus()) == 0) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] getModifiedFiles(VCSContext context, int includeStatus, boolean testCommitExclusions) {
        File[] all = Mercurial.getInstance().getFileStatusCache().listFiles(context, includeStatus);
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            File file = all[i];
            if (testCommitExclusions && HgModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) continue;
            files.add(file);
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        for (File file : context.getRootFiles()) {
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isBinary(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            byte ch = buffer[i];
            if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
            return true;
        }
        return false;
    }

    public static int getNumberOfRoundsForRepositoryValidityCheck() {
        if (repositoryValidityCheckRounds <= 0) {
            try {
                repositoryValidityCheckRounds = Integer.parseInt(System.getProperty(HG_CHECK_REPOSITORY_TIMEOUT_SWITCH, HG_CHECK_REPOSITORY_DEFAULT_TIMEOUT)) * 10;
            }
            catch (NumberFormatException ex) {
                Mercurial.LOG.log(Level.INFO, "Parsing integer failed, default value will be used", ex);
            }
            if (repositoryValidityCheckRounds <= 0) {
                Mercurial.LOG.fine("Using default value for number of rounds in repository validity check: 50");
                repositoryValidityCheckRounds = 50;
            }
        }
        return repositoryValidityCheckRounds;
    }

    public static boolean hasResolveCommand(String version) {
        return version != null && (!version.startsWith("0.") || !version.startsWith("1.0"));
    }

    public static boolean hasTopoOption(String version) {
        return version != null && !version.startsWith("0.") && !version.startsWith("1.0") && !version.startsWith("1.1") && !version.startsWith("1.2") && !version.startsWith("1.3") && !version.startsWith("1.4");
    }

    public static String getRemoteRepository(File file) {
        if (file == null) {
            return null;
        }
        String remotePath = HgRepositoryContextCache.getInstance().getPullDefault(file);
        if (remotePath == null || remotePath.trim().isEmpty()) {
            Mercurial.LOG.log(Level.FINE, "No default pull available for managed file : [{0}]", file);
            remotePath = HgRepositoryContextCache.getInstance().getPushDefault(file);
            if (remotePath == null || remotePath.trim().isEmpty()) {
                Mercurial.LOG.log(Level.FINE, "No default pull or push available for managed file : [{0}]", file);
            }
        }
        if (remotePath != null) {
            remotePath = remotePath.trim();
            if ((remotePath = HgUtils.removeHttpCredentials(remotePath)).isEmpty()) {
                remotePath = null;
            }
        }
        return remotePath;
    }

    public static void openInRevision(final File originalFile, final HgLogMessage.HgRevision revision, boolean showAnnotations) throws IOException {
        File file = VersionsCache.getInstance().getFileRevision(originalFile, revision);
        if (file == null) {
            file = File.createTempFile("tmp", "-" + originalFile.getName());
            file.deleteOnExit();
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Mercurial.LOG.log(Level.FINE, null, ex);
        }
        CloneableEditorSupport ces = null;
        if (ec == null && oc != null) {
            oc.open();
        } else {
            ces = Utils.openFile((FileObject)fo, (String)revision.getRevisionNumber());
        }
        if (showAnnotations) {
            if (ces == null) {
                return;
            }
            final CloneableEditorSupport support = ces;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane[] panes = support.getOpenedPanes();
                    if (panes != null) {
                        AnnotateAction.showAnnotations(panes[0], originalFile, revision.getRevisionNumber());
                    }
                }
            });
        }
    }

    public static boolean isCanceled(Exception e) {
        Throwable cause;
        for (cause = e; cause != null && !(cause instanceof HgException.HgCommandCanceledException); cause = cause.getCause()) {
        }
        return cause instanceof HgException.HgCommandCanceledException;
    }

    public static File[] splitIntoSeenRoots(File root) {
        File[] roots;
        File repositoryRoot = Mercurial.getInstance().getRepositoryRoot(root);
        if (root.equals(repositoryRoot)) {
            Set<File> seenRoots = Mercurial.getInstance().getSeenRoots(repositoryRoot);
            roots = seenRoots.toArray(new File[seenRoots.size()]);
        } else {
            roots = new File[]{root};
        }
        return roots;
    }

    public static boolean isRepositoryLocked(File repository) {
        String[] locks = HgUtils.getHgFolderForRoot(repository).list();
        return locks != null && Arrays.asList(locks).contains("wlock");
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x40)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public static String ripUserFromHost(String host) {
        int idx = host.indexOf(64);
        if (idx < 0) {
            return host;
        }
        return host.substring(idx + 1);
    }

    public static String getMimeType(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        String foMime = fo == null ? "content/unknown" : fo.getMIMEType();
        if (foMime.startsWith("text")) {
            return foMime;
        }
        return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
    }

    public static void logHgLog(HgLogMessage log, OutputLogger logger) {
        String lbChangeset = NbBundle.getMessage(HgUtils.class, (String)"LB_CHANGESET");
        String lbUser = NbBundle.getMessage(HgUtils.class, (String)"LB_AUTHOR");
        String lbBranch = NbBundle.getMessage(HgUtils.class, (String)"LB_BRANCH");
        String lbTags = NbBundle.getMessage(HgUtils.class, (String)"LB_TAGS");
        String lbDate = NbBundle.getMessage(HgUtils.class, (String)"LB_DATE");
        String lbSummary = NbBundle.getMessage(HgUtils.class, (String)"LB_SUMMARY");
        int l = 0;
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(lbChangeset, lbUser, lbDate, lbSummary));
        if (log.getBranches().length > 0) {
            list.add(lbBranch);
        }
        if (log.getTags().length > 0) {
            list.add(lbTags);
        }
        for (String s : list) {
            if (l >= s.length()) continue;
            l = s.length();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(HgUtils.formatlabel(lbChangeset, l));
        sb.append(log.getRevisionNumber());
        sb.append(":");
        sb.append(log.getCSetShortID());
        sb.append('\n');
        if (log.getBranches().length > 0) {
            sb.append(HgUtils.formatlabel(lbBranch, l));
            for (String branch : log.getBranches()) {
                sb.append(branch);
            }
            sb.append('\n');
        }
        if (log.getTags().length > 0) {
            sb.append(HgUtils.formatlabel(lbTags, l));
            for (String tag : log.getTags()) {
                sb.append(tag).append(' ');
            }
            sb.append('\n');
        }
        sb.append(HgUtils.formatlabel(lbUser, l));
        sb.append(log.getAuthor());
        sb.append('\n');
        sb.append(HgUtils.formatlabel(lbDate, l));
        sb.append(log.getDate());
        sb.append('\n');
        sb.append(HgUtils.formatlabel(lbSummary, l));
        sb.append(log.getMessage());
        sb.append('\n');
        logger.output(sb.toString());
    }

    private static String formatlabel(String label, int l) {
        label = label + HgUtils.spaces(l - label.length()) + ": ";
        return label;
    }

    private static String spaces(int l) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l + 3; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private HgUtils() {
    }

    public static void logT9Y(String msg) {
        if (TY9_LOG == null) {
            TY9_LOG = Logger.getLogger("org.netbeans.modules.mercurial.t9y");
        }
        TY9_LOG.log(Level.FINEST, msg);
    }

    public static boolean isAnnotationFormatValid(String format) {
        boolean retval = true;
        if (format != null) {
            try {
                new MessageFormat(format);
            }
            catch (IllegalArgumentException ex) {
                Mercurial.LOG.log(Level.FINER, "Bad user input - annotation format", ex);
                retval = false;
            }
        }
        return retval;
    }

    public static boolean isAdministrative(File file) {
        String name = file.getName();
        return HgUtils.isAdministrative(name) && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(HG_FOLDER_NAME);
    }

    public static boolean hgExistsFor(File file) {
        return new File(file, HG_FOLDER_NAME).exists();
    }

    public static CommitOptions[] createDefaultCommitOptions(HgFileNode[] nodes, boolean excludeNew) {
        CommitOptions[] commitOptions = new CommitOptions[nodes.length];
        block4: for (int i = 0; i < nodes.length; ++i) {
            HgFileNode node = nodes[i];
            File file = node.getFile();
            if (HgModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) {
                commitOptions[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (node.getInformation().getStatus()) {
                case 256: 
                case 2048: {
                    commitOptions[i] = CommitOptions.COMMIT_REMOVE;
                    continue block4;
                }
                case 4: {
                    commitOptions[i] = excludeNew ? CommitOptions.EXCLUDE : CommitOptions.COMMIT;
                    continue block4;
                }
                default: {
                    commitOptions[i] = CommitOptions.COMMIT;
                }
            }
        }
        return commitOptions;
    }

    public static File getHgFolderForRoot(File repositoryRoot) {
        return FileUtil.normalizeFile((File)new File(repositoryRoot, HG_FOLDER_NAME));
    }

    public static void runIfHgAvailable(final Runnable runnable) {
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (Mercurial.getInstance().isAvailable(true, true)) {
                    EventQueue.invokeLater(runnable);
                }
            }
        });
    }

    public static File prepareRootFiles(File repository, Set<File> filesUnderRoot, File file) {
        boolean added = false;
        File addedRoot = null;
        for (File fileUnderRoot : filesUnderRoot) {
            File childCandidate = file;
            File ancestorCandidate = fileUnderRoot;
            added = true;
            if (childCandidate.equals(ancestorCandidate) || ancestorCandidate.equals(repository)) break;
            if (childCandidate.equals(repository)) {
                ancestorCandidate = childCandidate;
            } else {
                if (file.getAbsolutePath().length() < fileUnderRoot.getAbsolutePath().length()) {
                    ancestorCandidate = file;
                    childCandidate = fileUnderRoot;
                }
                if (!Utils.isAncestorOrEqual((File)ancestorCandidate, (File)childCandidate)) {
                    ancestorCandidate = Utils.getCommonParent((File)childCandidate, (File)ancestorCandidate);
                }
            }
            if (ancestorCandidate == fileUnderRoot) break;
            if (!FileStatusCache.FULL_REPO_SCAN_ENABLED && ancestorCandidate != childCandidate && ancestorCandidate.equals(repository)) {
                added = false;
                continue;
            }
            if (ancestorCandidate != null) {
                if (ancestorCandidate.equals(repository)) {
                    filesUnderRoot.clear();
                } else {
                    filesUnderRoot.remove(fileUnderRoot);
                }
                addedRoot = ancestorCandidate;
                filesUnderRoot.add(addedRoot);
                break;
            }
            added = false;
        }
        if (!added) {
            addedRoot = file;
            filesUnderRoot.add(addedRoot);
        }
        return addedRoot;
    }

    public static boolean notifyUpdatedFiles(File repo, List<String> list) {
        boolean anyFileNotified = false;
        for (String line : list) {
            if (!line.startsWith("getting ") && !line.startsWith("merging ")) continue;
            String name = line.substring(8);
            File file = new File(repo, name);
            anyFileNotified = true;
            Mercurial.getInstance().notifyFileChanged(file);
        }
        return anyFileNotified;
    }

    static {
        repositoryValidityCheckRounds = 0;
        PREFIX_VERSIONING_MERCURIAL_URL = "versioning.mercurial.url.";
        notSharable = Collections.synchronizedMap(new HashMap(5));
        HG_NUM_PATTERNS_TO_CHECK = 5;
        TY9_LOG = null;
    }

    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation i1, FileInformation i2) {
            return HgUtils.getComparableStatus(i1.getStatus()) - HgUtils.getComparableStatus(i2.getStatus());
        }
    }
}

