/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.shelve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffChangesAction;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ShelveChangesAction
extends ContextAction {
    @Override
    public boolean enable(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(ctx) || !Mercurial.getInstance().getFileStatusCache().containsFileOfStatus(ctx, 6612, true)) {
            return false;
        }
        return super.enable(nodes);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_ShelveChanges_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File root = HgUtils.getRootFile(ctx);
        if (root == null) {
            Mercurial.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        HgShelveChangesSupport supp = new HgShelveChangesSupport();
        if (supp.prepare()) {
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
            supp.startAsync(rp, root, ctx);
        }
    }

    private static class HgShelveChangesSupport
    extends ShelveChangesSupport {
        private HgProgressSupport support;
        private OutputLogger logger;
        private Set<File> filteredRoots;

        private HgShelveChangesSupport() {
        }

        protected void exportPatch(File toFile, File commonParent) throws IOException {
            this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.exporting"));
            ArrayList<Setup> setups = new ArrayList<Setup>(this.filteredRoots.size());
            for (File file : this.filteredRoots) {
                Setup setup = new Setup(file, null, 0);
                setups.add(setup);
            }
            ((ExportDiffChangesAction)SystemAction.get(ExportDiffChangesAction.class)).exportDiff(setups, toFile, commonParent, this.support);
        }

        protected void postExportCleanup() {
            Map<File, Set<File>> sorted = HgUtils.sortUnderRepository(this.filteredRoots);
            for (Map.Entry<File, Set<File>> e : sorted.entrySet()) {
                File root = e.getKey();
                Set<File> roots = e.getValue();
                if (roots.isEmpty()) continue;
                this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.reverting", (Object)root.getName()));
                RevertModificationsAction.performRevert(root, null, roots.toArray(new File[roots.size()]), true, this.logger);
            }
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, File root, final VCSContext context) {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    HgShelveChangesSupport.this.logger = this.getLogger();
                    HgShelveChangesSupport.this.filteredRoots = new HashSet<File>(Arrays.asList(HgUtils.getModifiedFiles(context, 6612, true)));
                    HgShelveChangesSupport.this.shelveChanges(HgShelveChangesSupport.this.filteredRoots.toArray(new File[HgShelveChangesSupport.this.filteredRoots.size()]));
                }
            };
            this.support.start(rp, root, NbBundle.getMessage(ShelveChangesAction.class, (String)"LBL_ShelveChanges_Progress"));
        }
    }
}

