/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.history.LinkButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ChangesetPickerPanel
extends JPanel {
    private File repository;
    private File[] roots;
    private static final RequestProcessor rp = new RequestProcessor("ChangesetPicker", 1, true);
    private int fetchRevisionLimit = 7;
    private boolean bGettingRevisions = false;
    public static final String HG_TIP = "tip";
    private final MessageInfoFetcher defaultMessageInfoFetcher;
    private MessageInfoFetcher messageInfofetcher;
    private HgProgressSupport hgProgressSupport;
    private InitialLoadingProgressSupport initialProgressSupport;
    private static final String MARK_ACTIVE_HEAD = "*";
    public static final String PROP_VALID = "prop.valid";
    protected static final HgLogMessage TIP = new HgLogMessage(null, Collections.<String>emptyList(), "tip", null, null, null, Long.toString(new Date().getTime()), "tip", null, null, null, null, null, "", "");
    protected static final HgLogMessage NO_REVISION = new HgLogMessage(null, Collections.<String>emptyList(), null, null, null, null, Long.toString(new Date().getTime()), NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default"), null, null, null, null, null, "", "");
    private HgLogMessage parentRevision;
    private boolean validSelection;
    private final Timer filterTimer;
    private HgLogMessage[] messages;
    private final Object LOCK = new Object();
    private LinkButton btnFetch20;
    private LinkButton btnFetch50;
    private LinkButton btnFetchAll;
    private ChangesetPanel changesetPanel1;
    protected final JLabel jLabel1 = new JLabel();
    protected final JLabel jLabel2 = new JLabel();
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel panelSearchOptions;
    private JList revisionsComboBox;
    protected JLabel revisionsLabel;
    private JTextField txtFilter;

    public ChangesetPickerPanel(File repo, File[] files) {
        this.repository = repo;
        this.roots = files;
        this.initComponents();
        this.jPanel1.setVisible(false);
        this.revisionsComboBox.setCellRenderer(new RevisionRenderer());
        this.defaultMessageInfoFetcher = new MessageInfoFetcher();
        this.filterTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesetPickerPanel.this.filterTimer.stop();
                ChangesetPickerPanel.this.applyFilter();
            }
        });
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ChangesetPickerPanel.this.bGettingRevisions) {
                    ChangesetPickerPanel.this.filterTimer.restart();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ChangesetPickerPanel.this.bGettingRevisions) {
                    ChangesetPickerPanel.this.filterTimer.restart();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public File[] getRootFiles() {
        return this.roots;
    }

    public HgLogMessage getSelectedRevision() {
        HgLogMessage rev = (HgLogMessage)this.revisionsComboBox.getSelectedValue();
        return rev;
    }

    protected String getRefreshLabel() {
        return NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Refreshing_Revisions");
    }

    protected HgLogMessage getDisplayedRevision() {
        return null;
    }

    protected void loadRevisions() {
        this.initialProgressSupport = new InitialLoadingProgressSupport();
        this.initialProgressSupport.start(rp, this.repository, this.getRefreshLabel());
    }

    protected void setOptionsPanel(JPanel optionsPanel, Border parentPanelBorder) {
        if (optionsPanel == null) {
            this.jPanel1.setVisible(false);
        } else {
            if (parentPanelBorder != null) {
                this.jPanel1.setBorder(parentPanelBorder);
            }
            this.jPanel1.removeAll();
            this.jPanel1.add((Component)optionsPanel, "North");
            this.jPanel1.setVisible(true);
        }
    }

    protected String getRevisionLabel(RepositoryRevision rev) {
        return rev.getLog().getRevisionNumber() + " (" + rev.getLog().getCSetShortID() + ")";
    }

    protected void setInitMessageInfoFetcher(MessageInfoFetcher fetcher) {
        this.messageInfofetcher = fetcher;
    }

    @Override
    public void removeNotify() {
        HgProgressSupport supp = this.initialProgressSupport;
        if (supp != null) {
            supp.cancel();
        }
        if ((supp = this.hgProgressSupport) != null) {
            supp.cancel();
        }
        super.removeNotify();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.changesetPanel1 = new ChangesetPanel();
        this.jPanel2 = new JPanel();
        this.revisionsLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.revisionsComboBox = new JList();
        this.panelSearchOptions = new JPanel();
        this.jLabel5 = new JLabel();
        this.btnFetchAll = new LinkButton();
        this.btnFetch50 = new LinkButton();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.btnFetch20 = new LinkButton();
        this.jLabel6 = new JLabel();
        this.txtFilter = new JTextField();
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.75);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.options")));
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changesetPanel1, -1, 405, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 405, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.changesetPanel1, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.jSplitPane1.setBottomComponent(this.jPanel3);
        Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.revisionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, null);
        this.jLabel2.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, null);
        this.revisionsComboBox.setSelectionMode(0);
        this.revisionsComboBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ChangesetPickerPanel.this.revisionsComboBoxValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.revisionsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFetchAll, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetchAll.text"));
        this.btnFetchAll.setToolTipText(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetchAll.toolTipText"));
        this.btnFetchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangesetPickerPanel.this.btnFetchAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnFetch50, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetch50.text"));
        this.btnFetch50.setToolTipText(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetch50.toolTipText"));
        this.btnFetch50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangesetPickerPanel.this.btnFetch50ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)"|");
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFetch20, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetch20.text"));
        this.btnFetch20.setToolTipText(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.btnFetch20.toolTipText"));
        this.btnFetch20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangesetPickerPanel.this.btnFetch20ActionPerformed(evt);
            }
        });
        this.jLabel6.setLabelFor(this.txtFilter);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.jLabel6.text"));
        this.jLabel6.setToolTipText(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.jLabel6.toolTipText"));
        this.txtFilter.setText(NbBundle.getMessage(ChangesetPickerPanel.class, (String)"ChangesetPickerPanel.txtFilter.text"));
        GroupLayout panelSearchOptionsLayout = new GroupLayout(this.panelSearchOptions);
        this.panelSearchOptions.setLayout(panelSearchOptionsLayout);
        panelSearchOptionsLayout.setHorizontalGroup(panelSearchOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchOptionsLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(5, 5, 5).addComponent((Component)this.btnFetch20, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel4).addGap(5, 5, 5).addComponent((Component)this.btnFetch50, -2, -1, -2).addGap(5, 5, 5).addComponent(this.jLabel5).addGap(5, 5, 5).addComponent((Component)this.btnFetchAll, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFilter, -1, 202, Short.MAX_VALUE)));
        panelSearchOptionsLayout.setVerticalGroup(panelSearchOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSearchOptionsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelSearchOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.btnFetch20, -2, -1, -2).addComponent(this.jLabel4).addComponent((Component)this.btnFetch50, -2, -1, -2).addComponent(this.jLabel5).addComponent((Component)this.btnFetchAll, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.txtFilter, -2, -1, -2)).addGap(0, 0, 0)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -1, 393, Short.MAX_VALUE).addGap(24, 24, 24)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.revisionsLabel).addContainerGap(249, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelSearchOptions, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 405, Short.MAX_VALUE)).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.revisionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 125, Short.MAX_VALUE).addGap(8, 8, 8).addComponent(this.panelSearchOptions, -2, -1, -2).addContainerGap()));
        this.jSplitPane1.setTopComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 429, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 481, Short.MAX_VALUE));
    }

    private void revisionsComboBoxValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            HgLogMessage rev = (HgLogMessage)this.revisionsComboBox.getSelectedValue();
            boolean oldValid = this.validSelection;
            this.validSelection = this.acceptSelection(rev);
            if (oldValid != this.validSelection) {
                this.firePropertyChange(PROP_VALID, oldValid, this.validSelection);
            }
            if (this.validSelection) {
                this.changesetPanel1.setInfo(rev);
            }
        }
    }

    private void btnFetch20ActionPerformed(ActionEvent evt) {
        this.getMore(20);
    }

    private void btnFetch50ActionPerformed(ActionEvent evt) {
        this.getMore(50);
    }

    private void btnFetchAllActionPerformed(ActionEvent evt) {
        this.getMore(-1);
    }

    private boolean getMore(int limit) {
        if (this.bGettingRevisions) {
            return false;
        }
        if (limit == -1) {
            this.btnFetchAll.setEnabled(false);
            this.btnFetch50.setEnabled(false);
            this.btnFetch20.setEnabled(false);
        }
        this.messageInfofetcher = this.defaultMessageInfoFetcher;
        this.fetchRevisionLimit = limit;
        if (limit > 0 && this.messages != null) {
            this.fetchRevisionLimit += this.messages.length;
        }
        this.filterTimer.stop();
        this.hgProgressSupport = new HgProgressSupport(){

            @Override
            public void perform() {
                ChangesetPickerPanel.this.refreshRevisions(this);
                ChangesetPickerPanel.this.hgProgressSupport = null;
            }
        };
        this.hgProgressSupport.start(rp, this.repository, NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Fetching_Revisions"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshRevisions(HgProgressSupport supp) {
        this.bGettingRevisions = true;
        OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
        MessageInfoFetcher fetcher = this.getMessageInfoFetcher();
        HgLogMessage[] fetchedMessages = fetcher.getMessageInfo(this.repository, (Set<File>)(this.roots == null ? null : new HashSet<File>(Arrays.asList(this.roots))), this.fetchRevisionLimit, logger);
        if (!supp.isCanceled() && fetchedMessages.length > 0) {
            WorkingCopyInfo wcInfo = WorkingCopyInfo.getInstance(this.repository);
            wcInfo.refresh();
            HgLogMessage[] parents = wcInfo.getWorkingCopyParents();
            if (parents.length > 0) {
                this.parentRevision = parents[0];
            }
        }
        if (!supp.isCanceled()) {
            if (fetchedMessages == null || fetchedMessages.length == 0) {
                fetchedMessages = new HgLogMessage[]{NO_REVISION};
            } else if (this.parentRevision != null && this.acceptSelection(this.parentRevision)) {
                boolean containsParent = false;
                for (HgLogMessage msg : fetchedMessages) {
                    if (!msg.getCSetShortID().equals(this.parentRevision.getCSetShortID())) continue;
                    containsParent = true;
                    break;
                }
                if (!containsParent) {
                    fetchedMessages = Arrays.copyOf(fetchedMessages, fetchedMessages.length + 1);
                    fetchedMessages[fetchedMessages.length - 1] = this.parentRevision;
                }
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.messages = fetchedMessages;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ChangesetPickerPanel.this.fetchRevisionLimit > ChangesetPickerPanel.this.messages.length && ChangesetPickerPanel.this.messageInfofetcher == ChangesetPickerPanel.this.defaultMessageInfoFetcher) {
                        ChangesetPickerPanel.this.btnFetch20.setEnabled(false);
                        ChangesetPickerPanel.this.btnFetch50.setEnabled(false);
                        ChangesetPickerPanel.this.btnFetchAll.setEnabled(false);
                    }
                    ChangesetPickerPanel.this.applyFilter();
                    ChangesetPickerPanel.this.bGettingRevisions = false;
                }
            });
        }
    }

    private MessageInfoFetcher getMessageInfoFetcher() {
        MessageInfoFetcher f = this.messageInfofetcher;
        if (f == null) {
            f = this.defaultMessageInfoFetcher;
        }
        return f;
    }

    protected boolean acceptSelection(HgLogMessage rev) {
        return rev != null;
    }

    protected final HgLogMessage.HgRevision getParentRevision() {
        return this.parentRevision == null ? null : this.parentRevision.getHgRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter() {
        HgLogMessage selectedRevision = this.getSelectedRevision();
        DefaultListModel<HgLogMessage> targetsModel = new DefaultListModel<HgLogMessage>();
        targetsModel.removeAllElements();
        HgLogMessage toSelectRevision = null;
        String filter = this.txtFilter.getText();
        Object object = this.LOCK;
        synchronized (object) {
            for (HgLogMessage message : this.messages) {
                if (!this.applies(filter, message)) continue;
                if (selectedRevision != null && message.getCSetShortID().equals(selectedRevision.getCSetShortID())) {
                    toSelectRevision = message;
                } else if (this.parentRevision != null && message.getCSetShortID().equals(this.parentRevision.getCSetShortID())) {
                    toSelectRevision = message;
                }
                targetsModel.addElement(message);
            }
        }
        if (!Arrays.equals(targetsModel.toArray(), ((DefaultListModel)this.revisionsComboBox.getModel()).toArray())) {
            this.revisionsComboBox.setModel(targetsModel);
            if (toSelectRevision != null) {
                this.revisionsComboBox.setSelectedValue(toSelectRevision, true);
            } else if (targetsModel.size() > 0) {
                this.revisionsComboBox.setSelectedIndex(0);
            }
        }
    }

    private boolean applies(String filter, HgLogMessage message) {
        boolean applies = filter.isEmpty();
        filter = filter.toLowerCase();
        if (!applies && (message.getRevisionNumber().contains(filter) || message.getAuthor().toLowerCase().contains(filter) || message.getCSetShortID().toLowerCase().contains(filter) || message.getMessage().toLowerCase().contains(filter) || message.getUsername().toLowerCase().contains(filter) || this.applies(filter, message.getBranches()) || this.applies(filter, message.getTags()) || DateFormat.getDateTimeInstance().format(message.getDate()).toLowerCase().contains(filter))) {
            applies = true;
        }
        return applies;
    }

    private boolean applies(String format, String[] array) {
        for (String v : array) {
            if (!v.toLowerCase().contains(format)) continue;
            return true;
        }
        return false;
    }

    private class RevisionRenderer
    extends DefaultListCellRenderer {
        private RevisionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof HgLogMessage) {
                HgLogMessage message = (HgLogMessage)value;
                if (message == TIP || message == NO_REVISION) {
                    value = message.getCSetShortID();
                } else {
                    StringBuilder sb = new StringBuilder().append(message.getRevisionNumber());
                    HgLogMessage parent = ChangesetPickerPanel.this.parentRevision;
                    if (parent != null && parent.getRevisionNumber().equals(message.getRevisionNumber())) {
                        sb.append(ChangesetPickerPanel.MARK_ACTIVE_HEAD);
                    }
                    StringBuilder labels = new StringBuilder();
                    for (String branch : message.getBranches()) {
                        labels.append(branch).append(' ');
                    }
                    int i$ = 0;
                    String[] arr$ = message.getTags();
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        String tag = arr$[i$];
                        labels.append(tag).append(' ');
                    }
                    sb.append(" (").append((CharSequence)labels).append(labels.length() == 0 ? "" : "- ").append(message.getCSetShortID().substring(0, 7)).append(")");
                    value = sb.toString();
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    protected static class MessageInfoFetcher {
        protected MessageInfoFetcher() {
        }

        protected HgLogMessage[] getMessageInfo(File repository, Set<File> setRoots, int fetchRevisionLimit, OutputLogger logger) {
            return HgCommand.getLogMessagesNoFileInfo(repository, setRoots, fetchRevisionLimit, logger);
        }
    }

    private class InitialLoadingProgressSupport
    extends HgProgressSupport {
        private InitialLoadingProgressSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform() {
            try {
                final DefaultListModel<HgLogMessage> targetsModel = new DefaultListModel<HgLogMessage>();
                final HgLogMessage displayedRevision = ChangesetPickerPanel.this.getDisplayedRevision();
                if (displayedRevision == null) {
                    if (ChangesetPickerPanel.this.acceptSelection(NO_REVISION)) {
                        targetsModel.addElement(NO_REVISION);
                    }
                    if (ChangesetPickerPanel.this.acceptSelection(TIP)) {
                        targetsModel.addElement(TIP);
                    }
                } else {
                    targetsModel.addElement(displayedRevision);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesetPickerPanel.this.revisionsComboBox.setModel(targetsModel);
                        if (!targetsModel.isEmpty()) {
                            ChangesetPickerPanel.this.revisionsComboBox.setSelectedIndex(0);
                        }
                    }
                });
                if (displayedRevision == null) {
                    ChangesetPickerPanel.this.refreshRevisions(this);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChangesetPickerPanel.this.revisionsComboBox.setSelectedValue(displayedRevision, true);
                            ChangesetPickerPanel.this.revisionsComboBox.setEnabled(false);
                            ChangesetPickerPanel.this.panelSearchOptions.setVisible(false);
                        }
                    });
                }
            }
            finally {
                ChangesetPickerPanel.this.initialProgressSupport = null;
            }
        }
    }
}

