/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ExportDiffChangesAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(ExportDiffChangesAction.class.getName());

    @Override
    protected boolean enable(Node[] nodes) {
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            return true;
        }
        VCSContext context = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        return Lookup.getDefault().lookup(DiffProvider.class) != null;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ExportDiffChanges";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        this.performContextAction(nodes, false);
    }

    void performContextAction(Node[] nodes, final boolean singleDiffSetup) {
        File[] roots;
        boolean noop;
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        TopComponent activated = TopComponent.getRegistry().getActivated();
        Collection setups = null;
        if (activated instanceof DiffSetupSource) {
            setups = ((DiffSetupSource)activated).getSetups();
            noop = setups.isEmpty();
        } else {
            File[] files = HgUtils.getModifiedFiles(context, 6612, false);
            boolean bl = noop = files.length == 0;
        }
        if (noop) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3001"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        File[] fileArray = roots = setups == null ? HgUtils.getActionRoots(context) : this.getRoots(setups);
        if (roots == null || roots.length == 0) {
            LOG.log(Level.INFO, "Null roots for {0}", context.getRootFiles());
            return;
        }
        File contextFile = roots[0];
        final File root = Mercurial.getInstance().getRepositoryRoot(contextFile);
        ExportDiffSupport exportDiffSupport = new ExportDiffSupport(new File[]{contextFile}, HgModuleConfig.getDefault().getPreferences()){

            public void writeDiffFile(final File toFile) {
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport ps = new HgProgressSupport(){

                    @Override
                    protected void perform() {
                        ExportDiffChangesAction.this.async(this, root, context, toFile, singleDiffSetup);
                    }
                };
                ps.start(rp, root, NbBundle.getMessage(ExportDiffChangesAction.class, (String)"LBL_ExportChanges_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    private void async(HgProgressSupport progress, File root, VCSContext context, File destination, boolean singleDiffSetup) {
        ArrayList<Setup> setups;
        Mercurial hg = Mercurial.getInstance();
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            if (!singleDiffSetup) {
                setups = new ArrayList(((DiffSetupSource)activated).getSetups());
            } else {
                DiffNode node = (DiffNode)((Object)context.getElements().lookup(DiffNode.class));
                if (node != null) {
                    setups = new ArrayList<Setup>(Collections.singletonList(node.getSetup()));
                } else {
                    LOG.log(Level.INFO, "No DiffNode in the context: {0}", new Object[]{context.getElements().lookup(Object.class)});
                    return;
                }
            }
            Iterator i = setups.iterator();
            while (i.hasNext()) {
                Setup setup = (Setup)((Object)i.next());
                File file = setup.getBaseFile();
                if (root.equals(hg.getRepositoryRoot(file))) continue;
                i.remove();
            }
        } else {
            File[] files = HgUtils.getModifiedFiles(context, 6612, false);
            setups = new ArrayList(files.length);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!root.equals(hg.getRepositoryRoot(file))) continue;
                Mercurial.LOG.log(Level.FINE, "preparing setup {0}", file);
                Setup setup = new Setup(file, null, 0);
                Mercurial.LOG.log(Level.FINE, "setup prepared {0}", setup.getBaseFile());
                setups.add(setup);
            }
        }
        this.exportDiff(setups, destination, root, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDiff(List<Setup> setups, File destination, File root, HgProgressSupport progress) {
        boolean success = false;
        OutputStream out = null;
        int exportedFiles = 0;
        OutputLogger logger = progress.getLogger();
        try {
            if (root == null) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_BadSelection_Prompt"), NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_BadSelection_Title"), -1, 0, null, null);
                DialogDisplayer.getDefault().notify(nd);
                return;
            }
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES", (Object)destination));
            String sep = System.getProperty("line.separator");
            this.ensureParentExists(destination);
            out = new BufferedOutputStream(new FileOutputStream(destination));
            out.write(("# This patch file was generated by NetBeans IDE" + sep).getBytes("utf8"));
            out.write(("# Following Index: paths are relative to: " + root.getAbsolutePath() + sep).getBytes("utf8"));
            out.write(("# This patch can be applied using context Tools: Patch action on respective folder." + sep).getBytes("utf8"));
            out.write(("# It uses platform neutral UTF-8 encoding and \\n newlines." + sep).getBytes("utf8"));
            out.write(("# Above lines and this line are ignored by the patching process." + sep).getBytes("utf8"));
            Collections.sort(setups, new Comparator<Setup>(){

                @Override
                public int compare(Setup o1, Setup o2) {
                    return o1.getBaseFile().compareTo(o2.getBaseFile());
                }
            });
            Iterator<Setup> it = setups.iterator();
            int i = 0;
            while (it.hasNext()) {
                String filePath;
                Setup setup = it.next();
                File file = setup.getBaseFile();
                Mercurial.LOG.log(Level.FINE, "exporting setup {0}", file.getName());
                logger.output(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_Export_Changes_Exporting", (Object)file.getName()));
                if (file.isDirectory()) continue;
                progress.setDisplayName(file.getName());
                String index = "Index: ";
                String rootPath = root.getAbsolutePath();
                String relativePath = filePath = file.getAbsolutePath();
                if (filePath.startsWith(rootPath)) {
                    relativePath = filePath.substring(rootPath.length() + 1).replace(File.separatorChar, '/');
                    index = index + relativePath + sep;
                    out.write(index.getBytes("utf8"));
                }
                this.exportDiff(setup, relativePath, out);
                ++i;
            }
            exportedFiles = i;
            success = true;
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_DONE"));
        }
        catch (IOException ex) {
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3003"));
            Mercurial.LOG.log(Level.INFO, NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3003"), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException alreadyClosed) {}
            }
            if (success) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3004", (Object)new Integer(exportedFiles)));
                if (exportedFiles == 0) {
                    destination.delete();
                } else {
                    Utils.openFile((File)destination);
                }
            } else {
                destination.delete();
            }
            logger.output("");
        }
    }

    private static File getCommonParent(File[] files) {
        File root = files[0];
        if (root.isFile()) {
            root = root.getParentFile();
        }
        for (int i = 1; i < files.length; ++i) {
            if ((root = Utils.getCommonParent((File)root, (File)files[i])) != null) continue;
            return null;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDiff(Setup setup, String relativePath, OutputStream out) throws IOException {
        Difference[] differences;
        setup.initSources();
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader r1 = null;
        Reader r2 = null;
        try {
            r1 = setup.getFirstSource().createReader();
            if (r1 == null) {
                r1 = new StringReader("");
            }
            if ((r2 = setup.getSecondSource().createReader()) == null) {
                r2 = new StringReader("");
            }
            differences = diff.computeDiff(r1, r2);
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception e) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            int i;
            r1 = setup.getFirstSource().createReader();
            if (r1 == null) {
                r1 = new StringReader("");
            }
            if ((r2 = setup.getSecondSource().createReader()) == null) {
                r2 = new StringReader("");
            }
            TextDiffVisualizer.TextDiffInfo info = new TextDiffVisualizer.TextDiffInfo(relativePath + " " + setup.getFirstSource().getTitle(), relativePath + " " + setup.getSecondSource().getTitle(), null, null, r1, r2, differences);
            info.setContextMode(true, 3);
            String diffText = TextDiffVisualizer.differenceToUnifiedDiffText((TextDiffVisualizer.TextDiffInfo)info);
            ByteArrayInputStream is = new ByteArrayInputStream(diffText.getBytes("utf8"));
            while ((i = ((InputStream)is).read()) != -1) {
                out.write(i);
            }
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception e) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void ensureParentExists(File destination) {
        File parent = destination.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private File[] getRoots(Collection<Setup> setups) {
        HashSet<File> roots = new HashSet<File>(setups.size());
        for (Setup setup : setups) {
            File f = setup.getBaseFile();
            if (f == null) continue;
            roots.add(f);
        }
        return roots.toArray(new File[roots.size()]);
    }
}

