/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.options.MercurialOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class MercurialPanel
extends JPanel {
    private final MercurialOptionsPanelController controller;
    private final DocumentListener listener;
    private String initialUserName;
    final JButton addButton = new JButton();
    final JTextField annotationTextField = new JTextField();
    private JCheckBox backupOnRevertModifications;
    private JCheckBox cbAskBeforeCommitAfterMerge;
    private JCheckBox cbInternalMergeToolEnabled;
    private JCheckBox cbOpenOutputWindow;
    final JCheckBox excludeNewFiles = new JCheckBox();
    final JButton execPathBrowseButton = new JButton();
    final JTextField executablePathTextField = new JTextField();
    private JLabel exportFilename;
    final JButton exportFilenameBrowseButton = new JButton();
    final JTextField exportFilenameTextField = new JTextField();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextPane jTextPane1;
    final JButton manageButton = new JButton();
    final JTextField userNameTextField = new JTextField();

    MercurialPanel(MercurialOptionsPanelController controller) {
        this.controller = controller;
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }
        };
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.userNameTextField.getDocument().addDocumentListener(this.listener);
    }

    @Override
    public void removeNotify() {
        this.userNameTextField.getDocument().removeDocumentListener(this.listener);
        super.removeNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.exportFilename = new JLabel();
        this.backupOnRevertModifications = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextPane1 = new JTextPane();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.cbOpenOutputWindow = new JCheckBox();
        this.cbAskBeforeCommitAfterMerge = new JCheckBox();
        this.cbInternalMergeToolEnabled = new JCheckBox();
        this.jLabel1.setLabelFor(this.userNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.executablePathTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.execPathBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton.text"));
        this.exportFilename.setLabelFor(this.exportFilenameTextField);
        Mnemonics.setLocalizedText((JLabel)this.exportFilename, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.ExportFilename.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportFilenameBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton2.text"));
        this.backupOnRevertModifications.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.backupOnRevertModifications, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jCheckBox1.text"));
        this.backupOnRevertModifications.setBorder(null);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel5.text"));
        this.jLabel3.setLabelFor(this.annotationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.addButton.text"));
        this.annotationTextField.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.manageButton.text"));
        this.jTextPane1.setBackground(this.jLabel1.getBackground());
        this.jTextPane1.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jTextPane1.text"));
        this.cbOpenOutputWindow.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenOutputWindow, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbOpenOutputWindow.text"));
        this.cbOpenOutputWindow.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
        this.cbOpenOutputWindow.setBorder(null);
        this.cbAskBeforeCommitAfterMerge.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAskBeforeCommitAfterMerge, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.text"));
        this.cbAskBeforeCommitAfterMerge.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.toolTipText"));
        this.cbAskBeforeCommitAfterMerge.setBorder(null);
        this.cbInternalMergeToolEnabled.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbInternalMergeToolEnabled, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.text"));
        this.cbInternalMergeToolEnabled.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.toolTipText"));
        this.cbInternalMergeToolEnabled.setBorder(null);
        Mnemonics.setLocalizedText((AbstractButton)this.excludeNewFiles, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.text"));
        this.excludeNewFiles.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.toolTipText"));
        this.excludeNewFiles.setBorder(null);
        this.excludeNewFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MercurialPanel.this.excludeNewFilesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -1, 349, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -1, 328, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.exportFilename)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exportFilenameTextField, GroupLayout.Alignment.LEADING, -1, 183, Short.MAX_VALUE).addComponent(this.userNameTextField, GroupLayout.Alignment.LEADING, -1, 183, Short.MAX_VALUE).addComponent(this.executablePathTextField, GroupLayout.Alignment.LEADING, -1, 183, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportFilenameBrowseButton).addComponent(this.execPathBrowseButton))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextPane1, -1, 321, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annotationTextField, -1, 261, Short.MAX_VALUE).addGap(2, 2, 2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.manageButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addGap(0, 0, 0)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backupOnRevertModifications).addComponent(this.cbOpenOutputWindow).addComponent(this.cbAskBeforeCommitAfterMerge)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbInternalMergeToolEnabled).addContainerGap(147, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.excludeNewFiles).addContainerGap(79, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.userNameTextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.executablePathTextField, -2, -1, -2).addComponent(this.execPathBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportFilename).addComponent(this.exportFilenameTextField, -2, -1, -2).addComponent(this.exportFilenameBrowseButton)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jSeparator1, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.annotationTextField, -2, -1, -2).addComponent(this.addButton)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jSeparator2, -2, 11, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manageButton).addComponent(this.jTextPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupOnRevertModifications).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbOpenOutputWindow).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAskBeforeCommitAfterMerge).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbInternalMergeToolEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excludeNewFiles).addContainerGap(23, Short.MAX_VALUE)));
        this.userNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_userNameTextField"));
        this.executablePathTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_executablePathTextField"));
        this.execPathBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_execPathBrowseButton"));
        this.exportFilenameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFileNameTextField"));
        this.exportFilenameBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFilenameBrowseButton"));
        this.backupOnRevertModifications.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_backupOnRevertModifications"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_addButton"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_manageButton"));
        this.cbOpenOutputWindow.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
    }

    private void excludeNewFilesActionPerformed(ActionEvent evt) {
    }

    private void nameChange() {
        this.controller.changed();
    }

    void load() {
        this.initialUserName = HgModuleConfig.getDefault().getSysUserName();
        this.userNameTextField.setText(this.initialUserName);
        this.executablePathTextField.setText(HgModuleConfig.getDefault().getExecutableBinaryPath());
        this.exportFilenameTextField.setText(HgModuleConfig.getDefault().getExportFilename());
        this.annotationTextField.setText(HgModuleConfig.getDefault().getAnnotationFormat());
        this.backupOnRevertModifications.setSelected(HgModuleConfig.getDefault().getBackupOnRevertModifications());
        this.cbOpenOutputWindow.setSelected(HgModuleConfig.getDefault().getAutoOpenOutput());
        this.cbAskBeforeCommitAfterMerge.setSelected(HgModuleConfig.getDefault().getConfirmCommitAfterMerge());
        this.cbInternalMergeToolEnabled.setSelected(HgModuleConfig.getDefault().isInternalMergeToolEnabled());
        this.excludeNewFiles.setSelected(HgModuleConfig.getDefault().getExludeNewFiles());
    }

    void store() {
        if (!this.initialUserName.equals(this.userNameTextField.getText())) {
            try {
                HgModuleConfig.getDefault().setUserName(this.userNameTextField.getText());
            }
            catch (IOException ex) {
                HgModuleConfig.notifyParsingError();
            }
        }
        HgModuleConfig.getDefault().setExecutableBinaryPath(this.executablePathTextField.getText());
        Mercurial.getInstance().asyncInit();
        HgModuleConfig.getDefault().setExportFilename(this.exportFilenameTextField.getText());
        HgModuleConfig.getDefault().setAnnotationFormat(this.annotationTextField.getText());
        HgModuleConfig.getDefault().setBackupOnRevertModifications(this.backupOnRevertModifications.isSelected());
        HgModuleConfig.getDefault().setAutoOpenOutput(this.cbOpenOutputWindow.isSelected());
        HgModuleConfig.getDefault().setConfirmCommitAfterMerge(this.cbAskBeforeCommitAfterMerge.isSelected());
        HgModuleConfig.getDefault().setInternalMergeToolEnabled(this.cbInternalMergeToolEnabled.isSelected());
        HgModuleConfig.getDefault().setExcludeNewFiles(this.excludeNewFiles.isSelected());
    }

    boolean valid() {
        String username = this.userNameTextField.getText();
        Boolean valid = HgModuleConfig.getDefault().isUserNameValid(username);
        if (!valid.booleanValue()) {
            return false;
        }
        String execpath = this.executablePathTextField.getText();
        valid = HgModuleConfig.getDefault().isExecPathValid(execpath);
        return valid;
    }
}

