/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;

public class MercurialVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener {
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File a, File b) {
            File fra = MercurialVCS.this.getTopmostManagedAncestor(a);
            File frb = MercurialVCS.this.getTopmostManagedAncestor(b);
            return fra != null && fra.equals(frb);
        }

        public File findRoot(File file) {
            return MercurialVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public MercurialVCS() {
        this.putProperty("String VCS.DisplayName", MercurialVCS.getDisplayName());
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_MainMenu"));
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        Mercurial.getInstance().register(this);
    }

    public static String getDisplayName() {
        return NbBundle.getMessage(MercurialVCS.class, (String)"CTL_Mercurial_DisplayName");
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public File getTopmostManagedAncestor(File file) {
        return Mercurial.getInstance().getTopmostManagedAncestor(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return Mercurial.getInstance().getMercurialAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Mercurial.getInstance().getMercurialInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        Mercurial.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (event.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)event.getNewValue());
        } else if (event.getPropertyName().equals("versionedFilesChanged")) {
            Mercurial.LOG.fine("cleaning unversioned parents cache");
            Mercurial.getInstance().clearAncestorCaches();
            this.fireVersionedFilesChanged();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }
}

