/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.lib2.view.DocumentView;

public class FoldToolTip
extends JPanel {
    private JEditorPane foldPreviewPane;
    private int editorPaneWidth;

    public FoldToolTip(JEditorPane editorPane, final JEditorPane foldPreviewPane) {
        this.foldPreviewPane = foldPreviewPane;
        this.setLayout(new BorderLayout());
        this.add((Component)foldPreviewPane, "Center");
        this.putClientProperty("tooltip-type", "fold-preview");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                final DocumentView docView = DocumentView.get((JTextComponent)foldPreviewPane);
                if (docView != null) {
                    docView.runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            docView.updateLengthyAtomicEdit(100);
                        }
                    });
                }
                FoldToolTip.this.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.editorPaneWidth = editorPane.getSize().width;
        Color foreColor = this.foldPreviewPane.getForeground();
        this.setBorder(new LineBorder(foreColor));
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width = Math.min(prefSize.width, this.editorPaneWidth);
        return prefSize;
    }
}

