/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.utils;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitBranch;

public class Utils {
    private static final String REF_SPEC_PATTERN = "+refs/heads/{0}:refs/remotes/{1}/{0}";
    private static final String REF_PUSHSPEC_PATTERN = "+refs/heads/{0}:refs/heads/{1}";
    private static final String REF_TAG_PUSHSPEC_PATTERN = "+refs/tags/{0}:refs/tags/{0}";

    private Utils() {
    }

    public static String getRefSpec(GitBranch branch, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branch.getName(), remoteName);
    }

    public static String getRefSpec(String branchName, String remoteName) {
        return MessageFormat.format(REF_SPEC_PATTERN, branchName, remoteName);
    }

    public static String getPushRefSpec(String branchName, String remoteRepositoryBranchName) {
        return MessageFormat.format(REF_PUSHSPEC_PATTERN, branchName, remoteRepositoryBranchName);
    }

    public static String getPushTagRefSpec(String tagName) {
        return MessageFormat.format(REF_TAG_PUSHSPEC_PATTERN, tagName);
    }
}

