/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.index;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public class CheckoutIndex {
    private final Repository repository;
    private final DirCache cache;
    private final File[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final boolean checkContent;
    private final boolean recursively;

    public CheckoutIndex(Repository repository, DirCache cache, File[] roots, boolean recursively, FileListener listener, ProgressMonitor monitor, boolean checkContent) {
        this.repository = repository;
        this.cache = cache;
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.checkContent = checkContent;
        this.recursively = recursively;
    }

    public void checkout() throws IOException, GitException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        List<String> relativePaths = Utils.getRelativePaths(this.repository.getWorkTree(), this.roots);
        if (!relativePaths.isEmpty()) {
            treeWalk.setFilter(PathFilterGroup.createFromStrings(relativePaths));
        }
        treeWalk.setRecursive(true);
        treeWalk.reset();
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(this.cache));
        treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repository));
        String lastAddedPath = null;
        while (treeWalk.next() && !this.monitor.isCanceled()) {
            File path = new File(this.repository.getWorkTree(), treeWalk.getPathString());
            if (treeWalk.getPathString().equals(lastAddedPath)) continue;
            lastAddedPath = treeWalk.getPathString();
            DirCacheIterator dit = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
            FileTreeIterator fit = (FileTreeIterator)treeWalk.getTree(1, FileTreeIterator.class);
            if (dit == null || !this.recursively && !this.directChild(this.roots, this.repository.getWorkTree(), path) || fit != null && !fit.isModified(dit.getDirCacheEntry(), this.checkContent)) continue;
            this.listener.notifyFile(path, treeWalk.getPathString());
            this.checkoutEntry(this.repository, path, dit.getDirCacheEntry());
        }
    }

    public void checkoutEntry(Repository repository, File file, DirCacheEntry e) throws IOException, GitException {
        if (!this.ensureParentFolderExists(file.getParentFile())) {
            return;
        }
        boolean exists = file.exists();
        if (exists && e.getFileMode() == FileMode.SYMLINK) {
            this.monitor.notifyWarning(NbBundle.getMessage(CheckoutIndex.class, (String)"MSG_Warning_SymLink", (Object)file.getAbsolutePath()));
            return;
        }
        if (exists && file.isDirectory()) {
            this.monitor.notifyWarning(NbBundle.getMessage(CheckoutIndex.class, (String)"MSG_Warning_ReplacingDirectory", (Object)file.getAbsolutePath()));
            Utils.deleteRecursively(file);
        }
        file.createNewFile();
        if (file.isFile()) {
            DirCacheCheckout.checkoutEntry((Repository)repository, (File)file, (DirCacheEntry)e);
        } else {
            this.monitor.notifyError(NbBundle.getMessage(CheckoutIndex.class, (String)"MSG_Warning_CannotCreateFile", (Object)file.getAbsolutePath()));
        }
    }

    private boolean ensureParentFolderExists(File parentFolder) {
        File predecessor = parentFolder;
        while (!predecessor.exists()) {
            predecessor = predecessor.getParentFile();
        }
        if (predecessor.isFile()) {
            if (!predecessor.delete()) {
                this.monitor.notifyError(NbBundle.getMessage(CheckoutIndex.class, (String)"MSG_Warning_CannotCreateFile", (Object)predecessor.getAbsolutePath()));
                return false;
            }
            this.monitor.notifyWarning(NbBundle.getMessage(CheckoutIndex.class, (String)"MSG_Warning_ReplacingFile", (Object)predecessor.getAbsolutePath()));
        }
        return parentFolder.mkdirs() || parentFolder.exists();
    }

    private boolean directChild(File[] roots, File workTree, File path) {
        if (roots.length == 0) {
            roots = new File[]{workTree};
        }
        for (File parent : roots) {
            if (!parent.equals(path) && !parent.equals(path.getParentFile())) continue;
            return true;
        }
        return false;
    }
}

