/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import com.jcraft.jsch.JSchException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class TransportCommand
extends GitCommand {
    private CredentialsProvider credentialsProvider;
    private final String remote;

    public TransportCommand(Repository repository, String remote, ProgressMonitor monitor) {
        super(repository, monitor);
        this.remote = remote;
    }

    protected final URIish getUri(boolean pushUri) throws URISyntaxException {
        List uris;
        RemoteConfig config = this.getRemoteConfig();
        if (config == null) {
            uris = Collections.emptyList();
        } else if (pushUri) {
            uris = config.getPushURIs();
            if (uris.isEmpty()) {
                uris = config.getURIs();
            }
        } else {
            uris = config.getURIs();
        }
        if (uris.isEmpty()) {
            return new URIish(this.remote);
        }
        return (URIish)uris.get(0);
    }

    protected final URIish getUriWithUsername(boolean pushUri) throws URISyntaxException {
        URIish uri = this.getUri(pushUri);
        if (this.credentialsProvider != null) {
            CredentialItem.Username itm = new CredentialItem.Username();
            this.credentialsProvider.get(uri, new CredentialItem[]{itm});
            if (itm.getValue() != null) {
                uri = itm.getValue().isEmpty() ? uri.setUser(null) : uri.setUser(itm.getValue());
            }
        }
        return uri;
    }

    public final void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected final RemoteConfig getRemoteConfig() throws URISyntaxException {
        RemoteConfig config = new RemoteConfig((Config)this.getRepository().getConfig(), this.remote);
        if (config.getURIs().isEmpty() && config.getPushURIs().isEmpty()) {
            return null;
        }
        return config;
    }

    protected Transport openTransport(boolean openPush) throws URISyntaxException, NotSupportedException, TransportException {
        URIish uri = this.getUriWithUsername(openPush);
        for (TransportProtocol proto : Transport.getTransportProtocols()) {
            if (!proto.getSchemes().contains("ftp")) continue;
            Transport.unregister((TransportProtocol)proto);
        }
        Transport transport = Transport.open((Repository)this.getRepository(), (URIish)uri);
        RemoteConfig config = this.getRemoteConfig();
        if (config != null) {
            transport.applyConfig(config);
        }
        transport.setCredentialsProvider(this.getCredentialsProvider());
        return transport;
    }

    protected void handleException(TransportException e) throws GitException.AuthorizationException, GitException {
        String message = e.getMessage();
        int pos = message.indexOf(": " + JGitText.get().notAuthorized);
        if (pos != -1) {
            String repositoryUrl = message.substring(0, pos);
            throw new GitException.AuthorizationException(repositoryUrl, message, e);
        }
        if (message.contains(JGitText.get().notAuthorized)) {
            throw new GitException.AuthorizationException(message, e);
        }
        pos = message.toLowerCase().indexOf(": auth cancel");
        if (pos != -1) {
            String repositoryUrl = message.substring(0, pos);
            throw new GitException.AuthorizationException(repositoryUrl, message, e);
        }
        if (e.getCause() instanceof JSchException) {
            throw new GitException.AuthorizationException(message, e);
        }
        throw new GitException(e.getMessage(), e);
    }
}

