/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.jgit.JGitRevisionInfo;
import org.netbeans.libs.git.jgit.JGitTag;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListTagCommand
extends GitCommand {
    private Map<String, GitTag> allTags;
    private final boolean all;

    public ListTagCommand(Repository repository, boolean all, ProgressMonitor monitor) {
        super(repository, monitor);
        this.all = all;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        Map tags = repository.getTags();
        this.allTags = new HashMap<String, GitTag>(tags.size());
        RevWalk walk = new RevWalk(repository);
        try {
            for (Map.Entry e : tags.entrySet()) {
                JGitTag tag;
                try {
                    tag = new JGitTag(walk.parseTag((AnyObjectId)((Ref)e.getValue()).getLeaf().getObjectId()));
                }
                catch (IncorrectObjectTypeException ex) {
                    tag = new JGitTag((String)e.getKey(), new JGitRevisionInfo(walk.parseCommit((AnyObjectId)((Ref)e.getValue()).getLeaf().getObjectId()), repository));
                }
                if (!this.all && tag.getTaggedObjectType() != GitObjectType.COMMIT) continue;
                this.allTags.put(tag.getTagName(), tag);
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(ex.getObjectId().getName(), GitObjectType.TAG);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            walk.release();
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git tag -l";
    }

    public Map<String, GitTag> getTags() {
        return this.allTags;
    }
}

