/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.Transport;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.commands.TransportCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class ListRemoteObjectsCommand
extends TransportCommand {
    private Collection<Ref> refs;

    public ListRemoteObjectsCommand(Repository repository, String remoteRepositoryUrl, ProgressMonitor monitor) {
        super(repository, remoteRepositoryUrl, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void run() throws GitException {
        Transport t = null;
        FetchConnection conn = null;
        try {
            t = this.openTransport(false);
            conn = t.openFetch();
            this.refs = conn.getRefs();
        }
        catch (URISyntaxException ex) {
            throw new GitException(ex.getMessage(), ex);
        }
        catch (NotSupportedException ex) {
            throw new GitException(ex.getMessage(), ex);
        }
        catch (TransportException e) {
            this.handleException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (t != null) {
                t.close();
            }
        }
        this.processRefs();
    }

    protected abstract void processRefs();

    protected final Collection<Ref> getRefs() {
        return this.refs;
    }
}

