/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListModifiedIndexEntriesCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;
    private final Set<File> files;

    public ListModifiedIndexEntriesCommand(Repository repository, File[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.files = new HashSet<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.readDirCache();
            try {
                String workTreePath = repository.getWorkTree().getAbsolutePath();
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                TreeWalk treeWalk = new TreeWalk(repository);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(true);
                treeWalk.reset();
                ObjectId headId = repository.resolve("HEAD");
                if (headId != null) {
                    treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
                } else {
                    treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                boolean T_HEAD = false;
                boolean T_INDEX = true;
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    int mIndex;
                    String path = treeWalk.getPathString();
                    File file = new File(workTreePath + File.separator + path);
                    int mHead = treeWalk.getRawMode(0);
                    if (mHead == (mIndex = treeWalk.getRawMode(1)) && treeWalk.idEqual(0, 1)) continue;
                    this.files.add(file);
                    this.listener.notifyFile(file, path);
                }
            }
            finally {
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git status");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    public File[] getFiles() {
        return this.files.toArray(new File[this.files.size()]);
    }
}

