/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class AddCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public AddCommand(Repository repository, File[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git add");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = null;
            ObjectInserter inserter = repository.newObjectInserter();
            try {
                cache = repository.lockDirCache();
                DirCacheBuilder builder = cache.builder();
                TreeWalk treeWalk = new TreeWalk(repository);
                List<String> relativePaths = Utils.getRelativePaths(repository.getWorkTree(), this.roots);
                if (!relativePaths.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.createFromStrings(relativePaths));
                }
                treeWalk.setRecursive(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                String lastAddedFile = null;
                boolean checkExecutable = Utils.checkExecutable(repository);
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    WorkingTreeIterator f = (WorkingTreeIterator)treeWalk.getTree(1, WorkingTreeIterator.class);
                    if (treeWalk.getTree(0, DirCacheIterator.class) == null && f != null && f.isEntryIgnored() || path.equals(lastAddedFile)) continue;
                    if (f != null) {
                        File file = new File(repository.getWorkTree().getAbsolutePath() + File.separator + path);
                        long sz = f.getEntryLength();
                        DirCacheEntry entry = new DirCacheEntry(path);
                        entry.setLength(sz);
                        entry.setLastModified(f.getEntryLastModified());
                        int fm = f.getEntryFileMode().getBits();
                        if (!checkExecutable) {
                            fm &= 0xFFFFFFB6;
                        }
                        entry.setFileMode(FileMode.fromBits((int)fm));
                        InputStream in = f.openEntryStream();
                        try {
                            entry.setObjectId((AnyObjectId)inserter.insert(3, sz, in));
                        }
                        finally {
                            in.close();
                        }
                        DirCacheIterator it = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                        if (it == null || !it.getDirCacheEntry().getObjectId().equals((AnyObjectId)entry.getObjectId())) {
                            this.listener.notifyFile(file, path);
                        }
                        builder.add(entry);
                        lastAddedFile = path;
                        continue;
                    }
                    DirCacheIterator c = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
                    builder.add(c.getDirCacheEntry());
                }
                if (!this.monitor.isCanceled()) {
                    inserter.flush();
                    builder.commit();
                }
            }
            finally {
                inserter.release();
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }
}

