/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.jgit.JGitUserInfo;

public class JGitTag
implements GitTag {
    private final String id;
    private final String name;
    private final String message;
    private final String taggedObject;
    private final GitUser tagger;
    private final GitObjectType type;
    private boolean lightWeight;

    public JGitTag(RevTag revTag) {
        this.id = ObjectId.toString((ObjectId)revTag.getId());
        this.name = revTag.getTagName();
        this.message = revTag.getFullMessage();
        this.taggedObject = ObjectId.toString((ObjectId)revTag.getObject().getId());
        this.tagger = new JGitUserInfo(revTag.getTaggerIdent());
        this.type = this.getType(revTag.getObject());
        this.lightWeight = false;
    }

    public JGitTag(String tagName, RevObject revObject) {
        this.id = ObjectId.toString((ObjectId)revObject.getId());
        this.name = tagName;
        this.message = null;
        this.taggedObject = this.id;
        this.tagger = null;
        this.type = this.getType(revObject);
        this.lightWeight = true;
    }

    public JGitTag(String tagName, GitRevisionInfo revCommit) {
        this.id = revCommit.getRevision();
        this.name = tagName;
        this.message = revCommit.getFullMessage();
        this.taggedObject = this.id;
        this.tagger = revCommit.getAuthor() == null ? revCommit.getCommitter() : revCommit.getAuthor();
        this.type = GitObjectType.COMMIT;
        this.lightWeight = true;
    }

    @Override
    public String getTagId() {
        return this.id;
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    @Override
    public String getTaggedObjectId() {
        return this.taggedObject;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public GitUser getTagger() {
        return this.tagger;
    }

    @Override
    public GitObjectType getTaggedObjectType() {
        return this.type;
    }

    @Override
    public boolean isLightWeight() {
        return this.lightWeight;
    }

    private GitObjectType getType(RevObject object) {
        GitObjectType objType = GitObjectType.UNKNOWN;
        if (object != null) {
            switch (object.getType()) {
                case 1: {
                    objType = GitObjectType.COMMIT;
                    break;
                }
                case 3: {
                    objType = GitObjectType.BLOB;
                    break;
                }
                case 4: {
                    objType = GitObjectType.TAG;
                    break;
                }
                case 2: {
                    objType = GitObjectType.TREE;
                }
            }
        }
        return objType;
    }
}

