/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointXMLReader;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointXMLWriter;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Context;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTargetList;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.utils.UserdirFile;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.openide.ErrorManager;

public final class BreakpointBag {
    private final ArrayList<NativeBreakpoint> breakpoints = new ArrayList();
    private final DebugTargetList debugTargets = DebugTargetList.getInstance();
    private boolean dirty;
    static final String moduleFolderName = "DbxGui";
    static final String folderName = "DbxDebugBreakpoints";
    private static final String filename = "Breakpoints";
    private static final UserdirFile userdirFile = new UserdirFile("DbxGui", "DbxDebugBreakpoints", "Breakpoints");

    private DebuggerManager manager() {
        return DebuggerManager.get();
    }

    public BreakpointBag() {
        DebugTargetListener debugTargetListener = new DebugTargetListener();
        this.debugTargets.addRecordListListener(debugTargetListener);
        OptionListener optionListener = new OptionListener();
        DebuggerOption.SAVE_BREAKPOINTS.addPropertyChangeListener(optionListener);
    }

    public void cleanupBpts() {
        OptionSet globalOptions = DebuggerManager.get().globalOptions();
        boolean saveBreakpoints = DebuggerOption.SAVE_BREAKPOINTS.isEnabled(globalOptions);
        HashSet<Context> contexts = null;
        if (saveBreakpoints) {
            contexts = new HashSet<Context>();
            for (DebugTarget dt : this.debugTargets) {
                Context c = new Context(dt.getExecutable(), dt.getHostName());
                contexts.add(c);
            }
        }
        if (Log.Bpt.pertarget) {
            System.out.printf("BB.contentsChanged()::::::::::::::::::::::::\n", new Object[0]);
            if (contexts != null) {
                for (Context c : contexts) {
                    System.out.printf("\tCtx: %s\n", c);
                }
            }
            System.out.printf("\t---------------------------------\n", new Object[0]);
        }
        for (NativeBreakpoint b : this.getBreakpoints()) {
            b.discardUnused(contexts);
        }
    }

    public boolean anyEnabled() {
        for (NativeBreakpoint b : this.sessionBreakpoints(this.debugger())) {
            if (!b.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean anyDisabled() {
        for (NativeBreakpoint b : this.sessionBreakpoints(this.debugger())) {
            if (b.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private NativeDebugger debugger() {
        return this.manager().currentDebugger();
    }

    ModelChangeDelegator breakpointUpdater() {
        return this.manager().breakpointUpdater();
    }

    public NativeBreakpoint[] getBreakpoints() {
        NativeBreakpoint[] ba = new NativeBreakpoint[this.breakpoints.size()];
        return this.breakpoints.toArray(ba);
    }

    public NativeBreakpoint locateBreakpointAt(String src, int line, NativeDebugger debugger) {
        for (NativeBreakpoint b : this.breakpoints) {
            assert (b.isToplevel());
            if (debugger != null) {
                for (NativeBreakpoint m : b.getChildren()) {
                    for (NativeBreakpoint c : m.getChildren()) {
                        if (!c.matchesLineIn(src, line, debugger)) continue;
                        return c;
                    }
                }
                continue;
            }
            if (!b.matchesLine(src, line)) continue;
            return b;
        }
        return null;
    }

    void restore(NativeBreakpoint newBpt) {
        newBpt.restoredChild();
        assert (!this.breakpoints.contains(newBpt)) : "BB.restore(): bpt added redundantly";
        this.breakpoints.add(newBpt);
        this.manager().addBreakpoint(newBpt);
        newBpt.setUpdater(this.breakpointUpdater());
    }

    void add(NativeBreakpoint newBpt) {
        assert (newBpt.isToplevel());
        assert (!newBpt.isEditable());
        assert (!this.breakpoints.contains(newBpt)) : "BB.add(): bpt added redundantly";
        this.breakpoints.add(newBpt);
        this.manager().addBreakpoint(newBpt);
        newBpt.setUpdater(this.breakpointUpdater());
        for (NativeBreakpoint m : newBpt.getChildren()) {
            m.setUpdater(this.breakpointUpdater());
            for (NativeBreakpoint c : m.getChildren()) {
                c.setUpdater(this.breakpointUpdater());
            }
        }
        this.breakpointUpdater().treeChanged();
        this.dirty = true;
    }

    void remove(NativeBreakpoint oldBpt) {
        assert (oldBpt.isToplevel());
        assert (oldBpt.nChildren() == 0);
        oldBpt.cleanup();
        oldBpt.setDisposed(true);
        boolean removed = this.breakpoints.remove(oldBpt);
        assert (removed) : "BB.remove(): bpt to be removed not in bag";
        assert (!this.breakpoints.contains(oldBpt)) : "BB.remove(): bpt still there after removal";
        this.manager().removeBreakpoint(oldBpt);
        this.breakpointUpdater().treeChanged();
        this.dirty = true;
    }

    private List<NativeBreakpoint> sessionBreakpoints(NativeDebugger debugger) {
        assert (DebuggerManager.isPerTargetBpts());
        ArrayList<NativeBreakpoint> bpts = new ArrayList<NativeBreakpoint>();
        block0: for (NativeBreakpoint b : this.breakpoints) {
            for (NativeBreakpoint c : b.getChildren()) {
                if (c.getDebugger() != debugger) continue;
                bpts.add(c);
                continue block0;
            }
        }
        return bpts;
    }

    public void postEnableAllHandlers(boolean v) {
        if (this.debugger() != null) {
            this.debugger().bm().postEnableAllHandlers(v);
        }
    }

    public void postDeleteAllHandlers() {
        if (this.debugger() != null) {
            this.debugger().bm().postDeleteAllHandlers();
        }
    }

    public void restore() {
        BreakpointBag.doRestore(userdirFile, this);
    }

    static void doRestore(UserdirFile userdirFile, BreakpointBag bb) {
        BreakpointXMLReader xr = new BreakpointXMLReader(userdirFile, bb);
        try {
            xr.read();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        if (DebuggerManager.isPerTargetBpts()) {
            bb.cleanupBpts();
        }
        bb.breakpointUpdater().treeChanged();
    }

    private boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (NativeBreakpoint b : this.breakpoints) {
            if (!b.isDirty()) continue;
            return true;
        }
        return false;
    }

    private void clearDirty() {
        this.dirty = false;
        for (NativeBreakpoint b : this.breakpoints) {
            b.clearDirty();
        }
    }

    public void save() {
        BreakpointBag.doSave(userdirFile, this);
    }

    static void doSave(UserdirFile userdirFile, BreakpointBag bb) {
        if (!bb.isDirty()) {
            return;
        }
        BreakpointXMLWriter xw = new BreakpointXMLWriter(userdirFile, bb);
        try {
            xw.write();
            bb.clearDirty();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    private class OptionListener
    implements PropertyChangeListener {
        private OptionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (DebuggerOption.SAVE_BREAKPOINTS.caused(e)) {
                BreakpointBag.this.cleanupBpts();
            }
        }
    }

    private class DebugTargetListener
    implements RecordListListener {
        private DebugTargetListener() {
        }

        @Override
        public void contentsChanged(RecordListEvent e) {
            BreakpointBag.this.cleanupBpts();
        }
    }
}

