/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class Disassembly
implements StateModel.Listener {
    private final NativeDebuggerImpl debugger;
    protected static boolean opened = false;
    private static boolean opening = false;
    private static final List<DebuggerAnnotation> bptAnnotations = new ArrayList<DebuggerAnnotation>();
    private final BreakpointModel breakpointModel;
    private int disLength = 0;
    private DisText disText;
    protected RequestMode requestMode = RequestMode.FILE_SRC;
    private final BreakpointModel.Listener breakpointListener = new BreakpointModel.Listener(){

        @Override
        public void bptUpdated() {
            if (opened) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Disassembly.this.updateAnnotations(false);
                    }
                });
            }
        }
    };
    private final DocumentListener updateListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getOffset() + e.getLength() >= Disassembly.this.disLength) {
                final boolean dis = opening;
                opening = false;
                if (opened) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Disassembly.this.updateAnnotations(dis);
                        }
                    });
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    };

    protected Disassembly(NativeDebuggerImpl debugger, BreakpointModel breakpointModel) {
        this.debugger = debugger;
        this.breakpointModel = breakpointModel;
        breakpointModel.addListener(this.breakpointListener);
    }

    protected NativeDebuggerImpl getDebugger() {
        return this.debugger;
    }

    private void updateAnnotations(boolean andShow) {
        NativeBreakpoint[] bs;
        this.debugger.annotateDis(andShow || Disassembly.isInDisasm());
        for (DebuggerAnnotation annotation : bptAnnotations) {
            annotation.detach();
        }
        bptAnnotations.clear();
        for (NativeBreakpoint bpt : bs = this.breakpointModel.getBreakpoints()) {
            if (!(bpt instanceof InstructionBreakpoint)) continue;
            InstructionBreakpoint ibpt = (InstructionBreakpoint)bpt;
            try {
                int addressLine;
                DebuggerAnnotation[] annotations = ibpt.annotations();
                if (annotations.length == 0 || (addressLine = this.getAddressLine(annotations[0].getAddr())) < 0) continue;
                Line line = Disassembly.getLine(addressLine);
                bptAnnotations.add(new DebuggerAnnotation(null, ibpt.getAnnotationType(), line, 0L, true, ibpt));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static Disassembly getCurrent() {
        NativeDebugger currentDebugger = DebuggerManager.get().currentDebugger();
        if (currentDebugger != null) {
            return currentDebugger.getDisassembly();
        }
        return null;
    }

    public static boolean isInDisasm() {
        if (opened) {
            FileObject fobj = EditorContextDispatcher.getDefault().getCurrentFile();
            if (fobj == null) {
                fobj = EditorContextDispatcher.getDefault().getMostRecentFile();
            }
            if (fobj != null) {
                try {
                    return DataObject.find((FileObject)fobj).equals(Disassembly.getDataObject());
                }
                catch (DataObjectNotFoundException doe) {
                    Exceptions.printStackTrace((Throwable)doe);
                }
            }
        }
        return false;
    }

    public static boolean isDisasm(String url) {
        try {
            return Disassembly.getFileObject().getURL().toString().equals(url);
        }
        catch (FileStateInvalidException fsi) {
            Exceptions.printStackTrace((Throwable)fsi);
            return false;
        }
    }

    public static void open() {
        try {
            ReadOnlySupport ro = (ReadOnlySupport)Disassembly.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (ro != null) {
                ro.setReadOnly(true);
            }
            Disassembly.getDataObject().getNodeDelegate().setDisplayName(NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window"));
            final EditorCookie editorCookie = (EditorCookie)Disassembly.getDataObject().getCookie(EditorCookie.class);
            if (editorCookie instanceof EditorCookie.Observable) {
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("openedPanes".equals(evt.getPropertyName()) && editorCookie.getOpenedPanes() == null) {
                            opened = false;
                            ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                });
            }
            ((OpenCookie)Disassembly.getDataObject().getCookie(OpenCookie.class)).open();
            opening = true;
            opened = true;
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.debugger.registerDisassembly(dis);
                dis.reload();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    protected abstract void reload();

    public static void close() {
        try {
            ((CloseCookie)Disassembly.getDataObject().getCookie(CloseCookie.class)).close();
            opened = false;
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.debugger.registerDisassembly(null);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public static boolean isOpened() {
        return opened;
    }

    public static FileObject getFileObject() {
        return FileObjectHolder.FOBJ;
    }

    protected static DataObject getDataObject() {
        return DataObjectHolder.DOBJ;
    }

    static Line getLine(int lineNo) throws Exception {
        return EditorBridge.lineNumberToLine(Disassembly.getDataObject(), lineNo);
    }

    protected int getAddressLine(String address) {
        return this.getAddressLine(Address.parseAddr(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAddressLine(long address) {
        if (this.disText != null) {
            List lines;
            List list = lines = this.disText.lines;
            synchronized (list) {
                for (DisLine line : lines) {
                    try {
                        if (Address.parseAddr(line.getAddress()) != address) continue;
                        return line.getIdx();
                    }
                    catch (NumberFormatException e) {
                    }
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLineAddress(int idx) {
        if (this.disText != null) {
            List lines;
            List list = lines = this.disText.lines;
            synchronized (list) {
                for (DisLine line : lines) {
                    if (line.getIdx() != idx) continue;
                    return line.getAddress();
                }
            }
        }
        return null;
    }

    protected void attachUpdateListener() {
        DataObject dobj = Disassembly.getDataObject();
        StyledDocument doc = ((DataEditorSupport)dobj.getCookie(OpenCookie.class)).getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this.updateListener);
            doc.addDocumentListener(this.updateListener);
        }
    }

    protected final void setText(DisText text) {
        this.disText = text;
    }

    public void reset() {
        DisText emptyText = new DisText();
        emptyText.save();
        this.setText(emptyText);
    }

    protected class DisText {
        private final List<DisLine> lines = new ArrayList<DisLine>();
        private final StringBuilder data = new StringBuilder();

        public int size() {
            return this.lines.size();
        }

        public int getLength() {
            return this.data.length();
        }

        public void addLine(DisLine line) {
            this.lines.add(line);
            line.setIdx(this.lines.size());
            this.data.append(line.toString());
        }

        public void save() {
            Disassembly.this.disLength = this.getLength();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(Disassembly.getFileObject().getOutputStream());
                writer.write(this.data.toString());
                ((Writer)writer).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }
    }

    protected static class CommentLine
    implements DisLine {
        private final String text;

        public CommentLine(String text) {
            this.text = text;
        }

        @Override
        public String getAddress() {
            return "";
        }

        @Override
        public int getIdx() {
            return -1;
        }

        @Override
        public void setIdx(int idx) {
        }

        public String toString() {
            return this.text;
        }
    }

    protected static interface DisLine {
        public String getAddress();

        public int getIdx();

        public void setIdx(int var1);
    }

    private static class DataObjectHolder {
        static final DataObject DOBJ = DataObjectHolder.createDataObject();

        private DataObjectHolder() {
        }

        private static DataObject createDataObject() {
            try {
                return DataObject.find((FileObject)Disassembly.getFileObject());
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }

    private static class FileObjectHolder {
        static final FileObject FOBJ = FileObjectHolder.createFileObject();

        private FileObjectHolder() {
        }

        private static FileObject createFileObject() {
            try {
                return FileUtil.createMemoryFileSystem().getRoot().createData("disasm", "s");
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return null;
            }
        }
    }

    protected static enum RequestMode {
        FILE_SRC,
        FILE_NO_SRC,
        ADDRESS_SRC,
        ADDRESS_NO_SRC,
        NONE;

    }
}

