/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.CustomComponentVisualPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.EditableListModel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewLibraryDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaMELibsVisualPanel
extends JPanel {
    private static final String CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String DLD_DELETE_TITLE = "MSG_LibraryDeleteTitle";
    private static final String DLD_DELETE_MSG = "MSG_LibraryDeleteMsg";
    private static final String ACSN_LIB_PANEL = "ACSN_LibPanel";
    private static final String ACSD_LIB_PANEL = "ACSD_LibPanel";
    private JScrollPane jScrollPane1;
    private JButton myAddButton;
    private JLabel myDescLabel;
    private JList myLibDescList;
    private JButton myRemoveButton;
    private WizardDescriptor myWizardDescriptor;
    private WizardDescriptor myInnerDescriptor;

    public JavaMELibsVisualPanel() {
        this.initComponents();
        this.initAccessibility();
        this.myLibDescList.setModel(new LibraryListModel());
        this.myLibDescList.getSelectionModel().setSelectionMode(0);
        this.myLibDescList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JavaMELibsVisualPanel.this.updateRemoveButton();
            }
        });
        this.updateRemoveButton();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(JavaMELibsVisualPanel.class);
    }

    private void updateRemoveButton() {
        if (this.myLibDescList.isSelectionEmpty()) {
            this.myRemoveButton.setEnabled(false);
        } else {
            this.myRemoveButton.setEnabled(true);
        }
    }

    void readData(WizardDescriptor settings) {
        this.myWizardDescriptor = settings;
        List libNames = (List)this.myWizardDescriptor.getProperty("libNames");
        List libDisplayNames = (List)this.myWizardDescriptor.getProperty("libDisplayNames");
        LibraryListModel model = (LibraryListModel)this.myLibDescList.getModel();
        model.updateModel(libNames, libDisplayNames);
    }

    void storeData(WizardDescriptor settings) {
    }

    private void initComponents() {
        this.myDescLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.myLibDescList = new JList();
        this.myAddButton = new JButton();
        this.myRemoveButton = new JButton();
        this.myDescLabel.setLabelFor(this.myLibDescList);
        Mnemonics.setLocalizedText((JLabel)this.myDescLabel, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"LBL_AddedLibDescriptors"));
        this.jScrollPane1.setViewportView(this.myLibDescList);
        this.myLibDescList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_DescriptorsList"));
        this.myLibDescList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSD_DescriptorsList"));
        Mnemonics.setLocalizedText((AbstractButton)this.myAddButton, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"BTN_AddLibDesc"));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaMELibsVisualPanel.this.addPressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.myRemoveButton, (String)NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"BTN_LibRemove"));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaMELibsVisualPanel.this.removePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myDescLabel).addComponent(this.jScrollPane1, -1, 330, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.myAddButton, -1, -1, Short.MAX_VALUE).addComponent(this.myRemoveButton, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myDescLabel).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myRemoveButton).addContainerGap(230, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 286, Short.MAX_VALUE))));
        this.myDescLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_DescLabel"));
        this.myDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ASCD_DescLabel"));
        this.myAddButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibAdd"));
        this.myAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibAdd"));
        this.myRemoveButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibRemove"));
        this.myRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)"ACSN_LibRemove"));
    }

    private void addPressed(ActionEvent evt) {
        NewLibraryDescriptor iterator = new NewLibraryDescriptor(this.myWizardDescriptor);
        this.myInnerDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        this.myInnerDescriptor.putProperty(AUTO_WIZARD_STYLE, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_DISPLAYED, (Object)true);
        this.myInnerDescriptor.putProperty(CONTENT_NUMBERED, (Object)true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.myInnerDescriptor);
        dialog.setVisible(true);
        this.readData(this.myWizardDescriptor);
    }

    private void removePressed(ActionEvent evt) {
        int index = this.myLibDescList.getSelectedIndex();
        List libNames = (List)this.myWizardDescriptor.getProperty("libNames");
        List libDisplayNames = (List)this.myWizardDescriptor.getProperty("libDisplayNames");
        String name = (String)libNames.get(index);
        String title = JavaMELibsVisualPanel.getMessage(DLD_DELETE_TITLE, new Object[0]);
        String msg = JavaMELibsVisualPanel.getMessage(DLD_DELETE_MSG, name);
        if (!UIUtils.userConfirmOkCancel(title, msg)) {
            return;
        }
        ((LibraryListModel)this.myLibDescList.getModel()).remove(index);
        libNames.remove(index);
        libDisplayNames.remove(index);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSN_LIB_PANEL));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomComponentVisualPanel.class, (String)ACSD_LIB_PANEL));
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(JavaMELibsVisualPanel.class, (String)key, (Object[])args);
    }

    private class LibraryListModel
    extends EditableListModel {
        private LibraryListModel() {
        }

        public void updateModel(List<String> libNames, List<String> libDisplayNames) {
            this.removeAllElements();
            if (libNames == null || libDisplayNames == null) {
                return;
            }
            assert (libNames.size() == libDisplayNames.size()) : "libraries data is not consistent";
            Iterator<String> itN = libNames.iterator();
            Iterator<String> itDN = libDisplayNames.iterator();
            while (itN.hasNext()) {
                String name = itN.next();
                String displayName = itDN.next();
                this.addElement(displayName + " [ " + name + " ]");
            }
        }
    }
}

