/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.MetaModelSupport;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.actions.AbstractInjectableAction;
import org.netbeans.modules.web.beans.navigation.actions.AbstractWebBeansAction;
import org.netbeans.modules.web.beans.navigation.actions.DecoratoresActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.EventsActionStartegy;
import org.netbeans.modules.web.beans.navigation.actions.InjectablesActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.InterceptorsActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.ObserversActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InspectCDIAtCaretAction
extends AbstractWebBeansAction {
    private static final long serialVersionUID = -4505119467924502377L;
    private static final String INSPECT_CDI_AT_CARET = "inspect-cdi-at-caret";
    private static final String INSPECT_CDI_AT_CARET_POPUP = "inspect-cdi-at-caret-popup";
    private List<ModelActionStrategy> myStrategies = new ArrayList<ModelActionStrategy>(4);

    public InspectCDIAtCaretAction() {
        super(NbBundle.getMessage(InspectCDIAtCaretAction.class, (String)INSPECT_CDI_AT_CARET));
        this.myStrategies.add(new ObserversActionStrategy());
        this.myStrategies.add(new InjectablesActionStrategy());
        this.myStrategies.add(new DecoratoresActionStrategy());
        this.myStrategies.add(new InterceptorsActionStrategy());
        this.myStrategies.add(new EventsActionStartegy());
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, MetadataModel<WebBeansModel> metaModel, Object[] subject, JTextComponent component, FileObject fileObject) {
        ModelActionStrategy.InspectActionId id = (ModelActionStrategy.InspectActionId)((Object)subject[2]);
        for (ModelActionStrategy strategy : this.myStrategies) {
            if (!strategy.isApplicable(id) || !strategy.isApplicable(model, subject)) continue;
            strategy.invokeModelAction(model, metaModel, subject, component, fileObject);
            return;
        }
    }

    @Override
    protected String getActionCommand() {
        return INSPECT_CDI_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return INSPECT_CDI_AT_CARET_POPUP;
    }

    public void actionPerformed(ActionEvent event, final JTextComponent component) {
        if (component == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final FileObject fileObject = NbEditorUtilities.getFileObject((Document)component.getDocument());
        if (fileObject == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        MetaModelSupport support = new MetaModelSupport(project);
        final MetadataModel<WebBeansModel> metaModel = support.getMetaModel();
        if (metaModel == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final Object[] subject = new Object[3];
        if (!this.findContext(component, subject)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_NoCdiContext"));
            return;
        }
        try {
            metaModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) throws Exception {
                    InspectCDIAtCaretAction.this.modelAcessAction(model, (MetadataModel<WebBeansModel>)metaModel, subject, component, fileObject);
                    return null;
                }
            });
        }
        catch (MetadataModelException e) {
            Logger.getLogger(AbstractInjectableAction.class.getName()).log(Level.INFO, e.getMessage(), e);
        }
        catch (IOException e) {
            Logger.getLogger(AbstractInjectableAction.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected boolean findContext(JTextComponent component, Object[] subject) {
        return WebBeansActionHelper.getVariableElementAtDot(component, subject, false) || WebBeansActionHelper.getContextEventInjectionAtDot(component, subject) || WebBeansActionHelper.getMethodAtDot(component, subject) || WebBeansActionHelper.getClassAtDot(component, subject);
    }
}

