/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.annotation;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.CdiAnnotationAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.ScopeVerifier;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.openide.util.NbBundle;

public class ScopeAnalyzer
implements AnnotationElementAnalyzer.AnnotationAnalyzer {
    @Override
    public void analyze(TypeElement element, AtomicBoolean cancel, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        boolean isScope = AnnotationUtil.hasAnnotation(element, AnnotationUtil.SCOPE_FQN, compInfo);
        boolean isNormalScope = AnnotationUtil.hasAnnotation(element, "javax.enterprise.context.NormalScope", compInfo);
        if (isScope || isNormalScope) {
            result.requireCdiEnabled(element);
            ScopeTargetAnalyzer analyzer = new ScopeTargetAnalyzer(element, result, isNormalScope);
            if (cancel.get()) {
                return;
            }
            if (!analyzer.hasRuntimeRetention()) {
                result.addError(element, NbBundle.getMessage(ScopeAnalyzer.class, (String)"ERR_IncorrectRuntimeRetention"));
            }
            if (cancel.get()) {
                return;
            }
            if (!analyzer.hasTarget()) {
                result.addError(element, NbBundle.getMessage(ScopeAnalyzer.class, (String)"ERR_IncorrectScopeTarget"));
            }
        }
    }

    private static class ScopeTargetAnalyzer
    extends CdiAnnotationAnalyzer {
        private boolean isNormalScope;

        ScopeTargetAnalyzer(TypeElement element, CdiAnalysisResult result, boolean normalScope) {
            super(element, result);
            this.isNormalScope = normalScope;
        }

        @Override
        protected TargetVerifier getTargetVerifier() {
            return ScopeVerifier.getInstance();
        }

        @Override
        protected String getCdiMetaAnnotation() {
            if (this.isNormalScope) {
                return "NormalScope";
            }
            return AnnotationUtil.SCOPE;
        }
    }
}

